/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.openarchitectureware.core.builder.OawBuilder;
import org.openarchitectureware.core.builder.OawNature;
import org.openarchitectureware.internal.OawLog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseHelper {
    public static final String ISO_8859_1 = "iso-8859-1";

    public static IProject createOAWProject(final String projectName, List<String> srcFolders, List<IProject> referencedProjects, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor, final Shell theShell) {
        IProject project = null;
        try {
            progressMonitor.beginTask("", 10);
            progressMonitor.subTask("Creating project " + projectName);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            project = workspace.getRoot().getProject(projectName);
            if (project.exists()) {
                final boolean[] result = new boolean[1];
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        result[0] = MessageDialog.openQuestion((Shell)theShell, (String)("Do you want to overwrite the project " + projectName), (String)("Note that everything inside the project '" + projectName + "' will be deleted if you confirm this dialog."));
                    }
                });
                if (result[0]) {
                    project.delete(true, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                } else {
                    return null;
                }
            }
            try {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
                projectDescription.setLocation(null);
                project.create(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
                if (referencedProjects.size() != 0) {
                    projectDescription.setReferencedProjects(referencedProjects.toArray(new IProject[referencedProjects.size()]));
                    for (IProject referencedProject : referencedProjects) {
                        IClasspathEntry referencedProjectClasspathEntry = JavaCore.newProjectEntry((IPath)referencedProject.getFullPath());
                        classpathEntries.add(referencedProjectClasspathEntry);
                    }
                }
                projectDescription.setNatureIds(new String[]{"org.eclipse.jdt.core.javanature", "org.eclipse.pde.PluginNature", OawNature.NATURE_ID});
                ICommand java = projectDescription.newCommand();
                java.setBuilderName("org.eclipse.jdt.core.javabuilder");
                ICommand manifest = projectDescription.newCommand();
                manifest.setBuilderName("org.eclipse.pde.ManifestBuilder");
                ICommand schema = projectDescription.newCommand();
                schema.setBuilderName("org.eclipse.pde.SchemaBuilder");
                ICommand oaw = projectDescription.newCommand();
                oaw.setBuilderName(OawBuilder.getBUILDER_ID());
                projectDescription.setBuildSpec(new ICommand[]{java, manifest, schema, oaw});
                project.open((IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                project.setDescription(projectDescription, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                Collections.reverse(srcFolders);
                for (String src : srcFolders) {
                    IFolder srcContainer = project.getFolder(src);
                    if (!srcContainer.exists()) {
                        srcContainer.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                    }
                    IClasspathEntry srcClasspathEntry = JavaCore.newSourceEntry((IPath)srcContainer.getFullPath());
                    classpathEntries.add(0, srcClasspathEntry);
                }
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5")));
                classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins")));
                javaProject.setRawClasspath(classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                javaProject.setOutputLocation((IPath)new Path("/" + projectName + "/bin"), (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
                EclipseHelper.createManifest(projectName, requiredBundles, exportedPackages, progressMonitor, project);
                EclipseHelper.createBuildProps(progressMonitor, project, srcFolders);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                OawLog.logError(exception);
            }
        }
        finally {
            progressMonitor.done();
        }
        return project;
    }

    public static IFile createFile(String name, IContainer container, String content, IProgressMonitor progressMonitor) {
        IFile file = container.getFile((IPath)new Path(name));
        EclipseHelper.assertExist(file.getParent());
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(content.getBytes(file.getCharset()));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, progressMonitor);
            } else {
                file.create((InputStream)stream, true, progressMonitor);
            }
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            OawLog.logError(e);
        }
        progressMonitor.worked(1);
        return file;
    }

    public static IFile createFile(String name, IContainer container, String content, String charSet, IProgressMonitor progressMonitor) throws CoreException {
        IFile file = EclipseHelper.createFile(name, container, content, progressMonitor);
        if (file != null && charSet != null) {
            file.setCharset(charSet, progressMonitor);
        }
        return file;
    }

    private static void createBuildProps(IProgressMonitor progressMonitor, IProject project, List<String> srcFolders) {
        StringBuilder bpContent = new StringBuilder("source.. = ");
        Iterator<String> iterator = srcFolders.iterator();
        while (iterator.hasNext()) {
            bpContent.append(iterator.next()).append('/');
            if (!iterator.hasNext()) continue;
            bpContent.append(",");
        }
        bpContent.append("\n");
        bpContent.append("bin.includes = META-INF/,.\n");
        EclipseHelper.createFile("build.properties", (IContainer)project, bpContent.toString(), progressMonitor);
    }

    private static void createManifest(String projectName, Set<String> requiredBundles, List<String> exportedPackages, IProgressMonitor progressMonitor, IProject project) throws CoreException {
        StringBuilder maniContent = new StringBuilder("Manifest-Version: 1.0\n");
        maniContent.append("Bundle-ManifestVersion: 2\n");
        maniContent.append("Bundle-Name: " + projectName + "\n");
        maniContent.append("Bundle-SymbolicName: " + projectName + "; singleton:=true\n");
        maniContent.append("Bundle-Version: 1.0.0\n");
        maniContent.append("Require-Bundle: ");
        for (String entry : requiredBundles) {
            maniContent.append(" " + entry + ",\n");
        }
        maniContent.append(" org.openarchitectureware.dependencies\n");
        if (exportedPackages != null && !exportedPackages.isEmpty()) {
            maniContent.append("Require-Bundle: " + exportedPackages.get(0));
            int i = 1;
            int x = exportedPackages.size();
            while (i < x) {
                maniContent.append(",\n " + exportedPackages.get(i));
                ++i;
            }
            maniContent.append("\n");
        }
        maniContent.append("Bundle-RequiredExecutionEnvironment: J2SE-1.5\r\n");
        IFolder metaInf = project.getFolder("META-INF");
        metaInf.create(false, true, (IProgressMonitor)new SubProgressMonitor(progressMonitor, 1));
        EclipseHelper.createFile("MANIFEST.MF", (IContainer)metaInf, maniContent.toString(), progressMonitor);
    }

    public static IFile createFile(String name, IContainer container, URL contentUrl, IProgressMonitor progressMonitor) {
        IFile file;
        block16: {
            file = container.getFile((IPath)new Path(name));
            InputStream inputStream = null;
            try {
                try {
                    inputStream = contentUrl.openStream();
                    if (file.exists()) {
                        file.setContents(inputStream, true, true, progressMonitor);
                    } else {
                        file.create(inputStream, true, progressMonitor);
                    }
                    inputStream.close();
                }
                catch (Exception e) {
                    OawLog.logError(e);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e2) {
                            OawLog.logError(e2);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        OawLog.logError(e);
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    OawLog.logError(e);
                }
            }
        }
        progressMonitor.worked(1);
        return file;
    }

    private static void assertExist(IContainer c) {
        if (!c.exists()) {
            if (!c.getParent().exists()) {
                EclipseHelper.assertExist(c.getParent());
            }
            if (c instanceof IFolder) {
                try {
                    ((IFolder)c).create(false, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    OawLog.logError(e);
                }
            }
        }
    }

    public static void openFileToEdit(Shell s, final IFile file) {
        s.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    OawLog.logError(e);
                }
            }
        });
    }
}

