/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Collection;
import ahc.collection.Map;
import ahc.collection.MapHelper;
import ahc.collection.Pair;
import ahc.collection.Set;
import ahc.exception.TunnelingException;

public abstract class DoubleKeyCache {
    private final Map _cache = MapHelper.createMap();

    public Object get(Object key1, Object key2) {
        Pair key = new Pair(key1, key2);
        Object result = this._cache.get(key);
        try {
            if (result == null) {
                result = this.createNew(key1, key2);
                this._cache.put(key, result);
            }
        }
        catch (Exception e) {
            throw TunnelingException.create(e);
        }
        return result;
    }

    public Set getKeys() {
        return this._cache.keys();
    }

    public Collection getValues() {
        return this._cache.vals();
    }

    public Map getMap() {
        return this._cache;
    }

    protected abstract Object createNew(Object var1, Object var2) throws Exception;
}

