/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Collection;
import ahc.collection.GenericCollection;
import ahc.collection.Iterator;
import ahc.collection.Map;
import ahc.collection.Set;
import ahc.collection.access.AccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.store.AbstractStore;
import ahc.collection.store.Store;
import java.util.List;
import java.util.Map;

public class GenericMap
implements Map {
    private final Store _store;
    private final AccessStrategy _accessStrat;
    private final EqualityStrategy _keyEqualityStrategy;
    private final EqualityStrategy _valueEqualityStrategy;

    public GenericMap(Store store, AccessStrategy accessStrat) {
        this(store, accessStrat, store.getEqualityStrategy());
    }

    public GenericMap(Store store, AccessStrategy accessStrat, EqualityStrategy valueEqualityStrategy) {
        this._store = store;
        this._accessStrat = accessStrat;
        this._keyEqualityStrategy = store.getEqualityStrategy();
        this._valueEqualityStrategy = valueEqualityStrategy;
        this._store.setEqualityStrategy(new EntryEqualityStrategy(this._keyEqualityStrategy));
    }

    private GenericMap(Store store, AccessStrategy accessStrat, EqualityStrategy valueEqualityStrategy, boolean dummy) {
        this._store = store;
        this._accessStrat = accessStrat;
        this._keyEqualityStrategy = ((EntryEqualityStrategy)store.getEqualityStrategy())._inner;
        this._valueEqualityStrategy = valueEqualityStrategy;
    }

    public EqualityStrategy getValueEqualityStrategy() {
        return this._valueEqualityStrategy;
    }

    public int size() {
        return this._store.size();
    }

    public boolean isEmpty() {
        return this._store.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.findKey(key) != null;
    }

    public boolean containsValue(Object value) {
        Iterator iter = this._accessStrat.begin(this._store);
        while (iter.hasCurrent()) {
            if (this._valueEqualityStrategy.equals(value, ((EntryImpl)iter.current())._value)) {
                return true;
            }
            iter.next();
        }
        return false;
    }

    public Object get(Object key) {
        Iterator iter = this.findKey(key);
        return iter == null ? null : ((EntryImpl)iter.current())._value;
    }

    public Object put(Object key, Object value) {
        Object result;
        EntryImpl newEntry = new EntryImpl(key, value);
        Iterator old = this._accessStrat.first(this._store, newEntry);
        Object v0 = result = old == null ? null : ((Map.Entry)old.current()).getValue();
        if (!this._accessStrat.add(this._store, newEntry)) {
            old.remove();
            this._accessStrat.add(this._store, newEntry);
        }
        return result;
    }

    protected Iterator findKey(Object key) {
        return this._accessStrat.first(this._store, new EntryImpl(key, null));
    }

    public Object remove(Object key) {
        Object result = null;
        Iterator iter = null;
        while ((iter = this.findKey(key)) != null) {
            result = ((EntryImpl)iter.current())._value;
            iter.remove();
        }
        return result;
    }

    public void putAll(java.util.Map map) {
        java.util.Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry current = iter.next();
            this.put(current.getKey(), current.getValue());
        }
    }

    public void putAll(List keys, List values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("keys and values have different sizes");
        }
        java.util.Iterator iterKeys = keys.iterator();
        java.util.Iterator iterValues = values.iterator();
        while (iterKeys.hasNext()) {
            this.put(iterKeys.next(), iterValues.next());
        }
    }

    public void putAll(Object[] keys, Object[] values) {
        if (keys == null || values == null) {
            return;
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values have different sizes");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public void clear() {
        this._store.clear();
    }

    public Set keys() {
        return new GenericCollection(new KeyStore(), this._accessStrat);
    }

    public java.util.Set keySet() {
        return this.keys();
    }

    public Collection vals() {
        return new GenericCollection(new ValueStore(), this._accessStrat);
    }

    public java.util.Collection values() {
        return this.vals();
    }

    public Set entries() {
        return new GenericCollection(new EntrySetStore(), this._accessStrat);
    }

    public java.util.Set entrySet() {
        return this.entries();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("[");
        boolean first = true;
        Iterator iter = this.entries().begin();
        while (iter.hasCurrent()) {
            if (!first) {
                result.append(", ");
            }
            first = false;
            result.append(((Map.Entry)iter.current()).getKey() + "->" + ((Map.Entry)iter.current()).getValue());
            iter.next();
        }
        result.append("]");
        return result.toString();
    }

    public Map cloneEmpty() {
        return new GenericMap(this._store.cloneEmpty(), this._accessStrat, this._valueEqualityStrategy, true);
    }

    public Object clone() {
        return new GenericMap((Store)this._store.clone(), this._accessStrat, this._valueEqualityStrategy, true);
    }

    public Map immutableView() {
        return new GenericMap(this._store.immutableView(), this._accessStrat, this._valueEqualityStrategy, true);
    }

    private ValueCollectionIterator createValueCollectionIterator(Iterator inner) {
        return inner != null ? new ValueCollectionIterator(inner) : null;
    }

    private KeySetIterator createKeySetIterator(Iterator inner) {
        return inner != null ? new KeySetIterator(inner) : null;
    }

    private class EntryImpl
    implements Map.Entry {
        private final Object _key;
        private Object _value;

        public EntryImpl(Object key, Object value) {
            this._key = key;
            this._value = value;
        }

        public Object getKey() {
            return this._key;
        }

        public Object getValue() {
            return this._value;
        }

        public Object setValue(Object value) {
            Object old = this._value;
            this._value = value;
            return old;
        }

        public String toString() {
            return "" + this._key + "->" + this._value;
        }

        public int hashCode() {
            return GenericMap.this._keyEqualityStrategy.hashCode(this._key) ^ GenericMap.this._valueEqualityStrategy.hashCode(this._value);
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry other = (Map.Entry)o;
            return GenericMap.this._keyEqualityStrategy.equals(this._key, other.getKey()) && GenericMap.this._valueEqualityStrategy.equals(this._value, other.getValue());
        }
    }

    private class EntryEqualityStrategy
    implements EqualityStrategy {
        private final EqualityStrategy _inner;

        public EntryEqualityStrategy(EqualityStrategy inner) {
            this._inner = inner;
        }

        public boolean equals(Object o1, Object o2) {
            Map.Entry e1 = (Map.Entry)o1;
            Map.Entry e2 = (Map.Entry)o2;
            return this._inner.equals(e1.getKey(), e2.getKey());
        }

        public int hashCode(Object o) {
            Map.Entry e = (Map.Entry)o;
            return this._inner.hashCode(e.getKey());
        }
    }

    private abstract class UnmodifyableIterator
    implements Iterator {
        protected final Iterator _inner;

        Object safeKey(Map.Entry entry) {
            if (entry == null) {
                return null;
            }
            return entry.getKey();
        }

        Object safeValue(Map.Entry entry) {
            if (entry == null) {
                return null;
            }
            return entry.getValue();
        }

        public UnmodifyableIterator(Iterator inner) {
            this._inner = inner;
        }

        public boolean hasCurrent() {
            return this._inner.hasCurrent();
        }

        public int currentIndex() {
            return this._inner.currentIndex();
        }

        public boolean replace(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this._inner.hasNext();
        }

        public boolean hasPrevious() {
            return this._inner.hasPrevious();
        }

        public int nextIndex() {
            return this._inner.nextIndex();
        }

        public Object previous(int n) {
            throw new UnsupportedOperationException();
        }

        public Object previous() {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            return this._inner.previousIndex();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySetIterator
    extends UnmodifyableIterator {
        private KeySetIterator(Iterator inner) {
            super(inner);
        }

        public Object current() {
            return this.safeKey((Map.Entry)this._inner.current());
        }

        public Object next() {
            return this.safeKey((Map.Entry)this._inner.next());
        }

        public Object next(int n) {
            return this.safeKey((Map.Entry)this._inner.next(n));
        }
    }

    private class KeyStore
    extends InternalMapStore {
        public KeyStore() {
            super(GenericMap.this._keyEqualityStrategy);
        }

        public Iterator first(Object o) {
            return GenericMap.this.createKeySetIterator(GenericMap.this._store.first(new EntryImpl(o, null)));
        }

        public Iterator before() {
            return GenericMap.this.createKeySetIterator(GenericMap.this._store.before());
        }

        public Store cloneEmpty() {
            Store result = GenericMap.this._store.cloneEmpty();
            result.setEqualityStrategy(GenericMap.this._keyEqualityStrategy);
            return result;
        }
    }

    private class ValueCollectionIterator
    extends UnmodifyableIterator {
        private ValueCollectionIterator(Iterator inner) {
            super(inner);
        }

        public Object current() {
            return this.safeValue((Map.Entry)this._inner.current());
        }

        public Object next() {
            return this.safeValue((Map.Entry)this._inner.next());
        }

        public Object next(int n) {
            return this.safeValue((Map.Entry)this._inner.next(n));
        }
    }

    private class ValueStore
    extends InternalMapStore {
        public ValueStore() {
            super(GenericMap.this._valueEqualityStrategy);
        }

        public Iterator first(Object o) {
            Iterator iter = GenericMap.this._store.begin();
            while (iter.hasCurrent()) {
                if (GenericMap.this._valueEqualityStrategy.equals(o, ((Map.Entry)iter.current()).getValue())) {
                    return new ValueCollectionIterator(iter);
                }
                iter.next();
            }
            return null;
        }

        public Iterator before() {
            return GenericMap.this.createValueCollectionIterator(GenericMap.this._store.before());
        }

        public Store cloneEmpty() {
            Store result = GenericMap.this._store.cloneEmpty();
            result.setEqualityStrategy(GenericMap.this._valueEqualityStrategy);
            return result;
        }
    }

    private class EntrySetIterator
    extends UnmodifyableIterator {
        public EntrySetIterator(Iterator inner) {
            super(inner);
        }

        public Object current() {
            return this._inner.current();
        }

        public Object next() {
            return this._inner.next();
        }

        public Object next(int n) {
            return this._inner.next(n);
        }
    }

    private abstract class InternalMapStore
    extends AbstractStore {
        public InternalMapStore(EqualityStrategy eqStrat) {
            super(eqStrat);
        }

        public abstract Iterator first(Object var1);

        public boolean preservesOrdering() {
            return false;
        }

        public boolean isSorted() {
            return false;
        }

        public void prepend(Object o) {
            throw new UnsupportedOperationException();
        }

        public void append(Object o) {
            throw new UnsupportedOperationException();
        }

        public Iterator begin() {
            Iterator result = this.before();
            result.next();
            return result;
        }

        public Iterator end() {
            throw new UnsupportedOperationException();
        }

        public Iterator after() {
            throw new UnsupportedOperationException();
        }

        public Iterator iter(int n) {
            throw new UnsupportedOperationException();
        }

        public void compactSize() {
        }

        public int size() {
            return GenericMap.this._store.size();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public Store immutableView() {
            return this;
        }
    }

    private class EntrySetStore
    extends InternalMapStore {
        public EntrySetStore() {
            super(GenericMap.this._store.getEqualityStrategy());
        }

        public Iterator first(Object o) {
            if (o == null || !(o instanceof Map.Entry)) {
                return null;
            }
            Map.Entry entry = (Map.Entry)o;
            Iterator iter = GenericMap.this._store.begin();
            while (iter.hasCurrent()) {
                Map.Entry curEntry = (Map.Entry)iter.current();
                if (GenericMap.this._keyEqualityStrategy.equals(entry.getKey(), curEntry.getKey()) && GenericMap.this._valueEqualityStrategy.equals(entry.getValue(), curEntry.getValue())) {
                    return new EntrySetIterator(iter);
                }
                iter.next();
            }
            return null;
        }

        public Iterator before() {
            return new EntrySetIterator(GenericMap.this._store.before());
        }

        public Store cloneEmpty() {
            return GenericMap.this._store.cloneEmpty();
        }
    }
}

