/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Collection;
import ahc.collection.Iterator;
import ahc.collection.List;
import ahc.collection.ListHelper;
import ahc.collection.Map;
import ahc.collection.MultiMap;
import ahc.collection.Set;
import ahc.collection.equality.EqualityStrategy;

public class GenericMultiMap
implements MultiMap {
    private final Map _map;
    private int _size = 0;

    public GenericMultiMap(Map map) {
        if (!map.isEmpty()) {
            throw new IllegalArgumentException("map must be empty");
        }
        this._map = map;
    }

    private GenericMultiMap(Map map, int size) {
        this._map = map;
        this._size = size;
    }

    public EqualityStrategy getValueEqualityStrategy() {
        return this._map.getValueEqualityStrategy();
    }

    public int getCount(Object key) {
        List l = this.getAll(key);
        return l == null ? 0 : l.size();
    }

    public List getAll(Object key) {
        List result = (List)this.get(key);
        return result != null ? result : this.createEmptyList();
    }

    public int size() {
        return this._size;
    }

    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.vals().contains(value);
    }

    public Object get(Object key) {
        return this._map.get(key);
    }

    private List createEmptyList() {
        return ListHelper.createArrayList(this.getValueEqualityStrategy(), ListHelper.ACCESS_TRANSPARENT);
    }

    public Object put(Object key, Object value) {
        List l = (List)this._map.get(key);
        if (l == null) {
            l = this.createEmptyList();
            this._map.put(key, l);
        }
        l.append(value);
        ++this._size;
        return null;
    }

    public Object remove(Object key) {
        this._size -= this.getCount(key);
        return this._map.remove(key);
    }

    public boolean remove(Object key, Object value) {
        List l = this.getAll(key);
        if (l == null) {
            return false;
        }
        --this._size;
        return l.remove(value);
    }

    public void putAll(java.util.Map t) {
        java.util.Iterator iter = t.keySet().iterator();
        while (iter.hasNext()) {
            Object curKey = iter.next();
            this.put(curKey, t.get(curKey));
        }
    }

    public void putAll(MultiMap m) {
        java.util.Iterator iter = m.keySet().iterator();
        while (iter.hasNext()) {
            Object curKey = iter.next();
            Iterator iter2 = m.getAll(curKey).begin();
            while (iter2.hasCurrent()) {
                this.put(curKey, iter2.current());
                iter2.next();
            }
        }
    }

    public void putAll(java.util.List keys, java.util.List values) {
        if (keys.size() != values.size()) {
            throw new IllegalArgumentException("keys and values have different sizes");
        }
        java.util.Iterator iterKeys = keys.iterator();
        java.util.Iterator iterValues = values.iterator();
        while (iterKeys.hasNext()) {
            this.put(iterKeys.next(), iterValues.next());
        }
    }

    public void putAll(Object[] keys, Object[] values) {
        if (keys == null || values == null) {
            return;
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("keys and values have different sizes");
        }
        for (int i = 0; i < keys.length; ++i) {
            this.put(keys[i], values[i]);
        }
    }

    public void clear() {
        this._map.clear();
        this._size = 0;
    }

    public Set keys() {
        return this._map.keys();
    }

    public Collection vals() {
        List result = ListHelper.createArrayList(this.getValueEqualityStrategy(), ListHelper.ACCESS_TRANSPARENT);
        Iterator iter = this._map.keys().begin();
        while (iter.hasCurrent()) {
            result.addAll(this.getAll(iter.current()));
            iter.next();
        }
        return result;
    }

    public Set entries() {
        return this._map.entries();
    }

    public java.util.Set keySet() {
        return this.keys();
    }

    public java.util.Collection values() {
        return this.vals();
    }

    public java.util.Set entrySet() {
        return this.entries();
    }

    public Map cloneEmpty() {
        return this.cloneEmptyMultiMap();
    }

    public MultiMap cloneEmptyMultiMap() {
        return new GenericMultiMap(this._map.cloneEmpty());
    }

    public Object clone() {
        return new GenericMultiMap((Map)this._map.clone(), this._size);
    }

    public Map immutableView() {
        return new GenericMultiMap(this._map.immutableView());
    }
}

