/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.Iterator;
import ahc.collection.Pair;
import ahc.collection.PriorityComparator;
import ahc.collection.PriorityQueue;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.GenericAccessStrategy;
import ahc.collection.store.Store;
import ahc.exception.TimeoutException;
import ahc.util.NaturalOrderComparator;
import ahc.util.SynchronizedParamGetCode;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class GenericPriorityQueue
implements PriorityQueue {
    private final Store _store;
    private final boolean _isThreadSafe;
    private final Comparator _comparator;
    private final AccessStrategy _accessStrategy;
    private Object _threshold = null;
    final SynchronizedParamGetCode _peekCode;
    final SynchronizedParamGetCode _removeCode;

    public GenericPriorityQueue(Store store, boolean threadSafe) {
        this(store, NaturalOrderComparator.INSTANCE, threadSafe);
    }

    public GenericPriorityQueue(Store store, Comparator comparator, boolean threadSafe) {
        this(store, comparator, threadSafe, false);
        if (!store.isEmpty()) {
            throw new IllegalArgumentException("store must be empty on collection creation");
        }
    }

    private GenericPriorityQueue(Store store, Comparator comparator, boolean threadSafe, boolean dummy) {
        if (!store.preservesOrdering() && !store.isSorted()) {
            throw new IllegalArgumentException("the store for a PriorityQueue must be either sorted or preserve order");
        }
        this._store = store;
        this._isThreadSafe = threadSafe;
        this._comparator = comparator;
        this._accessStrategy = new GenericAccessStrategy(new PriorityComparator(comparator), false);
        this._removeCode = new SynchronizedParamGetCode(this._store){

            public boolean precondition(Object threshold) {
                return !GenericPriorityQueue.this.isEmpty(threshold);
            }

            public Object getUnsynchronized(Object minPriority) {
                Iterator iter = GenericPriorityQueue.this._accessStrategy.end(GenericPriorityQueue.this._store);
                if (!iter.hasCurrent()) {
                    throw new NoSuchElementException();
                }
                Pair result = (Pair)iter.current();
                if (!GenericPriorityQueue.this.passesThreshold(result.getFirst(), minPriority)) {
                    throw new NoSuchElementException();
                }
                iter.remove();
                return result.getSecond();
            }
        };
        this._peekCode = new SynchronizedParamGetCode(this._store){

            public boolean precondition(Object threshold) {
                return !GenericPriorityQueue.this.isEmpty(threshold);
            }

            public Object getUnsynchronized(Object minPriority) {
                if (GenericPriorityQueue.this._store.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Iterator iter = GenericPriorityQueue.this._accessStrategy.end(GenericPriorityQueue.this._store);
                Pair result = (Pair)iter.current();
                if (!GenericPriorityQueue.this.passesThreshold(result.getFirst(), minPriority)) {
                    throw new NoSuchElementException();
                }
                return result.getSecond();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object obj, Object priority) {
        if (this._isThreadSafe) {
            Store store = this._store;
            synchronized (store) {
                if (!this.passesThreshold(priority)) {
                    return false;
                }
                this._store.notify();
                return this._accessStrategy.prepend(this._store, new Pair(priority, obj));
            }
        }
        if (!this.passesThreshold(priority)) {
            return false;
        }
        return this._accessStrategy.prepend(this._store, new Pair(priority, obj));
    }

    private boolean passesThreshold(Object priority) {
        if (priority == null) {
            throw new IllegalArgumentException("priority must not be null");
        }
        return this.passesThreshold(priority, this._threshold);
    }

    private boolean passesThreshold(Object priority, Object threshold) {
        if (threshold == null) {
            return true;
        }
        return this._comparator.compare(priority, threshold) >= 0;
    }

    public Object remove() {
        return this.remove(null);
    }

    public Object remove(boolean blocking) throws InterruptedException {
        return this.remove(null, blocking);
    }

    public Object remove(int timeoutMillis) throws InterruptedException, TimeoutException {
        return this.remove(null, timeoutMillis);
    }

    public Object remove(Object minPriority) {
        if (this._isThreadSafe) {
            throw new IllegalStateException("for threadsafe queue use remove (boolean) instead.");
        }
        return this._removeCode.getUnsynchronized(minPriority);
    }

    public Object remove(Object minPriority, boolean blocking) throws InterruptedException {
        if (this.isThreadSafe()) {
            return this._removeCode.get(minPriority, blocking);
        }
        throw new IllegalStateException("makes sense only for threadsafe queues");
    }

    public Object remove(Object minPriority, int timeoutMillis) throws InterruptedException, TimeoutException {
        if (this.isThreadSafe()) {
            return this._removeCode.get(minPriority, timeoutMillis);
        }
        throw new IllegalStateException("makes sense only for threadsafe queues");
    }

    public Object peek() {
        return this.peek(null);
    }

    public Object peek(boolean blocking) throws InterruptedException {
        return this.peek(null, blocking);
    }

    public Object peek(int timeoutMillis) throws InterruptedException, TimeoutException {
        return this.peek(null, timeoutMillis);
    }

    public Object peek(Object minPriority) {
        if (this._isThreadSafe) {
            throw new IllegalStateException("for threadsafe queue use peek (boolean) instead.");
        }
        return this._peekCode.getUnsynchronized(minPriority);
    }

    public Object peek(Object minPriority, boolean blocking) throws InterruptedException {
        if (this.isThreadSafe()) {
            return this._peekCode.get(minPriority, blocking);
        }
        throw new IllegalStateException("makes sense only for threadsafe queues");
    }

    public Object peek(Object minPriority, int timeoutMillis) throws InterruptedException, TimeoutException {
        if (this.isThreadSafe()) {
            return this._peekCode.get(minPriority, timeoutMillis);
        }
        throw new IllegalStateException("makes sense only for threadsafe queues");
    }

    public int size() {
        return this._store.size();
    }

    public int size(Object minPriority) {
        int numBelow = 0;
        Iterator iter = this._accessStrategy.begin(this._store);
        while (iter.hasCurrent() && !this.passesThreshold(((Pair)iter.current()).getFirst(), minPriority)) {
            iter.next();
            ++numBelow;
        }
        return this.size() - numBelow;
    }

    public boolean isEmpty() {
        return this._store.isEmpty();
    }

    public boolean isEmpty(Object minPriority) {
        Iterator iter = this._accessStrategy.begin(this._store);
        while (iter.hasCurrent() && !this.passesThreshold(((Pair)iter.current()).getFirst(), minPriority)) {
            iter.next();
        }
        return !iter.hasCurrent();
    }

    public void clear() {
        this._store.clear();
    }

    public void clear(Object minPriority) {
        Iterator iter = this._accessStrategy.begin(this._store);
        while (iter.hasCurrent() && !this.passesThreshold(((Pair)iter.current()).getFirst(), minPriority)) {
            iter.next();
        }
        while (iter.hasCurrent()) {
            iter.remove();
        }
    }

    public void setAcceptanceThreshold(Object o) {
        if (o != null) {
            this.clear(o);
        }
        this._threshold = o;
    }

    public boolean isThreadSafe() {
        return this._isThreadSafe;
    }

    public PriorityQueue cloneEmpty() {
        return new GenericPriorityQueue(this._store.cloneEmpty(), this._comparator, this._isThreadSafe);
    }

    public Object clone() {
        return new GenericPriorityQueue(this._store, this._comparator, this._isThreadSafe, true);
    }
}

