/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.EntryKeyComparator;
import ahc.collection.GenericMap;
import ahc.collection.Map;
import ahc.collection.SynchronizedMap;
import ahc.collection.access.AccessStrategy;
import ahc.collection.access.GenericAccessStrategy;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.equality.EqualsEqualityStrategy;
import ahc.collection.equality.IdentityEqualityStrategy;
import ahc.collection.store.ArrayStore;
import ahc.collection.store.DlinkedStore;
import ahc.collection.store.HashStore;
import ahc.collection.store.Store;
import java.util.Comparator;

public class MapHelper {
    public static final EqualityStrategy EQ_EQUALS = new EqualsEqualityStrategy();
    public static final EqualityStrategy EQ_IDENTITY = new IdentityEqualityStrategy();
    public static final AccessStrategy ACCESS_UNIQUE = GenericAccessStrategy.create(null, true);
    public static final AccessStrategy ACCESS_MULTIPLE = GenericAccessStrategy.create(null, false);

    public static Map synchronizedMap(Map map) {
        if (map == null) {
            return null;
        }
        return SynchronizedMap.create(map);
    }

    public static Map createMap() {
        return MapHelper.createHashMap();
    }

    public static Map createMap(java.util.Map initValues) {
        return MapHelper.initialize(MapHelper.createHashMap(), initValues);
    }

    private static Map initialize(Map map, java.util.Map initValues) {
        map.putAll(initValues);
        return map;
    }

    public static Map createArrayMap() {
        return MapHelper.createArrayMap(EQ_EQUALS, ACCESS_UNIQUE);
    }

    public static Map createArrayMap(java.util.Map initValues) {
        return MapHelper.initialize(MapHelper.createArrayMap(), initValues);
    }

    public static Map createArrayMap(int initialSize) {
        return MapHelper.createArrayMap(EQ_EQUALS, ACCESS_UNIQUE, initialSize);
    }

    public static Map createArrayMap(EqualityStrategy eqStrat) {
        return MapHelper.createArrayMap(eqStrat, ACCESS_UNIQUE);
    }

    public static Map createArrayMap(EqualityStrategy eqStrat, int initialSize) {
        return MapHelper.createArrayMap(eqStrat, ACCESS_UNIQUE, initialSize);
    }

    public static Map createArrayMap(Comparator comp) {
        return MapHelper.createArrayMap(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true));
    }

    public static Map createArrayMap(Comparator comp, int initialSize) {
        return MapHelper.createArrayMap(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true), initialSize);
    }

    public static Map createArrayMap(AccessStrategy accessStrat) {
        return MapHelper.createArrayMap(EQ_EQUALS, accessStrat);
    }

    public static Map createArrayMap(AccessStrategy accessStrat, int initialSize) {
        return MapHelper.createArrayMap(EQ_EQUALS, accessStrat, initialSize);
    }

    public static Map createArrayMap(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MapHelper.createMap(new ArrayStore(eqStrat), accessStrat);
    }

    public static Map createArrayMap(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return MapHelper.createMap(new ArrayStore(eqStrat, initialSize), accessStrat);
    }

    public static Map createDlinkedMap() {
        return MapHelper.createDlinkedMap(EQ_EQUALS, ACCESS_UNIQUE);
    }

    public static Map createDlinkedMap(java.util.Map initValues) {
        return MapHelper.initialize(MapHelper.createDlinkedMap(EQ_EQUALS, ACCESS_UNIQUE), initValues);
    }

    public static Map createDlinkedMap(EqualityStrategy eqStrat) {
        return MapHelper.createDlinkedMap(eqStrat, ACCESS_UNIQUE);
    }

    public static Map createDlinkedMap(Comparator comp) {
        return MapHelper.createDlinkedMap(EQ_EQUALS, GenericAccessStrategy.create(new EntryKeyComparator(comp), true));
    }

    public static Map createDlinkedMap(AccessStrategy accessStrat) {
        return MapHelper.createDlinkedMap(EQ_EQUALS, accessStrat);
    }

    public static Map createDlinkedMap(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MapHelper.createMap(new DlinkedStore(eqStrat), accessStrat);
    }

    public static Map createHashMap() {
        return MapHelper.createHashMap(EQ_EQUALS);
    }

    public static Map createHashMap(java.util.Map initValues) {
        return MapHelper.initialize(MapHelper.createHashMap(EQ_EQUALS), initValues);
    }

    public static Map createHashMap(int initialSize) {
        return MapHelper.createHashMap(EQ_EQUALS, initialSize);
    }

    public static Map createHashMap(int initialSize, double loadFactor) {
        return MapHelper.createHashMap(EQ_EQUALS, initialSize, loadFactor);
    }

    public static Map createHashMap(EqualityStrategy eqStrat) {
        return MapHelper.createHashMap(eqStrat, ACCESS_UNIQUE);
    }

    public static Map createHashMap(EqualityStrategy eqStrat, int initialSize) {
        return MapHelper.createHashMap(eqStrat, ACCESS_UNIQUE, initialSize);
    }

    public static Map createHashMap(EqualityStrategy eqStrat, int initialSize, double loadFactor) {
        return MapHelper.createHashMap(eqStrat, ACCESS_UNIQUE, initialSize, loadFactor);
    }

    public static Map createHashMap(AccessStrategy accessStrat) {
        return MapHelper.createHashMap(EQ_EQUALS, accessStrat);
    }

    public static Map createHashMap(AccessStrategy accessStrat, int initialSize) {
        return MapHelper.createHashMap(EQ_EQUALS, accessStrat, initialSize);
    }

    public static Map createHashMap(AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return MapHelper.createHashMap(EQ_EQUALS, accessStrat, initialSize, loadFactor);
    }

    public static Map createHashMap(EqualityStrategy eqStrat, AccessStrategy accessStrat) {
        return MapHelper.createMap(new HashStore(eqStrat), accessStrat);
    }

    public static Map createHashMap(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize) {
        return MapHelper.createMap(new HashStore(eqStrat, initialSize), accessStrat);
    }

    public static Map createHashMap(EqualityStrategy eqStrat, AccessStrategy accessStrat, int initialSize, double loadFactor) {
        return MapHelper.createMap(new HashStore(eqStrat, initialSize, loadFactor), accessStrat);
    }

    public static Map createMap(Store store, AccessStrategy accessStrat) {
        return new GenericMap(store, accessStrat);
    }

    public static Map createMap(Store store, AccessStrategy accessStrat, EqualityStrategy valueEqualityStrat) {
        return new GenericMap(store, accessStrat, valueEqualityStrat);
    }
}

