/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection;

import ahc.collection.SynchronizedLegacyIterator;
import ahc.collection.SynchronizedLegacyListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

class SynchronizedLegacyList
implements List {
    private final List _inner;
    private final List _lock;

    public static SynchronizedLegacyList create(List inner, List lock) {
        if (inner == null) {
            return null;
        }
        if (lock == null) {
            throw new IllegalArgumentException("Lock must not be null");
        }
        return new SynchronizedLegacyList(inner, lock);
    }

    private SynchronizedLegacyList(List inner, List lock) {
        this._inner = inner;
        this._lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List list = this._lock;
        synchronized (list) {
            return this._inner.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        List list = this._lock;
        synchronized (list) {
            return this._inner.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.contains(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        List list = this._lock;
        synchronized (list) {
            return SynchronizedLegacyIterator.create(this._inner.iterator(), this._lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        List list = this._lock;
        synchronized (list) {
            return this._inner.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.toArray(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object o) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.add(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object o) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.remove(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection c) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.containsAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection c) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.addAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection c) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.addAll(index, c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection c) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.removeAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection c) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.retainAll(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List list = this._lock;
        synchronized (list) {
            this._inner.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object element) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.set(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object element) {
        List list = this._lock;
        synchronized (list) {
            this._inner.add(index, element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object o) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.indexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object o) {
        List list = this._lock;
        synchronized (list) {
            return this._inner.lastIndexOf(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator() {
        List list = this._lock;
        synchronized (list) {
            return SynchronizedLegacyListIterator.create(this._inner.listIterator(), this._lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListIterator listIterator(int index) {
        List list = this._lock;
        synchronized (list) {
            return SynchronizedLegacyListIterator.create(this._inner.listIterator(index), this._lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List subList(int fromIndex, int toIndex) {
        List list = this._lock;
        synchronized (list) {
            return SynchronizedLegacyList.create(this._inner.subList(fromIndex, toIndex), this._lock);
        }
    }
}

