/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection.access;

import ahc.collection.Iterator;
import ahc.collection.access.AccessStrategy;
import ahc.collection.store.Store;
import java.util.Comparator;

public class GenericAccessStrategy
implements AccessStrategy {
    private final boolean _filterDuplicates;
    private final Comparator _comparator;

    public static AccessStrategy create(Comparator comp, boolean filterDuplicates) {
        return new GenericAccessStrategy(comp, filterDuplicates);
    }

    protected GenericAccessStrategy(boolean filterDuplicates) {
        this(null, filterDuplicates);
    }

    public GenericAccessStrategy(Comparator comp, boolean filterDuplicates) {
        this._comparator = comp;
        this._filterDuplicates = filterDuplicates;
    }

    public boolean add(Store store, Object o) {
        if (this._filterDuplicates && this.first(store, o) != null) {
            return false;
        }
        if (this._comparator == null) {
            store.append(o);
            return true;
        }
        Iterator iter = store.begin();
        while (iter.hasCurrent() && this._comparator.compare(o, iter.current()) > 0) {
            iter.next();
        }
        iter.add(o);
        return true;
    }

    public boolean prepend(Store store, Object o) {
        if (this._filterDuplicates && this.first(store, o) != null) {
            return false;
        }
        if (this._comparator == null) {
            store.prepend(o);
            return true;
        }
        Iterator iter = store.begin();
        while (iter.hasCurrent() && this._comparator.compare(o, iter.current()) > 0) {
            iter.next();
        }
        iter.add(o);
        return true;
    }

    public boolean append(Store store, Object o) {
        if (this._filterDuplicates && this.first(store, o) != null) {
            return false;
        }
        if (this._comparator == null) {
            store.append(o);
            return true;
        }
        Iterator iter = store.end();
        Iterator previous = store.after();
        while (iter.hasCurrent() && this._comparator.compare(o, iter.current()) < 0) {
            previous.previous();
            iter.previous();
        }
        previous.add(o);
        return true;
    }

    public boolean remove(Store store, Object o) {
        return store.remove(o);
    }

    public Object get(Store store, int index) {
        return store.get(index);
    }

    public boolean add(Store store, Iterator iter, Object o) {
        if (this._comparator != null) {
            throw new UnsupportedOperationException("modification by index is not supported for sorted collections");
        }
        if (this._filterDuplicates && this.first(store, o) != null) {
            return false;
        }
        iter.add(o);
        return true;
    }

    public Iterator before(Store store) {
        return new SafeIterator(store.before(), store);
    }

    public Iterator begin(Store store) {
        return new SafeIterator(store.begin(), store);
    }

    public Iterator end(Store store) {
        return new SafeIterator(store.end(), store);
    }

    public Iterator after(Store store) {
        return new SafeIterator(store.after(), store);
    }

    public Iterator iter(Store store, int index) {
        return new SafeIterator(store.iter(index), store);
    }

    public Iterator first(Store store, Object o) {
        Iterator inner = store.first(o);
        return inner != null ? new SafeIterator(inner, store) : null;
    }

    public Iterator last(Store store, Object o) {
        Iterator inner = store.last(o);
        return inner != null ? new SafeIterator(inner, store) : null;
    }

    private class SafeIterator
    implements Iterator {
        private final Iterator _inner;
        private final Store _store;

        public SafeIterator(Iterator inner, Store store) {
            this._inner = inner;
            this._store = store;
        }

        public boolean replace(Object o) {
            if (GenericAccessStrategy.this._filterDuplicates && GenericAccessStrategy.this.first(this._store, o) != null) {
                return false;
            }
            this.remove();
            this.add(o);
            this.previous();
            return true;
        }

        public void set(Object o) {
            this.replace(o);
        }

        public void add(Object o) {
            if (GenericAccessStrategy.this._filterDuplicates && GenericAccessStrategy.this.first(this._store, o) != null) {
                return;
            }
            if (GenericAccessStrategy.this._comparator == null || this._store.isSorted()) {
                this._inner.add(o);
                return;
            }
            GenericAccessStrategy.this.add(this._store, o);
        }

        public boolean hasCurrent() {
            return this._inner.hasCurrent();
        }

        public Object current() {
            return this._inner.current();
        }

        public int currentIndex() {
            return this._inner.currentIndex();
        }

        public Object next(int n) {
            return this._inner.next(n);
        }

        public Object previous(int n) {
            return this._inner.previous(n);
        }

        public boolean hasNext() {
            return this._inner.hasNext();
        }

        public Object next() {
            return this._inner.next();
        }

        public boolean hasPrevious() {
            return this._inner.hasPrevious();
        }

        public Object previous() {
            return this._inner.previous();
        }

        public int nextIndex() {
            return this._inner.nextIndex();
        }

        public int previousIndex() {
            return this._inner.previousIndex();
        }

        public void remove() {
            this._inner.remove();
        }
    }
}

