/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection.store;

import ahc.collection.Iterator;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.store.ImmutableStore;
import ahc.collection.store.Store;
import java.lang.reflect.Array;

public abstract class AbstractStore
implements Store {
    protected EqualityStrategy _eqStrat;

    public AbstractStore(EqualityStrategy eqStrat) {
        this._eqStrat = eqStrat;
    }

    public EqualityStrategy getEqualityStrategy() {
        return this._eqStrat;
    }

    public void setEqualityStrategy(EqualityStrategy eqStrat) {
        if (!this.isEmpty()) {
            throw new IllegalStateException("equality strategy can only be changed for empty collections");
        }
        this._eqStrat = eqStrat;
    }

    public boolean remove(Object o) {
        Iterator iter = this.first(o);
        if (iter == null) {
            return false;
        }
        iter.remove();
        return true;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        return this.first(o) != null;
    }

    public Iterator first(Object o) {
        Iterator iter = this.before();
        while (iter.hasNext()) {
            if (!this._eqStrat.equals(iter.next(), o)) continue;
            return iter;
        }
        return null;
    }

    public Iterator last(Object o) {
        Iterator iter = this.after();
        while (iter.hasPrevious()) {
            if (!this._eqStrat.equals(iter.previous(), o)) continue;
            return iter;
        }
        return null;
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public Object[] toArray(Object[] dest) {
        if (dest.length < this.size()) {
            dest = (Object[])Array.newInstance(dest.getClass().getComponentType(), this.size());
        }
        int ind = 0;
        Iterator iter = this.before();
        while (iter.hasNext()) {
            dest[ind++] = iter.next();
        }
        return dest;
    }

    public Object get(int index) {
        return this.iter(index).current();
    }

    public Object set(int index, Object element) {
        Iterator iter = this.iter(index);
        Object result = iter.current();
        this.iter(index).set(element);
        return result;
    }

    public Object remove(int index) {
        Iterator iter = this.iter(index);
        Object result = iter.current();
        iter.remove();
        return result;
    }

    public Object clone() {
        Store result = this.cloneEmpty();
        Iterator iter = this.begin();
        while (iter.hasCurrent()) {
            result.append(iter.current());
            iter.next();
        }
        return result;
    }

    protected Object cloneRaw() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Should not be thrown: " + e);
        }
    }

    public Store immutableView() {
        return new ImmutableStore(this);
    }
}

