/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection.store;

import ahc.collection.Iterator;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.store.AbstractStore;
import ahc.collection.store.Store;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class ArrayStore
extends AbstractStore {
    private Object[] _data;
    private int _size = 0;
    private int _modCount = 0;

    public ArrayStore(EqualityStrategy eqStrat) {
        this(eqStrat, 10);
    }

    public ArrayStore(EqualityStrategy eqStrat, int initialSize) {
        super(eqStrat);
        this._data = new Object[initialSize];
    }

    public boolean preservesOrdering() {
        return true;
    }

    public boolean isSorted() {
        return false;
    }

    private void _add(int ind, Object o) {
        this.ensureCapacity(this._size + 1);
        System.arraycopy(this._data, ind, this._data, ind + 1, this._size - ind);
        this._data[ind] = o;
        ++this._size;
        ++this._modCount;
    }

    public void prepend(Object o) {
        this._add(0, o);
    }

    public void append(Object o) {
        this.ensureCapacity(this._size + 1);
        this._data[this._size] = o;
        ++this._size;
        ++this._modCount;
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = null;
        }
        this._size = 0;
    }

    public Object get(int index) {
        return this._data[index];
    }

    public Iterator before() {
        return this.iter(-1);
    }

    public Iterator begin() {
        return this.iter(0);
    }

    public Iterator end() {
        return this.iter(this.size() - 1);
    }

    public Iterator after() {
        return this.iter(this.size());
    }

    public Iterator iter(int ind) {
        return new Itr(ind);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this._data.length;
        if (minCapacity > oldCapacity) {
            ++this._modCount;
            Object[] oldData = this._data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this._data = new Object[newCapacity];
            System.arraycopy(oldData, 0, this._data, 0, this._size);
        }
    }

    public void compactSize() {
        if (this._size == this._data.length) {
            return;
        }
        Object[] newData = new Object[this._size];
        System.arraycopy(this._data, 0, newData, 0, this._size);
        this._data = newData;
        ++this._modCount;
    }

    public Store cloneEmpty() {
        return new ArrayStore(this._eqStrat);
    }

    public Object clone() {
        ArrayStore result = (ArrayStore)this.cloneRaw();
        result._data = new Object[this._data.length];
        System.arraycopy(this._data, 0, result._data, 0, this._data.length);
        return result;
    }

    private class Itr
    implements Iterator {
        int _curPos = -1;
        int _expectedModCount = ArrayStore.access$000(ArrayStore.this);

        public Itr(int curPos) {
            this._curPos = curPos;
        }

        public void add(Object o) {
            if (this._curPos < 0 || this._curPos > ArrayStore.this._size) {
                throw new NoSuchElementException("iterator pos " + this._curPos + ", size is " + ArrayStore.this._size);
            }
            this.checkCoModification();
            ArrayStore.this._add(this._curPos, o);
            ++this._curPos;
            this._expectedModCount = ArrayStore.this._modCount;
        }

        public boolean hasCurrent() {
            return this._curPos >= 0 && this._curPos < ArrayStore.this._size;
        }

        public Object current() {
            this.checkRange();
            this.checkCoModification();
            return ArrayStore.this._data[this._curPos];
        }

        public int currentIndex() {
            return this._curPos;
        }

        public boolean replace(Object o) {
            this.checkCoModification();
            ((ArrayStore)ArrayStore.this)._data[this._curPos] = o;
            ArrayStore.this._modCount++;
            this._expectedModCount = ArrayStore.this._modCount;
            return true;
        }

        public void set(Object o) {
            this.replace(o);
        }

        public boolean hasNext() {
            return this._curPos < ArrayStore.this._size - 1;
        }

        public Object next() {
            ++this._curPos;
            return this.hasCurrent() ? this.current() : null;
        }

        public Object next(int n) {
            this._curPos += n;
            return this.hasCurrent() ? this.current() : null;
        }

        public int nextIndex() {
            return this._curPos + 1;
        }

        public boolean hasPrevious() {
            return this._curPos > 0;
        }

        public Object previous() {
            --this._curPos;
            return this.hasCurrent() ? this.current() : null;
        }

        public Object previous(int n) {
            this._curPos -= n;
            return this.hasCurrent() ? this.current() : null;
        }

        public int previousIndex() {
            return this._curPos - 1;
        }

        public void remove() {
            if (this._curPos == -1) {
                throw new IllegalStateException();
            }
            this.checkCoModification();
            System.arraycopy(ArrayStore.this._data, this._curPos + 1, ArrayStore.this._data, this._curPos, ArrayStore.this._size - this._curPos - 1);
            ArrayStore.this._size--;
            ((ArrayStore)ArrayStore.this)._data[((ArrayStore)ArrayStore.this)._size] = null;
            ArrayStore.this._modCount++;
            this._expectedModCount = ArrayStore.this._modCount;
        }

        private void checkRange() {
            if (!this.hasCurrent()) {
                throw new NoSuchElementException("iterator pos " + this._curPos + ", size is " + ArrayStore.this._size);
            }
        }

        private void checkCoModification() {
            if (this._expectedModCount != ArrayStore.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

