/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection.store;

import ahc.collection.Iterator;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.store.AbstractStore;
import ahc.collection.store.Store;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

public class HashStore
extends AbstractStore {
    private Entry[] _buckets;
    private final double _loadFactor;
    private int _threshold;
    private int _size = 0;
    private int _modCount = 0;

    public HashStore(EqualityStrategy eqStrat) {
        this(eqStrat, 10);
    }

    public HashStore(EqualityStrategy eqStrat, int initialSize) {
        this(eqStrat, initialSize, 0.75);
    }

    public HashStore(EqualityStrategy eqStrat, int initialSize, double loadFactor) {
        super(eqStrat);
        this._loadFactor = loadFactor;
        this._threshold = (int)((double)initialSize * loadFactor);
        this._buckets = new Entry[initialSize];
    }

    public boolean preservesOrdering() {
        return false;
    }

    public boolean isSorted() {
        return false;
    }

    public void prepend(Object o) {
        this.add(o);
    }

    private void add(Object o) {
        this.ensureCapacity();
        int indBucket = this.getBucket(o);
        this._buckets[indBucket] = new Entry(o, this._buckets[indBucket]);
        ++this._size;
        ++this._modCount;
    }

    public void append(Object o) {
        this.add(o);
    }

    public int size() {
        return this._size;
    }

    public void clear() {
        this._buckets = new Entry[this._buckets.length];
        this._size = 0;
    }

    public Iterator before() {
        return new Itr();
    }

    public Iterator begin() {
        Itr result = new Itr();
        result.next();
        return result;
    }

    public Iterator end() {
        throw new UnsupportedOperationException();
    }

    public Iterator after() {
        throw new UnsupportedOperationException();
    }

    public Iterator iter(int ind) {
        throw new UnsupportedOperationException();
    }

    private int getBucket(Object o, int numBuckets) {
        return (this._eqStrat.hashCode(o) & Integer.MAX_VALUE) % numBuckets;
    }

    private int getBucket(Object o) {
        return this.getBucket(o, this._buckets.length);
    }

    public Iterator first(Object o) {
        int indBucket = this.getBucket(o);
        Entry e = this._buckets[indBucket];
        while (e != null) {
            if (this._eqStrat.equals(e._element, o)) {
                return new Itr(indBucket, e);
            }
            e = e._next;
        }
        return null;
    }

    public void compactSize() {
        this.rehash((int)((double)this.size() / this._loadFactor) + 1);
    }

    private void ensureCapacity() {
        if (this._size > this._threshold) {
            this.rehash(this._buckets.length * 2 + 1);
        }
    }

    public void rehash() {
        this.rehash(this._buckets.length);
    }

    public void rehash(int numBuckets) {
        ++this._modCount;
        Entry[] newBuckets = new Entry[numBuckets];
        Iterator iter = this.before();
        while (iter.hasNext()) {
            iter.next();
            int indBucket = this.getBucket(iter.current(), numBuckets);
            newBuckets[indBucket] = new Entry(iter.current(), newBuckets[indBucket]);
        }
        this._threshold = (int)((double)numBuckets * this._loadFactor);
        this._buckets = newBuckets;
    }

    public Store cloneEmpty() {
        return new HashStore(this._eqStrat, 10, this._loadFactor);
    }

    private class Itr
    implements Iterator {
        private int _expectedModCount;
        private int _indBucket;
        private Entry _curEntry;
        private boolean _isAfter;

        public Itr() {
            this._expectedModCount = HashStore.this._modCount;
            this._indBucket = 0;
            this._curEntry = null;
            this._isAfter = false;
        }

        private Itr(int indBucket, Entry curEntry) {
            this._expectedModCount = HashStore.this._modCount;
            this._indBucket = 0;
            this._curEntry = null;
            this._isAfter = false;
            this._indBucket = indBucket;
            this._curEntry = curEntry;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean hasCurrent() {
            return this._curEntry != null && !this._isAfter;
        }

        public Object current() {
            this.checkRange();
            this.checkCoModification();
            return this._curEntry._element;
        }

        public int currentIndex() {
            throw new UnsupportedOperationException();
        }

        public boolean replace(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            this.replace(o);
        }

        public boolean hasNext() {
            int baseInd = this._indBucket;
            if (this._curEntry != null) {
                if (this._curEntry._next != null) {
                    return true;
                }
                ++baseInd;
            }
            for (int ind = baseInd; ind < HashStore.this._buckets.length; ++ind) {
                if (HashStore.this._buckets[ind] == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            this.checkCoModification();
            if (this._curEntry != null) {
                if (this._curEntry._next != null) {
                    this._curEntry = this._curEntry._next;
                    return this._curEntry._element;
                }
                ++this._indBucket;
                this._curEntry = null;
            }
            for (int ind = this._indBucket; ind < HashStore.this._buckets.length; ++ind) {
                if (HashStore.this._buckets[ind] == null) continue;
                this._indBucket = ind;
                this._curEntry = HashStore.this._buckets[ind];
                return this._curEntry._element;
            }
            this._isAfter = true;
            return null;
        }

        public Object next(int n) {
            for (int i = 0; i < n; ++i) {
                this.next();
            }
            return this.current();
        }

        public int nextIndex() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        public Object previous() {
            throw new UnsupportedOperationException();
        }

        public Object previous(int n) {
            throw new UnsupportedOperationException();
        }

        public int previousIndex() {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            this.checkRange();
            this.checkCoModification();
            Entry prev = HashStore.this._buckets[this._indBucket];
            if (prev == this._curEntry) {
                ((HashStore)HashStore.this)._buckets[this._indBucket] = this._curEntry._next;
            } else {
                while (prev._next != this._curEntry) {
                    prev = prev._next;
                }
                prev._next = this._curEntry._next;
            }
            HashStore.this._size--;
            HashStore.this._modCount++;
            this._indBucket = 0;
            this._curEntry = null;
        }

        private void checkRange() {
            if (!this.hasCurrent()) {
                throw new NoSuchElementException();
            }
        }

        private void checkCoModification() {
            if (this._expectedModCount != HashStore.this._modCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private static class Entry {
        Object _element;
        Entry _next;

        public Entry(Object element, Entry next) {
            this._element = element;
            this._next = next;
        }
    }
}

