/*
 * Decompiled with CFR 0.152.
 */
package ahc.collection.store;

import ahc.collection.Iterator;
import ahc.collection.equality.EqualityStrategy;
import ahc.collection.store.Store;

public class TypeAssertingStore
implements Store {
    private final Class _type;
    private final Store _inner;

    public TypeAssertingStore(Class type, Store inner) {
        this._type = type;
        this._inner = inner;
    }

    private void check(Object o) {
        if (o == null || this._type.isInstance(o)) {
            return;
        }
        throw new IllegalArgumentException("Attempt to add an element that is not of type " + this._type + ": " + o + " [" + o.getClass().getName() + "]");
    }

    private CheckingIterator createCheckingIterator(Iterator iter) {
        return iter != null ? new CheckingIterator(iter) : null;
    }

    public boolean preservesOrdering() {
        return this._inner.preservesOrdering();
    }

    public boolean isSorted() {
        return this._inner.isSorted();
    }

    public void prepend(Object o) {
        this.check(o);
        this._inner.prepend(o);
    }

    public void append(Object o) {
        this.check(o);
        this._inner.append(o);
    }

    public Iterator before() {
        return this.createCheckingIterator(this._inner.before());
    }

    public Iterator begin() {
        return this.createCheckingIterator(this._inner.begin());
    }

    public Iterator end() {
        return this.createCheckingIterator(this._inner.end());
    }

    public Iterator after() {
        return this.createCheckingIterator(this._inner.after());
    }

    public Iterator iter(int n) {
        return this.createCheckingIterator(this._inner.iter(n));
    }

    public Iterator first(Object o) {
        return this.createCheckingIterator(this._inner.first(o));
    }

    public Iterator last(Object o) {
        return this.createCheckingIterator(this._inner.last(o));
    }

    public void compactSize() {
        this._inner.compactSize();
    }

    public int size() {
        return this._inner.size();
    }

    public boolean isEmpty() {
        return this._inner.isEmpty();
    }

    public boolean contains(Object o) {
        return this._inner.contains(o);
    }

    public void clear() {
        this._inner.clear();
    }

    public Object[] toArray() {
        return this._inner.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this._inner.toArray(a);
    }

    public boolean remove(Object o) {
        return this._inner.remove(o);
    }

    public Object get(int index) {
        return this._inner.get(index);
    }

    public Object set(int index, Object element) {
        this.check(element);
        return this._inner.set(index, element);
    }

    public Object remove(int index) {
        return this._inner.remove(index);
    }

    public EqualityStrategy getEqualityStrategy() {
        return this._inner.getEqualityStrategy();
    }

    public void setEqualityStrategy(EqualityStrategy eqStrat) {
        this._inner.setEqualityStrategy(eqStrat);
    }

    public Store cloneEmpty() {
        return new TypeAssertingStore(this._type, this._inner.cloneEmpty());
    }

    public Store immutableView() {
        return new TypeAssertingStore(this._type, this._inner.immutableView());
    }

    public Object clone() {
        return new TypeAssertingStore(this._type, (Store)this._inner.clone());
    }

    private class CheckingIterator
    implements Iterator {
        final Iterator _inner;

        public CheckingIterator(Iterator inner) {
            this._inner = inner;
        }

        public Object previous(int n) {
            return this._inner.previous(n);
        }

        public boolean hasCurrent() {
            return this._inner.hasCurrent();
        }

        public Object current() {
            return this._inner.current();
        }

        public int currentIndex() {
            return this._inner.currentIndex();
        }

        public Object next(int n) {
            return this._inner.next(n);
        }

        public boolean replace(Object o) {
            TypeAssertingStore.this.check(o);
            return this._inner.replace(o);
        }

        public boolean hasNext() {
            return this._inner.hasNext();
        }

        public Object next() {
            return this._inner.next();
        }

        public void remove() {
            this._inner.remove();
        }

        public boolean hasPrevious() {
            return this._inner.hasPrevious();
        }

        public Object previous() {
            return this._inner.previous();
        }

        public int nextIndex() {
            return this._inner.nextIndex();
        }

        public int previousIndex() {
            return this._inner.previousIndex();
        }

        public void set(Object o) {
            TypeAssertingStore.this.check(o);
            this._inner.set(o);
        }

        public void add(Object o) {
            TypeAssertingStore.this.check(o);
            this._inner.add(o);
        }
    }
}

