/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BeanAttribute {
    public static final Object[] NO_PARAMETERS = new Object[0];
    private final String _attribName;
    private final Class _attribType;
    private final Method _getMethod;
    private final Method _setMethod;

    BeanAttribute(String attribName, Method getMethod, Method setMethod) {
        this._getMethod = getMethod;
        this._setMethod = setMethod;
        this._attribType = getMethod.getReturnType();
        this._attribName = attribName;
        this.checkGetter();
        this.checkSetter();
        this.checkTypeMatch();
    }

    private void checkTypeMatch() {
        if (!this._getMethod.getReturnType().equals(this._setMethod.getParameterTypes()[0])) {
            throw new IllegalArgumentException("get and set method (" + this._getMethod + " / " + this._setMethod + ") have different types");
        }
    }

    private void checkSetter() {
        if (this._setMethod == null) {
            return;
        }
        if ((this._setMethod.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("set method " + this._setMethod + "does not have public access");
        }
        if (this._setMethod.getParameterTypes().length != 1) {
            throw new IllegalArgumentException("set method " + this._setMethod + " must have exactly one parameter");
        }
        if (!this._setMethod.getReturnType().equals(Void.TYPE)) {
            throw new IllegalArgumentException("set method " + this._setMethod + " must have void return type");
        }
    }

    private void checkGetter() {
        if (this._getMethod == null) {
            return;
        }
        if ((this._getMethod.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException("get method " + this._getMethod + " does not have public access");
        }
        if (this._getMethod.getParameterTypes().length != 0) {
            throw new IllegalArgumentException("get method " + this._getMethod + " must not have parameters");
        }
    }

    public void setValue(Object o, Object val) throws InvocationTargetException {
        try {
            this._setMethod.invoke(o, val);
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
    }

    public Object getValue(Object o) throws InvocationTargetException {
        try {
            return this._getMethod.invoke(o, NO_PARAMETERS);
        }
        catch (IllegalAccessException e) {
            throw new InternalError();
        }
    }

    public boolean isReadable() {
        return this._getMethod != null;
    }

    public boolean isWritable() {
        return this._setMethod != null;
    }

    public boolean isReadWrite() {
        return this.isReadable() && this.isWritable();
    }

    public String getAttributeName() {
        return this._attribName;
    }

    public Class getAttributeType() {
        return this._attribType;
    }

    public Method getGetMethod() {
        return this._getMethod;
    }

    public Method getSetMethod() {
        return this._setMethod;
    }

    public void setValue(Object o, long val) throws InvocationTargetException {
        this.setValue(o, new Long(val));
    }

    public void setValue(Object o, int val) throws InvocationTargetException {
        this.setValue(o, new Integer(val));
    }

    public void setValue(Object o, short val) throws InvocationTargetException {
        this.setValue(o, new Short(val));
    }

    public void setValue(Object o, char val) throws InvocationTargetException {
        this.setValue(o, new Character(val));
    }

    public void setValue(Object o, byte val) throws InvocationTargetException {
        this.setValue(o, new Byte(val));
    }

    public void setValue(Object o, boolean val) throws InvocationTargetException {
        this.setValue(o, new Boolean(val));
    }

    public long getLongValue(Object o) throws InvocationTargetException {
        return (Long)this.getValue(o);
    }

    public int getIntValue(Object o) throws InvocationTargetException {
        return (Integer)this.getValue(o);
    }

    public short getShortValue(Object o) throws InvocationTargetException {
        return (Short)this.getValue(o);
    }

    public char getCharValue(Object o) throws InvocationTargetException {
        return ((Character)this.getValue(o)).charValue();
    }

    public byte getByteValue(Object o) throws InvocationTargetException {
        return (Byte)this.getValue(o);
    }

    public boolean getBooleanValue(Object o) throws InvocationTargetException {
        return (Boolean)this.getValue(o);
    }
}

