/*
 * Decompiled with CFR 0.152.
 */
package ahc.generic.classloader;

import ahc.collection.Cache;
import ahc.util.bytes.ByteArray;
import ahc.util.bytes.StringEncoder;
import ahc.util.bytes.StringEndEncoding;

class ConstantPool {
    private static final int CONSTANT_UTF_8 = 1;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_NameAndType = 12;
    private final ByteArray _data = new ByteArray();
    private int _poolSize = 0;
    private final Cache _stringCache = new Cache(){

        protected Object createNew(Object key) {
            byte[] raw = StringEncoder.getBytesUtf8((String)key, StringEndEncoding.END_LEN_PREFIX_16_HILO);
            ConstantPool.this._data.addInt8(1);
            ConstantPool.this._data.add(raw);
            ConstantPool.this._poolSize++;
            return new Integer(ConstantPool.this._poolSize);
        }
    };

    ConstantPool() {
    }

    public ByteArray asBytes() {
        ByteArray result = new ByteArray();
        result.addInt16(this._poolSize + 1);
        result.add(this._data);
        return result;
    }

    public int addStringInfo(String str) {
        return (Integer)this._stringCache.get(str);
    }

    public int addClassInfo(String clsName) {
        int nameIndex = this.addStringInfo(clsName);
        this._data.addInt8(7);
        this._data.addInt16(nameIndex);
        ++this._poolSize;
        return this._poolSize;
    }

    public int addMethodInfo(String clsName, String methodName, String methodSignature) {
        int clsIndex = this.addClassInfo(clsName);
        int nameAndTypeIndex = this.addNameAndTypeInfo(methodName, methodSignature);
        this._data.addInt8(10);
        this._data.addInt16(clsIndex);
        this._data.addInt16(nameAndTypeIndex);
        ++this._poolSize;
        return this._poolSize;
    }

    public int addNameAndTypeInfo(String methodName, String methodSignature) {
        int nameIndex = this.addStringInfo(methodName);
        int descriptorIndex = this.addStringInfo(methodSignature);
        this._data.addInt8(12);
        this._data.addInt16(nameIndex);
        this._data.addInt16(descriptorIndex);
        ++this._poolSize;
        return this._poolSize;
    }
}

