/*
 * Decompiled with CFR 0.152.
 */
package ahc.io;

import ahc.util.bytes.InputStreamToByteArray;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;

public class ResourceLoader {
    public static InputStream getAsStream(String name) {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
    }

    public static byte[] getAsBytes(String name) {
        InputStream is = ResourceLoader.getAsStream(name);
        if (is == null) {
            throw new IllegalArgumentException("resource not found: '" + name + "'");
        }
        try {
            return new InputStreamToByteArray(1024).read(ResourceLoader.getAsStream(name));
        }
        catch (IOException exc) {
            throw new RuntimeException("should not have happened: " + exc);
        }
    }

    public static ImageIcon getAsImageIcon(String name) {
        return new ImageIcon(ResourceLoader.getAsBytes(name));
    }
}

