/*
 * Decompiled with CFR 0.152.
 */
package ahc.io.httpserver;

import ahc.exception.ProblemCallback;
import ahc.io.httpserver.HttpHandler;
import ahc.io.httpserver.ServerSocketThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

public class HttpServer {
    private final HttpHandler _handler;
    private final int _port;
    private final InetAddress _bindAddress;
    private final int _backlog;
    private final ProblemCallback _problemCallback;
    private ServerSocketThread _serverSocketThrad;

    public HttpServer(HttpHandler handler, int backlog, int port, InetAddress address) {
        this(handler, backlog, port, address, null);
    }

    public HttpServer(HttpHandler handler, int backlog, int port, InetAddress address, ProblemCallback problemCallback) {
        this._handler = handler;
        this._backlog = backlog;
        this._port = port;
        this._bindAddress = address;
        this._problemCallback = problemCallback;
    }

    public synchronized void start() throws IOException {
        this.start(null);
    }

    public synchronized void start(Runnable shutdownCallback) throws IOException {
        if (this.isRunning()) {
            throw new IllegalStateException("This server is already running");
        }
        ServerSocket serverSocket = new ServerSocket(this._port, this._backlog, this._bindAddress);
        this._serverSocketThrad = new ServerSocketThread(serverSocket, this._handler, this._problemCallback, shutdownCallback);
        this._serverSocketThrad.start();
    }

    public synchronized boolean isRunning() {
        return this._serverSocketThrad != null && !this._serverSocketThrad.isShutdownFinished();
    }

    public synchronized void stop() throws IOException {
        if (this._serverSocketThrad != null) {
            this._serverSocketThrad.shutdown();
        }
    }
}

