/*
 * Decompiled with CFR 0.152.
 */
package ahc.io.httpserver;

import ahc.exception.ProblemCallback;
import ahc.io.httpserver.ExceptionHttpResponse;
import ahc.io.httpserver.HttpHandler;
import ahc.io.httpserver.HttpRequestImpl;
import ahc.io.httpserver.HttpResponseImpl;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;

class ServerSocketThread
extends Thread {
    private final ServerSocket _serverSocket;
    private final HttpHandler _handler;
    private final ProblemCallback _problemCallback;
    private final Runnable _shutdownCallback;
    private boolean _shouldShutdown = false;
    private boolean _isShutdownFinished = false;
    public static final String SHUTDOWN_COMMAND = "sHuTdOwN";

    public ServerSocketThread(ServerSocket serverSocket, HttpHandler handler, ProblemCallback problemCallback, Runnable shutdownCallback) {
        this._serverSocket = serverSocket;
        this._handler = handler;
        this._problemCallback = problemCallback;
        this._shutdownCallback = shutdownCallback;
    }

    public void shutdown() throws IOException {
        this._shouldShutdown = true;
        Socket socket = new Socket(this._serverSocket.getInetAddress(), this._serverSocket.getLocalPort());
        OutputStream os = socket.getOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.println(SHUTDOWN_COMMAND);
        ps.flush();
        socket.close();
    }

    public void run() {
        while (!this._shouldShutdown) {
            try {
                Socket socket = this._serverSocket.accept();
                this.handleRequest(socket);
            }
            catch (Exception exc) {
                if (this._problemCallback == null) continue;
                this._problemCallback.problem(null, exc);
            }
        }
        this._isShutdownFinished = true;
        if (this._shutdownCallback != null) {
            this._shutdownCallback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(Socket socket) throws IOException {
        block8: {
            try {
                HttpRequestImpl request = new HttpRequestImpl(socket.getInputStream());
                HttpResponseImpl response = new HttpResponseImpl();
                if (SHUTDOWN_COMMAND.equals(request.getRequestString())) {
                    this._shouldShutdown = true;
                }
                if (this._shouldShutdown) {
                    break block8;
                }
                try {
                    boolean handlerWantsShutdown = this._handler.handle(request, response);
                    if (handlerWantsShutdown) {
                        this._shouldShutdown = true;
                    }
                }
                catch (Exception exc) {
                    response = new ExceptionHttpResponse(exc);
                }
                socket.getOutputStream().write(response.getHttpResponseString().getBytes(response.getEncoding()));
            }
            finally {
                socket.close();
            }
        }
    }

    public boolean isShutdownFinished() {
        return this._isShutdownFinished;
    }
}

