/*
 * Decompiled with CFR 0.152.
 */
package ahc.jdbc.connectionpool;

import ahc.jdbc.connectionpool.AbstractConnectionPool;
import ahc.jdbc.connectionpool.ConnectionPoolException;
import ahc.jdbc.connectionpool.ConnectionValidator;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class PoolingDataSource
extends AbstractConnectionPool
implements DataSource {
    private final DataSource _innerDs;

    public PoolingDataSource(int initialSize, DataSource innerDs) {
        super(initialSize);
        this._innerDs = innerDs;
    }

    public PoolingDataSource(int initialSize, ConnectionValidator validator, DataSource innerDs) {
        super(initialSize, validator);
        this._innerDs = innerDs;
    }

    protected Connection createConnection() throws ConnectionPoolException, SQLException {
        return this._innerDs.getConnection();
    }

    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException("pool requires fixed username and password");
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._innerDs.getLogWriter();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this._innerDs.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this._innerDs.setLoginTimeout(seconds);
    }

    public int getLoginTimeout() throws SQLException {
        return this._innerDs.getLoginTimeout();
    }
}

