/*
 * Decompiled with CFR 0.152.
 */
package ahc.jdbc.logger;

import ahc.jdbc.logger.UniqueIdFactory;
import ahc.util.string.StringHelper;
import ahc.util.string.ToString;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

class LoggingJdbcInvocationHandler
implements InvocationHandler {
    private final Class _type;
    private final Object _inner;
    private final String _uniqueId;
    private static final Map _specialReturnTypes = new HashMap();
    static /* synthetic */ Class class$java$sql$CallableStatement;
    static /* synthetic */ Class class$ahc$jdbc$logger$LoggingJdbcInvocationHandler;
    static /* synthetic */ Class class$java$sql$Connection;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$ResultSet;
    static /* synthetic */ Class class$java$sql$ResultSetMetaData;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public LoggingJdbcInvocationHandler(Class type, Object inner, String uniqueId) {
        this._type = type;
        this._inner = inner;
        this._uniqueId = uniqueId;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            InvocationResult result = this.actualInvokeMethod(method, args);
            this.logCall(method, args, result._result, result._uniqueId);
            return result.getResult();
        }
        catch (Throwable th) {
            if (th instanceof InvocationTargetException) {
                th = ((InvocationTargetException)th).getTargetException();
            }
            this.logCall(method, args, th);
            throw th;
        }
    }

    private void logCall(Method method, Object[] args, Object result, String uniqueId) {
        if (this.filterLogCalls(method)) {
            return;
        }
        System.out.println("{jdbclog}[" + this._uniqueId + "][" + System.currentTimeMillis() + "] " + this._type.getName() + "." + method.getName() + " (" + ToString.defaultToString(args) + ") " + ": " + (result instanceof String ? "\"" + result + "\"" : StringHelper.escape("" + result)) + (uniqueId != null ? "[" + uniqueId + "]" : ""));
    }

    private boolean filterLogCalls(Method method) {
        return "toString".equals(method.getName()) && method.getParameterTypes().length == 0;
    }

    private void logCall(Method method, Object[] args, Throwable th) {
        System.out.println("{jdbclog}[" + this._uniqueId + "][" + System.currentTimeMillis() + "] " + this._type.getName() + "." + method.getName() + " (" + ToString.defaultToString(args) + ") " + ": Exception " + StringHelper.escape("" + th));
    }

    private InvocationResult actualInvokeMethod(Method method, Object[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, InstantiationException {
        Object result = method.invoke(this._inner, args);
        Class<?> returnType = method.getReturnType();
        if (_specialReturnTypes.containsKey(returnType)) {
            String uniqueId = UniqueIdFactory.createUniqueId();
            Object resultObject = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{returnType}, this.getHandlerInstance((Class)_specialReturnTypes.get(returnType), returnType, result, uniqueId));
            return new InvocationResult(resultObject, true, uniqueId);
        }
        return new InvocationResult(result, false, null);
    }

    private InvocationHandler getHandlerInstance(Class handlerClass, Class wrappedInterface, Object inner, String uniqueId) throws NoSuchMethodException, IllegalAccessException, InstantiationException, InvocationTargetException {
        Constructor ctor = handlerClass.getConstructor(class$java$lang$Class == null ? (class$java$lang$Class = LoggingJdbcInvocationHandler.class$("java.lang.Class")) : class$java$lang$Class, class$java$lang$Object == null ? (class$java$lang$Object = LoggingJdbcInvocationHandler.class$("java.lang.Object")) : class$java$lang$Object, class$java$lang$String == null ? (class$java$lang$String = LoggingJdbcInvocationHandler.class$("java.lang.String")) : class$java$lang$String);
        return (InvocationHandler)ctor.newInstance(wrappedInterface, inner, uniqueId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _specialReturnTypes.put(class$java$sql$CallableStatement == null ? (class$java$sql$CallableStatement = LoggingJdbcInvocationHandler.class$("java.sql.CallableStatement")) : class$java$sql$CallableStatement, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
        _specialReturnTypes.put(class$java$sql$Connection == null ? (class$java$sql$Connection = LoggingJdbcInvocationHandler.class$("java.sql.Connection")) : class$java$sql$Connection, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
        _specialReturnTypes.put(class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = LoggingJdbcInvocationHandler.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
        _specialReturnTypes.put(class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = LoggingJdbcInvocationHandler.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
        _specialReturnTypes.put(class$java$sql$ResultSet == null ? (class$java$sql$ResultSet = LoggingJdbcInvocationHandler.class$("java.sql.ResultSet")) : class$java$sql$ResultSet, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
        _specialReturnTypes.put(class$java$sql$ResultSetMetaData == null ? (class$java$sql$ResultSetMetaData = LoggingJdbcInvocationHandler.class$("java.sql.ResultSetMetaData")) : class$java$sql$ResultSetMetaData, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
        _specialReturnTypes.put(class$java$sql$Statement == null ? (class$java$sql$Statement = LoggingJdbcInvocationHandler.class$("java.sql.Statement")) : class$java$sql$Statement, class$ahc$jdbc$logger$LoggingJdbcInvocationHandler == null ? (class$ahc$jdbc$logger$LoggingJdbcInvocationHandler = LoggingJdbcInvocationHandler.class$("ahc.jdbc.logger.LoggingJdbcInvocationHandler")) : class$ahc$jdbc$logger$LoggingJdbcInvocationHandler);
    }

    private static class InvocationResult {
        private final Object _result;
        private final boolean _hasUniqueId;
        private final String _uniqueId;

        public InvocationResult(Object result, boolean hasUniqueId, String uniqueId) {
            this._result = result;
            this._hasUniqueId = hasUniqueId;
            this._uniqueId = uniqueId;
        }

        public Object getResult() {
            return this._result;
        }

        public boolean isHasUniqueId() {
            return this._hasUniqueId;
        }

        public String getUniqueId() {
            return this._uniqueId;
        }
    }
}

