/*
 * Decompiled with CFR 0.152.
 */
package ahc.util;

import ahc.util.IntHelper;

public class IntegerFactory {
    public static final int NUM_BINS = 1000;
    private static final Entry[] _bins = new Entry[1000];

    public static Integer get(int value) {
        Entry newEntry;
        int indBin = IntegerFactory.getBin(value);
        Entry entry = _bins[indBin];
        if (entry == null) {
            Integer result = new Integer(value);
            IntegerFactory._bins[indBin] = new Entry(result, null);
            return result;
        }
        Entry previous = null;
        while (entry != null) {
            if (entry._element == value) {
                return entry._element;
            }
            previous = entry;
            entry = entry._next;
        }
        Integer result = new Integer(value);
        previous._next = newEntry = new Entry(result, null);
        return result;
    }

    private static int getBin(int value) {
        return (value & Integer.MAX_VALUE) % 1000;
    }

    public static Integer increment(Integer value) {
        return IntegerFactory.get(IntegerFactory.getValueNotNull(value) + 1);
    }

    private static int getValueNotNull(Integer value) {
        return value == null ? 0 : value;
    }

    public static Integer decrement(Integer value) {
        return IntegerFactory.get(IntegerFactory.getValueNotNull(value) - 1);
    }

    public static Integer add(Integer v1, Integer v2) {
        return IntegerFactory.get(IntegerFactory.getValueNotNull(v1) + IntegerFactory.getValueNotNull(v2));
    }

    public static Integer add(Integer v1, int v2) {
        return IntegerFactory.get(IntegerFactory.getValueNotNull(v1) + v2);
    }

    public static Integer subtract(Integer v1, Integer v2) {
        return IntegerFactory.get(IntegerFactory.getValueNotNull(v1) - IntegerFactory.getValueNotNull(v2));
    }

    public static Integer subtract(Integer v1, int v2) {
        return IntegerFactory.get(IntegerFactory.getValueNotNull(v1) - v2);
    }

    public static Integer subtract(int v1, Integer v2) {
        return IntegerFactory.get(v1 - IntegerFactory.getValueNotNull(v2));
    }

    public static Integer mod(int a, int b) {
        return IntegerFactory.get(IntHelper.mod(a, b));
    }

    public static Integer mod(Integer a, int b) {
        return IntegerFactory.mod((int)a, b);
    }

    public static Integer mod(int a, Integer b) {
        return IntegerFactory.mod(a, (int)b);
    }

    public static Integer mod(Integer a, Integer b) {
        return IntegerFactory.mod((int)a, (int)b);
    }

    private static class Entry {
        Integer _element;
        Entry _next;

        public Entry(Integer element, Entry next) {
            this._element = element;
            this._next = next;
        }
    }
}

