/*
 * Decompiled with CFR 0.152.
 */
package ahc.util;

import ahc.exception.TimeoutException;

public abstract class SynchronizedParamGetCode {
    private final Object _lock;

    public SynchronizedParamGetCode(Object lock) {
        this._lock = lock;
    }

    private void waitForPrecondition(Object parameter, long timeoutMillis) throws InterruptedException, TimeoutException {
        long timeoutLimit = System.currentTimeMillis() + timeoutMillis;
        long waitInterval = timeoutMillis / 5L;
        while (!this.precondition(parameter) && System.currentTimeMillis() < timeoutLimit) {
            this._lock.wait(waitInterval);
        }
        if (!this.precondition(parameter)) {
            throw new TimeoutException(timeoutMillis);
        }
    }

    private void waitForPrecondition(Object parameter) throws InterruptedException {
        while (!this.precondition(parameter)) {
            this.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object parameter, int timeoutMillis) throws InterruptedException, TimeoutException {
        if (timeoutMillis < 0) {
            return this.get(parameter, true);
        }
        Object object = this._lock;
        synchronized (object) {
            this.waitForPrecondition(parameter, timeoutMillis);
            return this.getUnsynchronized(parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object parameter, boolean blocking) throws InterruptedException {
        Object object = this._lock;
        synchronized (object) {
            this.waitForPrecondition(parameter);
            return this.getUnsynchronized(parameter);
        }
    }

    public abstract boolean precondition(Object var1);

    public abstract Object getUnsynchronized(Object var1);
}

