/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.bytes;

import ahc.util.bytes.BitManipulator;
import java.util.ArrayList;
import java.util.List;

public class ByteArray {
    private final List _data = new ArrayList();

    public ByteArray() {
    }

    public ByteArray(int[] data) {
        this.add(data);
    }

    public ByteArray(byte[] data) {
        this.add(data);
    }

    public ByteArray(ByteArray data) {
        this.add(data);
    }

    public byte[] asBytes() {
        byte[] resultBytes = new byte[this._data.size()];
        for (int i = 0; i < this._data.size(); ++i) {
            resultBytes[i] = (byte)((Integer)this._data.get(i)).intValue();
        }
        return resultBytes;
    }

    public int getSize() {
        return this._data.size();
    }

    public void addInt8(int num) {
        this._data.add(new Integer(BitManipulator.LO(num)));
    }

    public void addInt16(int num) {
        this.addInt8(BitManipulator.MIDLO(num));
        this.addInt8(BitManipulator.LO(num));
    }

    public void addInt32(int num) {
        this.addInt8(BitManipulator.HI(num));
        this.addInt8(BitManipulator.MIDHI(num));
        this.addInt8(BitManipulator.MIDLO(num));
        this.addInt8(BitManipulator.LO(num));
    }

    public void add(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            this._data.add(new Integer(bytes[i]));
        }
    }

    public void add(int[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            this._data.add(new Integer(bytes[i]));
        }
    }

    public void add(ByteArray other) {
        this.add(other.asBytes());
    }
}

