/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string;

import ahc.util.bytes.ByteArray;
import java.io.UnsupportedEncodingException;

public class Base64Formatter {
    private static final char FILL_CHAR = '=';
    private static final String ENC_ISO_8859_1 = "iso-8859-1";

    public static String encodeToString(byte[] data) {
        byte[] result = Base64Formatter.encode(data);
        if (result == null) {
            return null;
        }
        try {
            return new String(result, ENC_ISO_8859_1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("'iso-8859-1' not supported...");
        }
    }

    public static byte[] encode(byte[] data) {
        if (data == null) {
            return null;
        }
        ByteArray dest = new ByteArray();
        int destLength = (data.length + 2) / 3 * 4;
        for (int indSource = 0; indSource < data.length; indSource += 3) {
            dest.addInt8(Base64Formatter.expand1(data, indSource));
            dest.addInt8(Base64Formatter.expand2(data, indSource));
            dest.addInt8(Base64Formatter.expand3(data, indSource));
            dest.addInt8(Base64Formatter.expand4(data, indSource));
        }
        byte[] result = dest.asBytes();
        for (int idx = destLength - 1; idx > data.length * 4 / 3; --idx) {
            result[idx] = 61;
        }
        return result;
    }

    private static int expand4(byte[] data, int indSource) {
        return Base64Formatter.encodeAscii(Base64Formatter.getNoLimit(data, indSource + 2) & 0x3F);
    }

    private static int expand3(byte[] data, int indSource) {
        return Base64Formatter.encodeAscii(Base64Formatter.getNoLimit(data, indSource + 2) >>> 6 & 3 | Base64Formatter.getNoLimit(data, indSource + 1) << 2 & 0x3F);
    }

    private static int expand2(byte[] data, int indSource) {
        return Base64Formatter.encodeAscii(Base64Formatter.getNoLimit(data, indSource + 1) >>> 4 & 0xF | Base64Formatter.getNoLimit(data, indSource) << 4 & 0x3F);
    }

    private static int expand1(byte[] data, int indSource) {
        return Base64Formatter.encodeAscii(Base64Formatter.getNoLimit(data, indSource) >>> 2 & 0x3F);
    }

    private static byte getNoLimit(byte[] data, int ind) {
        if (ind < data.length) {
            return data[ind];
        }
        return 0;
    }

    private static int encodeAscii(int value) {
        if (value < 26) {
            return value + 65;
        }
        if (value < 52) {
            return value - 26 + 97;
        }
        if (value < 62) {
            return value - 52 + 48;
        }
        if (value == 62) {
            return 43;
        }
        return 47;
    }

    public static final byte[] decode(String str) {
        if (str == null) {
            return null;
        }
        try {
            return Base64Formatter.decode(str.getBytes(ENC_ISO_8859_1));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("'iso-8859-1' not supported...");
        }
    }

    private static byte decodeAscii(int value) {
        if (value >= 65 && value <= 90) {
            return (byte)(value - 65);
        }
        if (value >= 97 && value <= 122) {
            return (byte)(value - 97 + 26);
        }
        if (value >= 48 && value <= 57) {
            return (byte)(value - 48 + 52);
        }
        if (value == 43) {
            return 62;
        }
        if (value == 47) {
            return 63;
        }
        if (value == 61) {
            return 0;
        }
        throw new IllegalArgumentException("invalid character " + new Character((char)value));
    }

    public static final byte[] decode(byte[] data) {
        if (data == null) {
            return null;
        }
        int lenResult = Base64Formatter.indLastNonFill(data) - data.length / 4;
        ByteArray result = new ByteArray();
        for (int indDest = 0; indDest < lenResult; indDest += 3) {
            result.addInt8(Base64Formatter.condense1(data, indDest * 4 / 3));
            if (lenResult > indDest + 1) {
                result.addInt8(Base64Formatter.condense2(data, indDest * 4 / 3));
            }
            if (lenResult <= indDest + 2) continue;
            result.addInt8(Base64Formatter.condense3(data, indDest * 4 / 3));
        }
        return result.asBytes();
    }

    private static int indLastNonFill(byte[] data) {
        int result = data.length;
        while (data[result - 1] == 61) {
            --result;
        }
        return result;
    }

    private static byte condense3(byte[] data, int sidx) {
        return (byte)(Base64Formatter.decodeAscii(data[sidx + 2]) << 6 & 0xFF | Base64Formatter.decodeAscii(data[sidx + 3]) & 0x3F);
    }

    private static byte condense2(byte[] data, int sidx) {
        return (byte)(Base64Formatter.decodeAscii(data[sidx + 1]) << 4 & 0xFF | Base64Formatter.decodeAscii(data[sidx + 2]) >>> 2 & 0xF);
    }

    private static byte condense1(byte[] data, int sidx) {
        return (byte)(Base64Formatter.decodeAscii(data[sidx]) << 2 & 0xFF | Base64Formatter.decodeAscii(data[sidx + 1]) >>> 4 & 3);
    }
}

