/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string;

import java.util.Arrays;

public class HexFormatter {
    private static final char[] symb = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toHexString(long value, int bytes) {
        StringBuffer result = new StringBuffer();
        bytes <<= 1;
        do {
            result.append(symb[(int)value & 0xF]);
            value >>= 4;
        } while (--bytes > 0);
        result.reverse();
        return result.toString();
    }

    public static long fromHexString(String value) throws NumberFormatException {
        long pow = 1L;
        long result = 0L;
        for (int i = value.length() - 1; i >= 0; --i) {
            int index = Arrays.binarySearch(symb, Character.toUpperCase(value.charAt(i)));
            if (index < 0) {
                throw new NumberFormatException(value);
            }
            result += (long)index * pow;
            pow *= 16L;
        }
        return result;
    }

    public static String toHexString(byte[] array) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(HexFormatter.toHexString(array[i], 1));
        }
        return result.toString();
    }

    public static String toHexString(char[] array, int size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(HexFormatter.toHexString(array[i], size));
        }
        return result.toString();
    }

    public static String toHexString(char[] array) {
        return HexFormatter.toHexString(array, 2);
    }

    public static String toHexString(short[] array, int size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(HexFormatter.toHexString(array[i], size));
        }
        return result.toString();
    }

    public static String toHexString(short[] array) {
        return HexFormatter.toHexString(array, 2);
    }

    public static String toHexString(int[] array, int size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(HexFormatter.toHexString(array[i], size));
        }
        return result.toString();
    }

    public static String toHexString(int[] array) {
        return HexFormatter.toHexString(array, 4);
    }

    public static String toHexString(long[] array, int size) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            result.append(HexFormatter.toHexString(array[i], size));
        }
        return result.toString();
    }

    public static String toHexString(long[] array) {
        return HexFormatter.toHexString(array, 8);
    }

    public static byte[] toByteArray(String string) throws NumberFormatException {
        int hexLen = 2;
        int rest = string.length();
        if (rest % 2 != 0) {
            throw new NumberFormatException();
        }
        byte[] result = new byte[rest / 2];
        int pos = 0;
        int i = 0;
        while (rest > 0) {
            result[i++] = (byte)HexFormatter.fromHexString(string.substring(pos, pos += 2));
            rest -= 2;
        }
        return result;
    }

    public static char[] toCharArray(String string, int size) throws NumberFormatException {
        if (size < 1 || size > 2) {
            throw new NumberFormatException();
        }
        int hexLen = size * 2;
        int rest = string.length();
        if (rest % hexLen != 0) {
            throw new NumberFormatException();
        }
        char[] result = new char[rest / hexLen];
        int pos = 0;
        int i = 0;
        while (rest > 0) {
            result[i++] = (char)HexFormatter.fromHexString(string.substring(pos, pos += hexLen));
            rest -= hexLen;
        }
        return result;
    }

    public static char[] toCharArray(String string) throws NumberFormatException {
        return HexFormatter.toCharArray(string, 2);
    }

    public static short[] toShortArray(String string, int size) throws NumberFormatException {
        if (size < 1 || size > 2) {
            throw new NumberFormatException();
        }
        int hexLen = size * 2;
        int rest = string.length();
        if (rest % hexLen != 0) {
            throw new NumberFormatException();
        }
        short[] result = new short[rest / hexLen];
        int pos = 0;
        int i = 0;
        while (rest > 0) {
            result[i++] = (short)HexFormatter.fromHexString(string.substring(pos, pos += hexLen));
            rest -= hexLen;
        }
        return result;
    }

    public static short[] toShortArray(String string) throws NumberFormatException {
        return HexFormatter.toShortArray(string, 2);
    }

    public static int[] toIntArray(String string, int size) throws NumberFormatException {
        if (size < 1 || size > 4) {
            throw new NumberFormatException();
        }
        int hexLen = size * 2;
        int rest = string.length();
        if (rest % hexLen != 0) {
            throw new NumberFormatException();
        }
        int[] result = new int[rest / hexLen];
        int pos = 0;
        int i = 0;
        while (rest > 0) {
            result[i++] = (int)HexFormatter.fromHexString(string.substring(pos, pos += hexLen));
            rest -= hexLen;
        }
        return result;
    }

    public static int[] toIntArray(String string) throws NumberFormatException {
        return HexFormatter.toIntArray(string, 4);
    }

    public static long[] toLongArray(String string, int size) throws NumberFormatException {
        if (size < 1 || size > 8) {
            throw new NumberFormatException();
        }
        int hexLen = size * 2;
        int rest = string.length();
        if (rest % hexLen != 0) {
            throw new NumberFormatException();
        }
        long[] result = new long[rest / hexLen];
        int pos = 0;
        int i = 0;
        while (rest > 0) {
            result[i++] = HexFormatter.fromHexString(string.substring(pos, pos += hexLen));
            rest -= hexLen;
        }
        return result;
    }

    public static long[] toLongArray(String string) throws NumberFormatException {
        return HexFormatter.toLongArray(string, 8);
    }
}

