/*
 * Decompiled with CFR 0.152.
 */
package ahc.util.string.sprintf;

import ahc.util.string.sprintf.SPrintfHandler;

class PaddingWrapper
implements SPrintfHandler {
    private static final String PADDING_SPACE = "                                                                                                ";
    private static final String PADDING_ZERO = "000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private final SPrintfHandler _inner;
    private final boolean _isLeft;
    private final int _minLength;
    private final boolean _isPaddingZero;

    public PaddingWrapper(SPrintfHandler inner, boolean isLeft, int minLength, boolean isPaddingZero) {
        this._inner = inner;
        this._isLeft = isLeft;
        this._minLength = minLength;
        this._isPaddingZero = isPaddingZero;
    }

    public boolean hasParameter() {
        return this._inner.hasParameter();
    }

    private final String createPadding(int numChars) {
        if (numChars <= 0) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        String paddingRaw = this._isPaddingZero ? PADDING_ZERO : PADDING_SPACE;
        int paddingLen = paddingRaw.length();
        for (int i = 0; i < numChars / paddingLen; ++i) {
            result.append(paddingRaw);
        }
        result.append(paddingRaw.substring(0, numChars % paddingLen));
        return result.toString();
    }

    public String handle(Object o) {
        String resultInner = this._inner.handle(o);
        String padding = this.createPadding(this._minLength - resultInner.length());
        if (this._isLeft) {
            return resultInner + padding;
        }
        return padding + resultInner;
    }
}

