/*
 * Decompiled with CFR 0.152.
 */
package org.openarchitectureware.check.editor.codeassist;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openarchitectureware.check.editor.lang.CheckTokens;
import org.openarchitectureware.expression.ExecutionContext;
import org.openarchitectureware.expression.codeassist.ProposalComputer;
import org.openarchitectureware.expression.codeassist.ProposalFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeywordProposalComputer
implements ProposalComputer {
    private static final Pattern PREFIX = Pattern.compile("([A-Za-z]+)\\z");

    public List<Object> computeProposals(String txt, ExecutionContext ctx, ProposalFactory factory) {
        String[] kw;
        String prefix = this.getPrefix(txt);
        ArrayList<Object> result = new ArrayList<Object>();
        String[] stringArray = kw = CheckTokens.allKeywords();
        int n = kw.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.toLowerCase().startsWith(prefix.toLowerCase())) {
                result.add(factory.createKeywordProposal(string, string, prefix));
            }
            ++n2;
        }
        return result;
    }

    private String getPrefix(String txt) {
        Matcher m = PREFIX.matcher(txt);
        if (m.find()) {
            return m.group(1);
        }
        return "";
    }
}

