/*
 * Decompiled with CFR 0.152.
 */
package org.prevayler.implementation;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import org.prevayler.Command;
import org.prevayler.PrevalentSystem;
import org.prevayler.implementation.CommandOutputStream;
import org.prevayler.implementation.NumberFileFinder;

class CommandInputStream {
    private NumberFileFinder fileFinder;
    private ObjectInputStream currentLogStream;

    public CommandInputStream(String string) throws IOException {
        this.fileFinder = new NumberFileFinder(string);
        CommandInputStream.out("Recovering system state...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrevalentSystem readLastSnapshot() throws IOException, ClassNotFoundException {
        PrevalentSystem prevalentSystem;
        File file = this.fileFinder.lastSnapshot();
        if (file == null) {
            return null;
        }
        CommandInputStream.out(file);
        ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
        try {
            prevalentSystem = (PrevalentSystem)objectInputStream.readObject();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            objectInputStream.close();
            throw throwable;
        }
        objectInputStream.close();
        return prevalentSystem;
    }

    public Command readCommand() throws IOException, ClassNotFoundException {
        if (this.currentLogStream == null) {
            this.currentLogStream = this.newLogStream();
        }
        try {
            return (Command)this.currentLogStream.readObject();
        }
        catch (EOFException eOFException) {
        }
        catch (ObjectStreamException objectStreamException) {
            this.logStreamExceptionMessage(objectStreamException);
        }
        catch (RuntimeException runtimeException) {
            this.logStreamExceptionMessage(runtimeException);
        }
        this.currentLogStream.close();
        this.currentLogStream = null;
        return this.readCommand();
    }

    public CommandOutputStream commandOutputStream() {
        return new CommandOutputStream(this.fileFinder.fileCreator());
    }

    private ObjectInputStream newLogStream() throws IOException {
        File file = this.fileFinder.nextPendingLog();
        CommandInputStream.out(file);
        return new ObjectInputStream(new FileInputStream(file));
    }

    private void logStreamExceptionMessage(Exception exception) {
        CommandInputStream.out("   " + exception);
        CommandInputStream.out("   Some commands might have been lost. Looking for the next file...");
    }

    private static void out(File file) {
        CommandInputStream.out("Reading " + file + "...");
    }

    private static void out(Object object) {
        System.out.println(object);
    }
}

