/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.compiler.doc.html;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import org.openorb.compiler.IdlCompiler;
import org.openorb.compiler.doc.IdlDoc;
import org.openorb.compiler.doc.html.content;
import org.openorb.compiler.object.IdlArray;
import org.openorb.compiler.object.IdlAttribute;
import org.openorb.compiler.object.IdlComment;
import org.openorb.compiler.object.IdlCommentSection;
import org.openorb.compiler.object.IdlConst;
import org.openorb.compiler.object.IdlContext;
import org.openorb.compiler.object.IdlEnumMember;
import org.openorb.compiler.object.IdlIdent;
import org.openorb.compiler.object.IdlInterface;
import org.openorb.compiler.object.IdlObject;
import org.openorb.compiler.object.IdlOp;
import org.openorb.compiler.object.IdlParam;
import org.openorb.compiler.object.IdlRaises;
import org.openorb.compiler.object.IdlSimple;
import org.openorb.compiler.object.IdlStateMember;
import org.openorb.compiler.object.IdlStructMember;
import org.openorb.compiler.object.IdlUnion;
import org.openorb.compiler.object.IdlUnionMember;
import org.openorb.compiler.object.IdlValue;
import org.openorb.compiler.object.IdlValueBox;
import org.openorb.compiler.object.IdlValueInheritance;

public class IdlToHTML {
    private int level = 0;
    private String prefix = "";
    private IdlObject _root;

    public String inversedPrefix(String prefix) {
        int index = 0;
        int previous_index = 0;
        Vector<String> seq = new Vector<String>();
        String inversed = new String("");
        try {
            while (index != -1) {
                index = prefix.indexOf(46, previous_index);
                if (index == -1) continue;
                seq.addElement(new String(prefix.substring(previous_index, index)));
                previous_index = index + 1;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            // empty catch block
        }
        seq.addElement(new String(prefix.substring(previous_index, prefix.length())));
        int i = seq.size() - 1;
        while (i >= 0) {
            if (!inversed.equals("")) {
                inversed = inversed + ".";
            }
            inversed = inversed + (String)seq.elementAt(i);
            --i;
        }
        return inversed;
    }

    public File createDirectory(String name, File writeInto) {
        boolean init = false;
        char[] tab = new char[name.length() + 20];
        int j = 0;
        int i = 0;
        while (i < name.length()) {
            if (name.charAt(i) == '.') {
                tab[j++] = File.separator.charAt(0);
                init = true;
            } else {
                tab[j++] = name.charAt(i);
            }
            ++i;
        }
        String fname = new String(tab, 0, j);
        String path = writeInto != null ? new String(writeInto.getPath() + File.separator + fname) : fname;
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (init) {
            IdlCompiler.packageName = fname;
        }
        return file;
    }

    public void write_index_file(String title, File writeInto) {
        PrintWriter output = this.create_file("index", writeInto);
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println(title);
        output.println("</TITLE>");
        output.println("</HEAD>");
        output.println("<FRAMESET cols=\"20%,80%\">");
        output.println("<FRAMESET rows=\"30%,70%\">");
        output.println("<FRAME src=\"overview-frame.html\" name=\"moduleListFrame\">");
        output.println("<FRAME src=\"alldescriptions-frame.html\" name=\"moduleFrame\">");
        output.println("</FRAMESET>");
        output.println("<FRAME src=\"overview-summary.html\" name=\"descriptionFrame\">");
        output.println("</FRAMESET>");
        output.println("<NOFRAMES>");
        output.println("<H2>");
        output.println("Frame Alert</H2>");
        output.println("<P>");
        output.println("This document is designed to be viewed using the frames feature. If you see this message, you are using a non-frame-capable web client.");
        output.println("<BR> Link to <A HREF=\"overview-summary.html\">Non-frame version.</A></NOFRAMES>");
        output.println("</HTML>");
        output.close();
    }

    public void write_overview_file(IdlObject obj, String title, File writeInto) {
        PrintWriter output = this.create_file("overview-frame", writeInto);
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println(title + " : Overview");
        output.println("</TITLE>");
        output.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        output.println("<SCRIPT LANGUAGE=\"JavaScript\">");
        output.println("<!-- ");
        output.println("function goTo(file1,file2)");
        output.println("{");
        output.println("window.parent.frames['moduleFrame'].location=file1;");
        output.println("window.parent.frames['descriptionFrame'].location=file2;");
        output.println("return");
        output.println("}");
        output.println("//-->");
        output.println("</SCRIPT>");
        output.println("</HEAD>");
        output.println("<BODY BGCOLOR=\"white\">");
        output.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        output.println("<TR>");
        output.println("<TD NOWRAP><FONT size=\"+1\" ID=\"FrameTitleFont\">");
        output.println("<B><b>" + title + "</b><br><font size=\"-1\"></font></B></FONT></TD>");
        output.println("</TR>");
        output.println("</TABLE>");
        output.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        output.println("<TR>");
        output.println("<TD NOWRAP><FONT ID=\"FrameItemFont\"><A HREF=\"JavaScript:goTo('alldescriptions-frame.html', 'overview-summary.html')\">All Descriptions</A></FONT>");
        output.println("<P>");
        output.println("<FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        output.println("Modules</FONT>");
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included() && obj.current().kind() == 1) {
                output.println("<BR>");
                output.println("<FONT ID=\"FrameItemFont\"><A HREF=\"JavaScript:goTo('" + obj.current().name() + "/alldescriptions-frame.html', '" + obj.current().name() + "/" + obj.current().name() + ".html')\">" + obj.current().name() + "</A></FONT>");
            }
            obj.next();
        }
        output.println("</TABLE>");
        output.close();
    }

    public void write_description_entry(String name, String link, PrintWriter output) {
        output.println("<A HREF=\"" + link + "\" TARGET=\"descriptionFrame\"><I>" + name + "</I></A>");
        output.println("<BR>");
    }

    public void write_description_entries(IdlObject obj, IdlObject[] list, PrintWriter output, String name) {
        output.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        output.println("<TR>");
        output.println("<TD NOWRAP><FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        output.println(name + "</FONT>&nbsp;");
        output.println("<FONT ID=\"FrameItemFont\">");
        output.println("<BR>");
        int i = 0;
        while (i < list.length) {
            this.write_description_entry(list[i].name(), this.get_link(list[i], obj), output);
            ++i;
        }
        output.println("</TR>");
        output.println("</TABLE>");
    }

    public void write_description_content(IdlObject obj, PrintWriter output) {
        content c = this.get_sorted_content(obj, true);
        if (c._sorted_module.length != 0) {
            this.write_description_entries(obj, c._sorted_module, output, "Module");
        }
        if (c._sorted_interface.length != 0) {
            this.write_description_entries(obj, c._sorted_interface, output, "Interface");
        }
        if (c._sorted_valuetype.length != 0) {
            this.write_description_entries(obj, c._sorted_valuetype, output, "ValueType");
        }
        if (c._sorted_valuebox.length != 0) {
            this.write_description_entries(obj, c._sorted_valuebox, output, "ValueBox");
        }
        if (c._sorted_exception.length != 0) {
            this.write_description_entries(obj, c._sorted_exception, output, "Exception");
        }
        if (c._sorted_struct.length != 0) {
            this.write_description_entries(obj, c._sorted_struct, output, "Struct");
        }
        if (c._sorted_union.length != 0) {
            this.write_description_entries(obj, c._sorted_union, output, "Union");
        }
        if (c._sorted_enum.length != 0) {
            this.write_description_entries(obj, c._sorted_enum, output, "Enum");
        }
        if (c._sorted_typedef.length != 0) {
            this.write_description_entries(obj, c._sorted_typedef, output, "TypeDef");
        }
        if (c._sorted_const.length != 0) {
            this.write_description_entries(obj, c._sorted_const, output, "Const");
        }
        if (c._sorted_native.length != 0) {
            this.write_description_entries(obj, c._sorted_native, output, "Native");
        }
        if (c._sorted_operation.length != 0) {
            this.write_description_entries(obj, c._sorted_operation, output, "Operation");
        }
        if (c._sorted_attribute.length != 0) {
            this.write_description_entries(obj, c._sorted_attribute, output, "Attribute");
        }
        if (c._sorted_member.length != 0) {
            this.write_description_entries(obj, c._sorted_member, output, "Member");
        }
        if (c._sorted_factory.length != 0) {
            this.write_description_entries(obj, c._sorted_factory, output, "Factory");
        }
    }

    public void write_alldescriptions_file(String title, File writeInto, IdlObject obj) {
        PrintWriter output = this.create_file("alldescriptions-frame", writeInto);
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println("All Descriptions");
        output.println("</TITLE>");
        output.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        output.println("</HEAD>");
        output.println("<BODY BGCOLOR=\"white\">");
        output.println("<FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        output.println("<A HREF=\"" + obj.name() + ".html\" TARGET=\"descriptionFrame\"><I>" + this.fullname(obj) + "</I></A>");
        output.println("<BR>");
        this.write_description_content(obj, output);
        output.close();
    }

    public void get_all_description_content(IdlObject obj, Vector list) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 13: 
                    case 14: 
                    case 25: 
                    case 27: {
                        list.addElement(obj.current());
                        break;
                    }
                    case 1: 
                    case 15: 
                    case 28: {
                        list.addElement(obj.current());
                        this.get_all_description_content(obj.current(), list);
                    }
                }
            }
            obj.next();
        }
    }

    public IdlObject[] sort_description_by_name(Vector list) {
        Vector<IdlObject> sortedLabels = new Vector<IdlObject>();
        int j = 0;
        while (j < list.size()) {
            IdlObject obj = (IdlObject)list.elementAt(j);
            boolean inserted = false;
            int i = 0;
            while (i < sortedLabels.size()) {
                if (this.fullname(obj).toLowerCase().compareTo(this.fullname((IdlObject)sortedLabels.elementAt(i)).toLowerCase()) < 0) {
                    sortedLabels.insertElementAt(obj, i);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                sortedLabels.addElement(obj);
            }
            ++j;
        }
        IdlObject[] ret = new IdlObject[sortedLabels.size()];
        int i = 0;
        while (i < sortedLabels.size()) {
            ret[i] = (IdlObject)sortedLabels.elementAt(i);
            ++i;
        }
        return ret;
    }

    public IdlObject[] sort_by_name(Vector list) {
        Vector<IdlObject> sortedLabels = new Vector<IdlObject>();
        int j = 0;
        while (j < list.size()) {
            IdlObject obj = (IdlObject)list.elementAt(j);
            boolean inserted = false;
            int i = 0;
            while (i < sortedLabels.size()) {
                if (obj.name().toLowerCase().compareTo(((IdlObject)sortedLabels.elementAt(i)).name().toLowerCase()) < 0) {
                    sortedLabels.insertElementAt(obj, i);
                    inserted = true;
                    break;
                }
                ++i;
            }
            if (!inserted) {
                sortedLabels.addElement(obj);
            }
            ++j;
        }
        IdlObject[] ret = new IdlObject[sortedLabels.size()];
        int i = 0;
        while (i < sortedLabels.size()) {
            ret[i] = (IdlObject)sortedLabels.elementAt(i);
            ++i;
        }
        return ret;
    }

    public void write_alldescriptions_file_index(String title, File writeInto, IdlObject obj) {
        PrintWriter output = this.create_file("alldescriptions-frame", writeInto);
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println("All Descriptions");
        output.println("</TITLE>");
        output.println("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"stylesheet.css\" TITLE=\"Style\">");
        output.println("</HEAD>");
        output.println("<BODY BGCOLOR=\"white\">");
        output.println("<TABLE BORDER=\"0\" WIDTH=\"100%\">");
        output.println("<TR>");
        output.println("<TD NOWRAP><FONT size=\"+1\" ID=\"FrameHeadingFont\">");
        output.println("All Descriptions</FONT>&nbsp;");
        output.println("<FONT ID=\"FrameItemFont\">");
        output.println("<BR>");
        Vector list = new Vector();
        this.get_all_description_content(obj, list);
        IdlObject[] sorted_list = this.sort_description_by_name(list);
        int i = 0;
        while (i < sorted_list.length) {
            this.write_description_entry(this.fullname(sorted_list[i]), this.get_full_link(sorted_list[i]), output);
            ++i;
        }
        output.println("</TR>");
        output.println("</TABLE>");
        output.close();
    }

    public void write_title(String title, PrintWriter output) {
        output.println("<HR>");
        output.println("<H2>");
        output.println(title + "</H2>");
        output.println("<body>");
    }

    public void write_title_center(String title, PrintWriter output) {
        output.println("<HR>");
        output.println("<CENTER>");
        output.println("<H2>");
        output.println(title + "</H2>");
        output.println("</CENTER>");
        output.println("<body>");
    }

    public void write_page_title(String title, PrintWriter output) {
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println(title);
        output.println("</TITLE>");
        output.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("stylesheet.css\" TITLE=\"Style\">");
        output.println("</HEAD>");
        output.println("<BODY BGCOLOR=\"white\">");
    }

    public void write_navigation_bar(PrintWriter output) {
        int i;
        output.println("<A NAME=\"navbar_top\"><!-- --></A>");
        output.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">");
        output.println("<TR>");
        output.println("<TD COLSPAN=2 BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">");
        output.println("<A NAME=\"navbar_top_firstrow\"><!-- --></A>");
        output.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"3\">");
        output.println("<TR ALIGN=\"center\" VALIGN=\"top\">");
        output.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Overview</B></FONT>&nbsp;</TD>");
        output.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Module</FONT>&nbsp;</TD>");
        output.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Interface</FONT>&nbsp;</TD>");
        output.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Type</FONT>&nbsp;</TD>");
        output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("overview-tree.html\"><FONT ID=\"NavBarFont1\"><B>Tree</B></FONT></A>&nbsp;</TD>");
        output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("deprecated-list.html\"><FONT ID=\"NavBarFont1\"><B>Deprecated</B></FONT></A>&nbsp;</TD>");
        output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("overview-index.html\"><FONT ID=\"NavBarFont1\"><B>Index</B></FONT></A>&nbsp;</TD>");
        output.println("</TR>");
        output.println("</TABLE>");
        output.println("</TD>");
        output.println("<TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3><EM>");
        output.println("&nbsp;</EM>");
        output.println("</TD>");
        output.println("</TR>");
        output.println("<TR>");
        output.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        output.println("&nbsp;PREV&nbsp;");
        output.println("&nbsp;NEXT</FONT></TD>");
        output.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        output.println("<A HREF=\"index.html\" TARGET=\"_top\"><B>FRAMES</B></A>  &nbsp;");
        output.println("&nbsp;<A HREF=\"overview-summary.html\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
        output.println("</TR>");
        output.println("</TABLE>");
    }

    public void write_navigation_bar_index(PrintWriter output, int index) {
        int i;
        output.println("<A NAME=\"navbar_top\"><!-- --></A>");
        output.println("<TABLE BORDER=\"0\" WIDTH=\"100%\" CELLPADDING=\"1\" CELLSPACING=\"0\">");
        output.println("<TR>");
        output.println("<TD COLSPAN=2 BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">");
        output.println("<A NAME=\"navbar_top_firstrow\"><!-- --></A>");
        output.println("<TABLE BORDER=\"0\" CELLPADDING=\"0\" CELLSPACING=\"3\">");
        output.println("<TR ALIGN=\"center\" VALIGN=\"top\">");
        output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
        if (this.level > 0) {
            i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("overview-summary.html\"><FONT ID=\"NavBarFont1\"><B>Overview</B></FONT></A>&nbsp;</TD>");
        output.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Module</FONT>&nbsp;</TD>");
        output.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Interface</FONT>&nbsp;</TD>");
        output.println("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <FONT ID=\"NavBarFont1\">Type</FONT>&nbsp;</TD>");
        if (index == 1) {
            output.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Tree</B></FONT>&nbsp;</TD>");
        } else {
            output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
            if (this.level > 0) {
                i = 0;
                while (i < this.level) {
                    output.print("../");
                    ++i;
                }
            }
            output.println("overview-tree.html\"><FONT ID=\"NavBarFont1\"><B>Tree</B></FONT></A>&nbsp;</TD>");
        }
        if (index == 2) {
            output.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Deprecated</B></FONT>&nbsp;</TD>");
        } else {
            output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
            if (this.level > 0) {
                i = 0;
                while (i < this.level) {
                    output.print("../");
                    ++i;
                }
            }
            output.println("deprecated-list.html\"><FONT ID=\"NavBarFont1\"><B>Deprecated</B></FONT></A>&nbsp;</TD>");
        }
        if (index == 3) {
            output.println("<TD BGCOLOR=\"#FFFFFF\" ID=\"NavBarCell1Rev\"> &nbsp;<FONT ID=\"NavBarFont1Rev\"><B>Index</B></FONT>&nbsp;</TD>");
        } else {
            output.print("<TD BGCOLOR=\"#EEEEFF\" ID=\"NavBarCell1\">    <A HREF=\"");
            if (this.level > 0) {
                i = 0;
                while (i < this.level) {
                    output.print("../");
                    ++i;
                }
            }
            output.println("overview-index.html\"><FONT ID=\"NavBarFont1\"><B>Index</B></FONT></A>&nbsp;</TD>");
        }
        output.println("</TR>");
        output.println("</TABLE>");
        output.println("</TD>");
        output.println("<TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=3><EM>");
        output.println("&nbsp;</EM>");
        output.println("</TD>");
        output.println("</TR>");
        output.println("<TR>");
        output.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        output.println("&nbsp;PREV&nbsp;");
        output.println("&nbsp;NEXT</FONT></TD>");
        output.println("<TD BGCOLOR=\"white\" ID=\"NavBarCell2\"><FONT SIZE=\"-2\">");
        output.println("<A HREF=\"index.html\" TARGET=\"_top\"><B>FRAMES</B></A>  &nbsp;");
        output.println("&nbsp;<A HREF=\"overview-summary.html\" TARGET=\"_top\"><B>NO FRAMES</B></A></FONT></TD>");
        output.println("</TR>");
        output.println("</TABLE>");
    }

    public void write_begin_table(String title, PrintWriter output) {
        output.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
        output.println("<TR BGCOLOR=\"#CCCCFF\" ID=\"TableHeadingColor\">");
        output.println("<TD COLSPAN=2><FONT SIZE=\"+2\">");
        output.println("<B>" + title + "</B></FONT></TD>");
        output.println("</TR>");
    }

    public void write_table_entry(String name, String link, String description, PrintWriter output) {
        output.println("<TR BGCOLOR=\"white\" ID=\"TableRowColor\">");
        output.println("<TD WIDTH=\"20%\"><B><A HREF=\"" + link + "\">" + name + "</A></B></TD>");
        output.println("<TD>" + description);
        output.println("</TD>");
        output.println("</TR>");
    }

    public void write_summary_file(String title, File writeInto) {
        PrintWriter output = this.create_file("overview-summary", writeInto);
        this.write_page_title(title + " : overview", output);
        this.write_navigation_bar(output);
        this.write_title_center(title, output);
        this.translateContentTable(this._root, output, 3);
        output.println("</TABLE>");
        output.close();
    }

    public void write_style_sheet(File writeInto) {
        PrintWriter output = this.create_file("stylesheet.css", writeInto);
        output.println("/***************************************************************************");
        output.println(" org.openorb, IDL to HTML Style Sheet");
        output.println(" ***************************************************************************/");
        output.println("");
        output.println("/* Page background color */");
        output.println("body { background-color: #FFFFFF }");
        output.println("");
        output.println("/* Table colors */");
        output.println("#TableHeadingColor     { background: #CCCCFF } /* Dark mauve */");
        output.println("#TableSubHeadingColor  { background: #EEEEFF } /* Light mauve */");
        output.println("#TableRowColor         { background: #FFFFFF } /* White */");
        output.println("");
        output.println("/* Font used in left-hand frame lists */");
        output.println("#FrameTitleFont   { font-size: normal; font-family: normal }");
        output.println("#FrameHeadingFont { font-size: normal; font-family: normal }");
        output.println("#FrameItemFont    { font-size: normal; font-family: normal }");
        output.println("");
        output.println("/* Navigation bar fonts and colors */");
        output.println("#NavBarCell1    { background-color:#EEEEFF;}/* Light mauve */");
        output.println("#NavBarCell1Rev { background-color:#00008B;}/* Dark Blue */");
        output.println("#NavBarFont1    { font-family: Arial, Helvetica, sans-serif; color:#000000;}");
        output.println("#NavBarFont1Rev { font-family: Arial, Helvetica, sans-serif; color:#FFFFFF;}");
        output.println("");
        output.println("#NavBarCell2    { font-family: Arial, Helvetica, sans-serif; background-color:#FFFFFF;}");
        output.println("#NavBarCell3    { font-family: Arial, Helvetica, sans-serif; background-color:#FFFFFF;}");
        output.close();
    }

    public void get_all_content(IdlObject obj, Vector list, boolean limit) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 13: 
                    case 14: 
                    case 16: 
                    case 17: 
                    case 25: 
                    case 27: 
                    case 29: 
                    case 30: {
                        list.addElement(obj.current());
                        break;
                    }
                    case 1: 
                    case 15: 
                    case 28: {
                        list.addElement(obj.current());
                        if (limit) break;
                        this.get_all_content(obj.current(), list, limit);
                    }
                }
            }
            obj.next();
        }
    }

    public void write_index(File writeInto) {
        PrintWriter output = this.create_file("overview-index", writeInto);
        IdlComment comment = null;
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println("Index");
        output.println("</TITLE>");
        output.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("stylesheet.css\" TITLE=\"Style\">");
        output.println("</HEAD>");
        this.write_navigation_bar_index(output, 3);
        Vector content2 = new Vector();
        this.get_all_content(this._root, content2, false);
        IdlObject[] list = this.sort_by_name(content2);
        char letter = list[0].name().toUpperCase().charAt(0);
        boolean first = true;
        output.println("<DL>");
        int i = 0;
        while (i < list.length) {
            if (letter != list[i].name().toUpperCase().charAt(0)) {
                letter = list[i].name().toUpperCase().charAt(0);
                first = true;
            }
            if (first) {
                output.println("<H1>" + letter + "</H1>");
                first = false;
            }
            output.println("<DT>");
            output.print("<A HREF=\"" + this.get_link(list[i], this._root) + "\" TARGET=\"descriptionFrame\">" + list[i].name() + "</A>");
            output.print(" - ");
            switch (list[i].kind()) {
                case 15: {
                    output.print("Interface " + this.fullname_idl(list[i]));
                    break;
                }
                case 1: {
                    output.print("Module " + this.fullname_idl(list[i]));
                    break;
                }
                case 28: {
                    output.print("ValueType " + this.fullname_idl(list[i]));
                    break;
                }
                case 27: {
                    output.print("ValueBox " + this.fullname_idl(list[i]));
                    break;
                }
                case 14: {
                    output.print("Exception " + this.fullname_idl(list[i]));
                    break;
                }
                case 3: {
                    output.print("Struct " + this.fullname_idl(list[i]));
                    break;
                }
                case 4: {
                    output.print("Union " + this.fullname_idl(list[i]));
                    break;
                }
                case 2: {
                    output.print("Enum " + this.fullname_idl(list[i]));
                    break;
                }
                case 13: {
                    output.print("TypeDef " + this.fullname_idl(list[i]));
                    break;
                }
                case 7: {
                    output.print("Const " + this.fullname_idl(list[i]));
                    break;
                }
                case 25: {
                    output.print("Native " + this.fullname_idl(list[i]));
                    break;
                }
                case 16: {
                    output.print("Operation " + this.fullname_idl(list[i]));
                    break;
                }
                case 17: {
                    output.print("Attribute " + this.fullname_idl(list[i]));
                    break;
                }
                case 29: {
                    output.print("Member " + this.fullname_idl(list[i]));
                    break;
                }
                case 30: {
                    output.print("Factory " + this.fullname_idl(list[i]));
                }
            }
            comment = list[i].getComment();
            if (comment != null) {
                output.print(" - ");
                output.println(this.get_summary_description(list[i]));
            }
            ++i;
        }
        output.println("</DL>");
        output.println("</BODY>");
        output.println("</HTML>");
        output.close();
    }

    public void write_branch(IdlObject obj, PrintWriter output) {
        Vector v = new Vector();
        this.get_all_content(obj, v, true);
        IdlObject[] list = this.sort_by_name(v);
        output.println("<UL>");
        int i = 0;
        while (i < list.length) {
            output.print("<LI>");
            output.print("<A HREF=\"" + this.get_full_link(list[i]) + "\" TARGET=\"descriptionFrame\">" + list[i].name() + "</A> - ");
            switch (list[i].kind()) {
                case 15: {
                    output.print("Interface " + this.fullname_idl(list[i]));
                    break;
                }
                case 1: {
                    output.print("Module " + this.fullname_idl(list[i]));
                    break;
                }
                case 28: {
                    output.print("ValueType " + this.fullname_idl(list[i]));
                    break;
                }
                case 27: {
                    output.print("ValueBox " + this.fullname_idl(list[i]));
                    break;
                }
                case 14: {
                    output.print("Exception " + this.fullname_idl(list[i]));
                    break;
                }
                case 3: {
                    output.print("Struct " + this.fullname_idl(list[i]));
                    break;
                }
                case 4: {
                    output.print("Union " + this.fullname_idl(list[i]));
                    break;
                }
                case 2: {
                    output.print("Enum " + this.fullname_idl(list[i]));
                    break;
                }
                case 13: {
                    output.print("TypeDef " + this.fullname_idl(list[i]));
                    break;
                }
                case 7: {
                    output.print("Const " + this.fullname_idl(list[i]));
                    break;
                }
                case 25: {
                    output.print("Native " + this.fullname_idl(list[i]));
                    break;
                }
                case 16: {
                    output.print("Operation " + this.fullname_idl(list[i]));
                    break;
                }
                case 17: {
                    output.print("Attribute " + this.fullname_idl(list[i]));
                    break;
                }
                case 29: {
                    output.print("Member " + this.fullname_idl(list[i]));
                    break;
                }
                case 30: {
                    output.print("Factory " + this.fullname_idl(list[i]));
                }
            }
            output.println("");
            switch (list[i].kind()) {
                case 1: 
                case 15: 
                case 28: {
                    this.write_branch(list[i], output);
                }
            }
            ++i;
        }
        output.println("</UL>");
    }

    public void write_tree(File writeInto) {
        PrintWriter output = this.create_file("overview-tree", writeInto);
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println("Index");
        output.println("</TITLE>");
        output.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("stylesheet.css\" TITLE=\"Style\">");
        output.println("</HEAD>");
        this.write_navigation_bar_index(output, 1);
        this.write_title_center("Hierarchy for all IDL descriptions", output);
        this.write_branch(this._root, output);
        output.println("</BODY>");
        output.println("</HTML>");
        output.close();
    }

    public void write_deprecated_section(IdlObject[] obj, String title, PrintWriter output) {
        if (this.is_any_deprecated(obj)) {
            this.write_begin_table(title, output);
            int i = 0;
            while (i < obj.length) {
                if (this.is_deprecated(obj[i])) {
                    this.write_table_entry(obj[i].name(), this.get_full_link(obj[i]), this.get_deprecation(obj[i]), output);
                }
                ++i;
            }
            output.println("</TABLE><BR>");
        }
    }

    public void write_deprecated(File writeInto) {
        PrintWriter output = this.create_file("deprecated-list", writeInto);
        output.println("<HTML>");
        output.println("<HEAD>");
        output.println("<!-- org.openorb, IDL to HTML generator  -->");
        output.println("<META http-equiv=\"content-type\" content=\"text/html; charset=" + IdlDoc.codepage + "\">");
        output.println("<TITLE>");
        output.println("Index");
        output.println("</TITLE>");
        output.print("<LINK REL =\"stylesheet\" TYPE=\"text/css\" HREF=\"");
        if (this.level > 0) {
            int i = 0;
            while (i < this.level) {
                output.print("../");
                ++i;
            }
        }
        output.println("stylesheet.css\" TITLE=\"Style\">");
        output.println("</HEAD>");
        this.write_navigation_bar_index(output, 2);
        this.write_title_center("Deprecated IDL descriptions", output);
        content c = this.get_sorted_content(this._root, false);
        this.write_deprecated_section(c._sorted_module, "Deprecated Modules", output);
        this.write_deprecated_section(c._sorted_interface, "Deprecated Interfaces", output);
        this.write_deprecated_section(c._sorted_valuetype, "Deprecated ValueTypes", output);
        this.write_deprecated_section(c._sorted_valuebox, "Deprecated ValueBox", output);
        this.write_deprecated_section(c._sorted_exception, "Deprecated Exceptions", output);
        this.write_deprecated_section(c._sorted_struct, "Deprecated Structs", output);
        this.write_deprecated_section(c._sorted_union, "Deprecated Unions", output);
        this.write_deprecated_section(c._sorted_enum, "Deprecated Enums", output);
        this.write_deprecated_section(c._sorted_typedef, "Deprecated TypeDefs", output);
        this.write_deprecated_section(c._sorted_const, "Deprecated Consts", output);
        this.write_deprecated_section(c._sorted_native, "Deprecated Natives", output);
        this.write_deprecated_section(c._sorted_operation, "Deprecated Operations", output);
        this.write_deprecated_section(c._sorted_attribute, "Deprecated Attributes", output);
        this.write_deprecated_section(c._sorted_member, "Deprecated Members", output);
        this.write_deprecated_section(c._sorted_factory, "Deprecated Factories", output);
        output.println("</BODY>");
        output.println("</HTML>");
        output.close();
    }

    public String adapt_string(String src) {
        return src;
    }

    public String get_link(IdlObject obj, IdlObject ref) {
        String ret = "";
        String begin = "";
        String sub = "";
        int level = 0;
        IdlObject o1 = obj;
        IdlObject o2 = ref;
        String path_o1 = this.get_path(o1);
        String path_o2 = this.get_path(o2);
        int i = 0;
        int max = 0;
        max = path_o1.length() > path_o2.length() ? path_o2.length() : path_o1.length();
        while (i < max) {
            if (path_o2.charAt(i) != path_o1.charAt(i)) break;
            ++i;
        }
        if (i != 0) {
            --i;
        }
        int j = i;
        while (j > 0) {
            if (path_o2.charAt(j) == '/') {
                ++j;
                break;
            }
            --j;
        }
        sub = path_o2.substring(j);
        if (sub.startsWith("/")) {
            sub = sub.substring(1);
        }
        if (!sub.equals("")) {
            ++level;
        }
        j = i;
        while (j > 0) {
            if (path_o1.charAt(j) == '/') {
                ++j;
                break;
            }
            --j;
        }
        begin = path_o1.substring(j);
        i = 0;
        while (i < sub.length()) {
            if (sub.charAt(i) == '/') {
                ++level;
            }
            ++i;
        }
        j = 0;
        while (j < level) {
            ret = ret + "../";
            ++j;
        }
        if (!begin.equals("")) {
            ret = ret + begin;
        }
        if (!ret.equals("") && !ret.endsWith("/")) {
            ret = ret + "/";
        }
        switch (o1.kind()) {
            case 1: 
            case 15: 
            case 18: 
            case 28: 
            case 33: {
                ret = ret + obj.name() + ".html";
                break;
            }
            default: {
                ret = o1.upper() == this._root ? ret + "overview-summary" : ret + obj.upper().name();
                ret = ret + ".html#" + obj.name();
            }
        }
        if (ret.startsWith("/")) {
            ret = "." + ret;
        }
        return ret;
    }

    public String get_full_link(IdlObject obj) {
        if (obj.kind() == 15) {
            return this.fullname_link(obj) + "/" + obj.name() + ".html";
        }
        if (obj.kind() == 1) {
            return this.fullname_link(obj) + "/" + obj.name() + ".html";
        }
        if (obj.kind() == 28) {
            return this.fullname_link(obj) + "/" + obj.name() + ".html";
        }
        if (obj.upper() == this._root) {
            return "overview-summary.html#" + obj.name();
        }
        return this.fullname_link(obj.upper()) + "/" + obj.upper().name() + ".html#" + obj.name();
    }

    public String get_description(IdlObject obj) {
        IdlComment comment = obj.getComment();
        if (comment != null && comment.get_description() != null) {
            return this.adapt_string(comment.get_description());
        }
        return "";
    }

    public boolean is_deprecated(IdlObject obj) {
        IdlComment comment = obj.getComment();
        if (comment != null) {
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                if (sections[i].kind().value() == 6) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean is_any_deprecated(IdlObject[] obj) {
        int i = 0;
        while (i < obj.length) {
            if (this.is_deprecated(obj[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String get_deprecation(IdlObject obj) {
        IdlComment comment = obj.getComment();
        if (comment != null) {
            IdlCommentSection[] sections = comment.get_sections();
            int i = 0;
            while (i < sections.length) {
                if (sections[i].kind().value() == 6) {
                    return sections[i].get_description();
                }
                ++i;
            }
        }
        return "";
    }

    public String get_summary_description(IdlObject obj) {
        IdlComment comment = obj.getComment();
        String description = null;
        if (comment != null && (description = comment.get_description()) != null) {
            if ((description = this.adapt_string(description)).indexOf(".") != -1) {
                return description.substring(0, description.indexOf(".") + 1);
            }
            if (description.indexOf("\n\n") != -1) {
                return description.substring(0, description.indexOf("\n\n") + 1);
            }
            return description;
        }
        return "";
    }

    public IdlCommentSection[] get_sections(IdlCommentSection[] src, int section_type) {
        Vector<IdlCommentSection> list = new Vector<IdlCommentSection>();
        int i = 0;
        while (i < src.length) {
            if (src[i].kind().value() == section_type) {
                list.addElement(src[i]);
            }
            ++i;
        }
        IdlCommentSection[] ret = new IdlCommentSection[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            ret[i2] = (IdlCommentSection)list.elementAt(i2);
            ++i2;
        }
        return ret;
    }

    public void write_section(IdlCommentSection[] sections, int section_type, String section_title, PrintWriter output, boolean highlight_first) {
        String desc = "";
        String first = "";
        IdlCommentSection[] section = this.get_sections(sections, section_type);
        if (section.length != 0) {
            output.println("<H4>" + section_title + "</H4><UL>");
            int i = 0;
            while (i < section.length) {
                desc = this.adapt_string(section[i].get_description().trim());
                if (highlight_first) {
                    int idx = desc.indexOf(" ");
                    int idx2 = desc.indexOf("\t");
                    if (idx == -1 && idx2 != -1) {
                        idx = idx2;
                    } else if (idx2 != -1 && idx2 < idx) {
                        idx = idx2;
                    }
                    if (idx != -1) {
                        first = desc.substring(0, idx);
                        desc = desc.substring(idx + 1);
                        output.print("<B><I> " + first + " </I></B> - ");
                    }
                }
                output.println(desc);
                output.println("<BR>");
                ++i;
            }
            output.println("</UL><BR>");
        }
    }

    public void write_description(IdlObject obj, PrintWriter output) {
        IdlComment comment = obj.getComment();
        output.println(this.get_description(obj));
        output.println("<BR>");
        if (comment != null) {
            IdlCommentSection[] sections = comment.get_sections();
            this.write_section(sections, 3, "Parameter", output, true);
            this.write_section(sections, 4, "Return", output, false);
            this.write_section(sections, 1, "Exception", output, true);
            this.write_section(sections, 5, "See", output, true);
            this.write_section(sections, 6, "Deprecated", output, false);
        }
    }

    public void translateSubTypeSummary(IdlObject ref, IdlObject[] list, PrintWriter output, String name) {
        this.write_begin_table(name, output);
        int i = 0;
        while (i < list.length) {
            String desc = this.get_summary_description(list[i]);
            if (this.is_deprecated(list[i])) {
                desc = "<B>deprecated</B> - " + desc;
            }
            this.write_table_entry(list[i].name(), this.get_link(list[i], ref), desc, output);
            ++i;
        }
        output.println("</TABLE>");
        output.println("<BR>");
    }

    public void translateSubTypeDetails(IdlObject ref, IdlObject[] list, PrintWriter output, String name) {
        this.write_begin_table(name, output);
        output.println("</TABLE>");
        int i = 0;
        while (i < list.length) {
            switch (list[i].kind()) {
                case 27: {
                    this.translateValueBox(list[i], output);
                    break;
                }
                case 14: {
                    this.translateException(list[i], output);
                    break;
                }
                case 3: {
                    this.translateStruct(list[i], output);
                    break;
                }
                case 4: {
                    this.translateUnion(list[i], output);
                    break;
                }
                case 2: {
                    this.translateEnum(list[i], output);
                    break;
                }
                case 13: {
                    this.translateTypedef(list[i], output);
                    break;
                }
                case 7: {
                    this.translateConstant(list[i], output);
                    break;
                }
                case 25: {
                    this.translateNative(list[i], output);
                    break;
                }
                case 16: {
                    this.translateOperation(list[i], output);
                    break;
                }
                case 17: {
                    this.translateAttribute(list[i], output);
                    break;
                }
                case 29: {
                    this.translateStateMember(list[i], output);
                    break;
                }
                case 30: {
                    this.translateFactory(list[i], output);
                }
            }
            ++i;
        }
        output.println("<BR>");
    }

    public void translateContentTable(IdlObject obj, PrintWriter output, int type) {
        content c = this.get_sorted_content(obj, true);
        if (type == 1 || type == 3) {
            if (c._sorted_module.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_module, output, "Module Summary");
            }
            if (c._sorted_interface.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_interface, output, "Interface Summary");
            }
            if (c._sorted_valuetype.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_valuetype, output, "ValueType Summary");
            }
            if (c._sorted_valuebox.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_valuebox, output, "ValueBox Summary");
            }
            if (c._sorted_exception.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_exception, output, "Exception Summary");
            }
            if (c._sorted_struct.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_struct, output, "Struct Summary");
            }
            if (c._sorted_union.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_union, output, "Union Summary");
            }
            if (c._sorted_enum.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_enum, output, "Enum Summary");
            }
            if (c._sorted_typedef.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_typedef, output, "TypeDef Summary");
            }
            if (c._sorted_const.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_const, output, "Const Summary");
            }
            if (c._sorted_native.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_native, output, "Native Summary");
            }
            if (c._sorted_operation.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_operation, output, "Operation Summary");
            }
            if (c._sorted_attribute.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_attribute, output, "Attribute Summary");
            }
            if (c._sorted_member.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_member, output, "Member Summary");
            }
            if (c._sorted_factory.length != 0) {
                this.translateSubTypeSummary(obj, c._sorted_factory, output, "Factory Summary");
            }
        }
        if (type == 2 || type == 3) {
            if (c._sorted_valuebox.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_valuebox, output, "ValueBox Details");
            }
            if (c._sorted_exception.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_exception, output, "Exception Details");
            }
            if (c._sorted_struct.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_struct, output, "Struct Details");
            }
            if (c._sorted_union.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_union, output, "Union Details");
            }
            if (c._sorted_enum.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_enum, output, "Enum Details");
            }
            if (c._sorted_typedef.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_typedef, output, "TypeDef Details");
            }
            if (c._sorted_const.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_const, output, "Const Details");
            }
            if (c._sorted_native.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_native, output, "Native Details");
            }
            if (c._sorted_operation.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_operation, output, "Operation Details");
            }
            if (c._sorted_attribute.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_attribute, output, "Attribute Details");
            }
            if (c._sorted_member.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_member, output, "Member Details");
            }
            if (c._sorted_factory.length != 0) {
                this.translateSubTypeDetails(obj, c._sorted_factory, output, "Factory Details");
            }
        }
    }

    public PrintWriter create_file(String file_name, File writeInto) {
        String path = null;
        path = file_name.endsWith(".css") ? new String(writeInto.getPath() + File.separator + file_name) : new String(writeInto.getPath() + File.separator + file_name + ".html");
        File file = new File(path);
        PrintWriter printout = null;
        try {
            FileOutputStream output = new FileOutputStream(file);
            DataOutputStream dataout = new DataOutputStream(output);
            printout = new PrintWriter(dataout);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return printout;
    }

    public String fullname(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            v.addElement(obj2.name());
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        if (IdlDoc.usePrefix && obj.getPrefix() != null) {
            if (!name.equals("")) {
                name = name + ".";
            }
            name = name + this.inversedPrefix(obj.getPrefix());
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + ".";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public String fullname_idl(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            v.addElement(obj2.name());
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + "::";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public String fullname_link(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        boolean first = false;
        while (obj2 != null) {
            switch (obj2.kind()) {
                case 19: {
                    break;
                }
                default: {
                    v.addElement(obj2.name());
                }
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
            first = true;
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + "/";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public String get_path(IdlObject obj) {
        Vector<String> v = new Vector<String>();
        IdlObject obj2 = obj;
        String name = new String("");
        while (obj2 != null) {
            switch (obj2.kind()) {
                case 1: 
                case 15: 
                case 18: 
                case 28: 
                case 33: {
                    v.addElement(obj2.name());
                }
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
        }
        int i = v.size() - 1;
        while (i >= 0) {
            String s = (String)v.elementAt(i);
            if (s != null) {
                if (!name.equals("")) {
                    name = name + "/";
                }
                name = name + s;
            }
            --i;
        }
        return name;
    }

    public void sort_type_content(IdlObject obj, content c, boolean limit) {
        if (c == null) {
            c = new content();
        }
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        c._module.addElement(obj.current());
                        if (limit) break;
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 15: {
                        c._interface.addElement(obj.current());
                        if (limit) break;
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 28: {
                        c._valuetype.addElement(obj.current());
                        if (limit) break;
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 27: {
                        c._valuebox.addElement(obj.current());
                        break;
                    }
                    case 14: {
                        c._exception.addElement(obj.current());
                        break;
                    }
                    case 3: {
                        c._struct.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 4: {
                        c._union.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 2: {
                        c._enum.addElement(obj.current());
                        break;
                    }
                    case 13: {
                        c._typedef.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 7: {
                        c._const.addElement(obj.current());
                        break;
                    }
                    case 25: {
                        c._native.addElement(obj.current());
                        break;
                    }
                    case 16: {
                        c._operation.addElement(obj.current());
                        break;
                    }
                    case 17: {
                        c._attribute.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 29: {
                        c._member.addElement(obj.current());
                        this.sort_type_content(obj.current(), c, limit);
                        break;
                    }
                    case 30: {
                        c._factory.addElement(obj.current());
                    }
                }
            }
            obj.next();
        }
    }

    public content get_sorted_content(IdlObject obj, boolean limit) {
        content ret = new content();
        this.sort_type_content(obj, ret, limit);
        ret._sorted_module = ret._module.size() != 0 ? this.sort_description_by_name(ret._module) : new IdlObject[0];
        ret._sorted_interface = ret._interface.size() != 0 ? this.sort_description_by_name(ret._interface) : new IdlObject[0];
        ret._sorted_valuetype = ret._valuetype.size() != 0 ? this.sort_description_by_name(ret._valuetype) : new IdlObject[0];
        ret._sorted_valuebox = ret._valuebox.size() != 0 ? this.sort_description_by_name(ret._valuebox) : new IdlObject[0];
        ret._sorted_exception = ret._exception.size() != 0 ? this.sort_description_by_name(ret._exception) : new IdlObject[0];
        ret._sorted_struct = ret._struct.size() != 0 ? this.sort_description_by_name(ret._struct) : new IdlObject[0];
        ret._sorted_union = ret._union.size() != 0 ? this.sort_description_by_name(ret._union) : new IdlObject[0];
        ret._sorted_enum = ret._enum.size() != 0 ? this.sort_description_by_name(ret._enum) : new IdlObject[0];
        ret._sorted_typedef = ret._typedef.size() != 0 ? this.sort_description_by_name(ret._typedef) : new IdlObject[0];
        ret._sorted_const = ret._const.size() != 0 ? this.sort_description_by_name(ret._const) : new IdlObject[0];
        ret._sorted_native = ret._native.size() != 0 ? this.sort_description_by_name(ret._native) : new IdlObject[0];
        ret._sorted_operation = ret._operation.size() != 0 ? this.sort_description_by_name(ret._operation) : new IdlObject[0];
        ret._sorted_attribute = ret._attribute.size() != 0 ? this.sort_description_by_name(ret._attribute) : new IdlObject[0];
        ret._sorted_member = ret._member.size() != 0 ? this.sort_description_by_name(ret._member) : new IdlObject[0];
        ret._sorted_factory = ret._factory.size() != 0 ? this.sort_description_by_name(ret._factory) : new IdlObject[0];
        return ret;
    }

    public void translateHierarchy(IdlObject obj, PrintWriter output) {
        Vector<IdlObject> v = new Vector<IdlObject>();
        IdlObject obj2 = obj;
        while (obj2 != null) {
            switch (obj2.kind()) {
                case 1: 
                case 15: 
                case 18: 
                case 28: 
                case 33: {
                    v.addElement(obj2);
                }
            }
            if (obj2.upper() != null && obj2.upper().kind() == 0) break;
            obj2 = obj2.upper();
        }
        if (v.size() > 1) {
            String dec = "";
            output.println("<PRE>");
            int i = v.size() - 1;
            while (i >= 0) {
                dec = dec + "   ";
                if (i == 0) {
                    output.println("<B>" + this.fullname((IdlObject)v.elementAt(i)) + "</B>");
                } else {
                    output.println("<A HREF=\"" + this.get_link((IdlObject)v.elementAt(i), obj) + "\" TARGET=\"descriptionFrame\">" + this.fullname((IdlObject)v.elementAt(i)) + "</A>");
                }
                if (i != 0) {
                    output.println(dec + "|");
                    output.print(dec + "+--");
                }
                --i;
            }
            output.println("</PRE>");
        }
    }

    public String translateType(IdlObject obj, String desc, String name, boolean write, IdlObject current) {
        IdlSimple simple = null;
        switch (obj.kind()) {
            case 8: {
                simple = (IdlSimple)obj;
                switch (simple.internal()) {
                    case 55: {
                        desc = desc + "void";
                        break;
                    }
                    case 34: {
                        desc = desc + "float";
                        break;
                    }
                    case 30: {
                        desc = desc + "double";
                        break;
                    }
                    case 47: {
                        desc = desc + "short";
                        break;
                    }
                    case 66: {
                        desc = desc + "unsigned short";
                        break;
                    }
                    case 38: {
                        desc = desc + "long";
                        break;
                    }
                    case 65: {
                        desc = desc + "unsigned long";
                        break;
                    }
                    case 73: {
                        desc = desc + "long long";
                        break;
                    }
                    case 74: {
                        desc = desc + "unsigned long long";
                        break;
                    }
                    case 26: {
                        desc = desc + "char";
                        break;
                    }
                    case 71: {
                        desc = desc + "wchar";
                        break;
                    }
                    case 24: {
                        desc = desc + "boolean";
                        break;
                    }
                    case 41: {
                        desc = desc + "octet";
                        break;
                    }
                    case 22: {
                        desc = desc + "any";
                        break;
                    }
                    case 70: {
                        desc = desc + "CORBA::TypeCode";
                        break;
                    }
                    case 40: {
                        desc = desc + "Object";
                        break;
                    }
                    case 88: {
                        desc = desc + "valuebase";
                    }
                }
                break;
            }
            case 26: {
                desc = desc + "fixed";
                break;
            }
            case 5: {
                desc = desc + "string";
                break;
            }
            case 6: {
                desc = desc + "wstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 14: 
            case 15: 
            case 18: 
            case 25: 
            case 28: 
            case 33: {
                desc = desc + "<A HREF=\"" + this.get_link(obj, current) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(obj) + "</A>";
                break;
            }
            case 13: {
                obj.reset();
                this.translateType(obj.current(), desc, name, write, current);
                break;
            }
            case 9: {
                desc = desc + "sequence&lt;";
                desc = this.translateType(obj.current(), desc, name, false, current);
                desc = desc + "&gt;";
                break;
            }
            case 24: {
                desc = this.translateType(obj.current(), desc, name + "[" + ((IdlArray)obj).getDimension() + "]", false, current);
                if (obj.current().kind() != 24) {
                    desc = desc + " " + name;
                    desc = desc + "[" + ((IdlArray)obj).getDimension() + "]";
                }
                return desc;
            }
            case 10: {
                if (((IdlIdent)obj).internalObject().name().equals("TypeCode")) {
                    desc = desc + "CORBA::TypeCode";
                    break;
                }
                desc = desc + "<A HREF=\"" + this.get_link(((IdlIdent)obj).internalObject(), current) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(((IdlIdent)obj).internalObject()) + "</A>";
                break;
            }
            case 27: {
                if (((IdlValueBox)obj).simple()) {
                    desc = desc + this.fullname_idl(obj);
                    break;
                }
                obj.reset();
                desc = this.translateType(obj.current(), desc, name, write, current);
            }
        }
        if (write) {
            desc = desc + " " + name;
        }
        return desc;
    }

    public String translateParameter(IdlObject obj, String desc) {
        IdlParam p = (IdlParam)obj;
        p.reset();
        switch (p.param_attr()) {
            case 0: {
                desc = desc + "in ";
                break;
            }
            case 1: {
                desc = desc + "out ";
                break;
            }
            case 2: {
                desc = desc + "inout ";
            }
        }
        return this.translateType(p.current(), desc, p.name(), true, obj);
    }

    public void translateModule(IdlObject obj, File writeInto) {
        File new_path = this.createDirectory(obj.name(), writeInto);
        PrintWriter output = this.create_file(obj.name(), new_path);
        ++this.level;
        this.write_page_title(obj.name(), output);
        this.write_navigation_bar(output);
        this.write_title("Module " + obj.name(), output);
        this.translateHierarchy(obj, output);
        this.write_description(obj, output);
        output.println("<BR><BR>");
        this.translateDescription(obj, new_path);
        this.translateContentTable(obj, output, 3);
        this.write_alldescriptions_file(obj.name() + " : All descriptions", new_path, obj);
        output.println("</BODY>");
        output.println("</HTML>");
        output.close();
        --this.level;
    }

    public void translateEnum(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        IdlEnumMember member = null;
        obj.reset();
        int i = 1;
        desc = desc + "<UL>" + "enum " + obj.name() + "<BR>";
        desc = desc + "{<BR><UL>";
        while (!obj.end()) {
            member = (IdlEnumMember)obj.current();
            ++i;
            desc = desc + member.name();
            obj.next();
            if (!obj.end()) {
                desc = desc + ", ";
            }
            desc = desc + "<BR>";
        }
        desc = desc + "</UL>}<BR></UL>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateStruct(IdlObject obj, PrintWriter output) {
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        String desc = "";
        IdlStructMember member = null;
        desc = desc + "<UL>" + "struct " + obj.name() + "<BR>";
        desc = desc + "{<BR><UL>";
        obj.reset();
        while (!obj.end()) {
            member = (IdlStructMember)obj.current();
            member.reset();
            desc = this.translateType(member.current(), desc, member.name(), true, obj);
            obj.next();
            if (!obj.end()) {
                desc = desc + ", ";
            }
            desc = desc + "<BR>";
        }
        desc = desc + "</UL>}<BR></UL>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateUnion(IdlObject obj, PrintWriter output) {
        IdlUnionMember member = null;
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        String desc = "";
        obj.reset();
        member = (IdlUnionMember)obj.current();
        member.reset();
        desc = desc + "<UL>" + "union " + obj.name() + " switch ( ";
        desc = this.translateType(member.current(), desc, member.name(), false, obj);
        desc = desc + " )<BR>";
        desc = desc + "{<BR><UL>";
        obj.next();
        int default_index = ((IdlUnion)obj).index();
        int index = 0;
        while (!obj.end()) {
            member = (IdlUnionMember)obj.current();
            member.reset();
            desc = index == default_index ? desc + "default : <BR><UL>" : desc + "case " + this.adaptExpression(member.getExpression()) + ": <BR><UL>";
            desc = this.translateType(member.current(), desc, member.name(), true, obj);
            desc = desc + ";<BR></UL>";
            obj.next();
            ++index;
        }
        desc = desc + "</UL>}<BR></UL>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateException(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        IdlStructMember member = null;
        desc = desc + "<UL>" + "exception " + obj.name() + "<BR>";
        desc = desc + "{<BR><UL>";
        obj.reset();
        while (!obj.end()) {
            member = (IdlStructMember)obj.current();
            member.reset();
            desc = this.translateType(member.current(), desc, member.name(), true, obj);
            obj.next();
            if (!obj.end()) {
                desc = desc + ", ";
            }
            desc = desc + "<BR>";
        }
        desc = desc + "</UL>}<BR></UL>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateTypedef(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        desc = desc + "<UL>" + "typedef ";
        obj.reset();
        desc = this.translateType(obj.current(), desc, obj.name(), true, obj);
        desc = desc + ";</UL><BR>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateValueBox(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        desc = desc + "<UL>" + "valuetype " + obj.name() + " ";
        desc = this.translateType(obj.current(), desc, obj.name(), false, obj);
        desc = desc + ";</UL><BR>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateFactory(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        desc = desc + "<UL>" + "factory " + obj.name() + "(";
        obj.reset();
        while (!obj.end()) {
            desc = desc + "in ";
            obj.current().reset();
            desc = this.translateType(obj.current().current(), desc, obj.current().name(), true, obj);
            obj.next();
            if (obj.end()) continue;
            desc = desc + ", ";
        }
        desc = desc + ");</UL><BR>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateStateMember(IdlObject obj, PrintWriter output) {
        IdlStateMember member = null;
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        member = (IdlStateMember)obj;
        member.reset();
        if (member.public_member()) {
            output.print("public ");
        } else {
            output.print("private ");
        }
        output.println(this.translateType(member.current(), "", member.name(), true, obj));
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(member, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateAttribute(IdlObject obj, PrintWriter output) {
        IdlAttribute attr = (IdlAttribute)obj;
        attr.reset();
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        if (attr.readOnly()) {
            output.print("readonly ");
        }
        output.print("attribute ");
        output.println(this.translateType(attr.current(), "", attr.name(), true, obj) + "</PRE>");
        output.println("<DL>");
        output.println("<DD>");
        this.write_description(attr, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateOperation(IdlObject obj, PrintWriter output) {
        IdlOp op = (IdlOp)obj;
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        String desc = "";
        desc = desc + "<UL>";
        if (op.oneway()) {
            desc = desc + "oneway ";
        }
        op.reset();
        desc = this.translateType(op.current(), desc, op.name(), false, obj);
        op.next();
        desc = desc + " " + op.name() + "(";
        while (!op.end()) {
            if (op.current().kind() != 19) break;
            desc = this.translateParameter(op.current(), desc);
            op.next();
            if (op.end() || op.current().kind() != 19) continue;
            desc = desc + ", ";
        }
        desc = desc + ")";
        if (!op.end() && op.current().kind() == 20) {
            desc = desc + "<BR><UL> raises (<BR><UL>";
            IdlRaises raises = (IdlRaises)op.current();
            raises.reset();
            while (!raises.end()) {
                desc = desc + "<A HREF=\"" + this.get_link(raises.current(), obj) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(raises.current()) + "</A>";
                raises.next();
                if (raises.end()) continue;
                desc = desc + ", <BR>";
            }
            desc = desc + ")</UL></UL>";
            op.next();
        }
        if (!op.end() && op.current().kind() == 21) {
            desc = desc + "<BR><UL>";
            desc = desc + " context (";
            IdlContext ctx = (IdlContext)op.current();
            Vector list = ctx.getValues();
            int index = 0;
            while (index < list.size()) {
                desc = desc + "\"" + (String)list.elementAt(index) + "\"";
                if (index + 1 < list.size()) {
                    desc = desc + ", ";
                }
                ++index;
            }
            desc = desc + ")<BR></UL>";
        }
        output.println(desc);
        output.println("</PRE></UL><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateValueType(IdlObject obj, File writeInto) {
        File new_path = this.createDirectory(obj.name(), writeInto);
        PrintWriter output = this.create_file(obj.name(), new_path);
        ++this.level;
        this.write_alldescriptions_file(obj.name() + " : All descriptions", new_path, obj);
        IdlValue value = (IdlValue)obj;
        String desc = "";
        this.write_page_title(obj.name(), output);
        this.write_navigation_bar(output);
        this.write_title("ValueType " + obj.name(), output);
        this.translateHierarchy(obj, output);
        this.write_description(obj, output);
        desc = desc + "<UL>";
        if (value.abstract_value()) {
            desc = desc + "abstract ";
        }
        if (value.custom_value()) {
            desc = desc + "custom ";
        }
        desc = desc + "valuetype " + obj.name();
        Vector inheritance = value.getInheritanceList();
        if (inheritance.size() != 0) {
            desc = desc + " : ";
            int i = 0;
            while (i < inheritance.size()) {
                if (((IdlValueInheritance)inheritance.elementAt(i)).truncatable_member()) {
                    desc = desc + "truncatable ";
                }
                desc = desc + "<A HREF=\"" + this.get_link(((IdlValueInheritance)inheritance.elementAt(i)).getValue(), obj) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl(((IdlValueInheritance)inheritance.elementAt(i)).getValue()) + "</A>";
                if (i + 1 < inheritance.size()) {
                    desc = desc + ", ";
                }
                ++i;
            }
        }
        desc = desc + "<BR><BR></UL>";
        output.println(desc);
        this.translateContentTable(obj, output, 1);
        IdlValue inherit = null;
        if (inheritance.size() != 0) {
            int i = 0;
            while (i < inheritance.size()) {
                inherit = ((IdlValueInheritance)inheritance.elementAt(i)).getValue();
                if (!inherit.included()) {
                    output.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
                    output.println("<TR BGCOLOR=\"#EEEEFF\" ID=\"TableSubHeadingColor\">");
                    output.println("<TD><B>Members, attributes and operations inherited from <A HREF=\"" + this.get_link(inherit, obj) + "\">" + this.fullname_idl(inherit) + "</A></B></TD>");
                    output.println("</TR>");
                    output.println("<TR BGCOLOR=\"white\" ID=\"TableRowColor\">");
                    output.println("<TD><CODE>\n");
                    inherit.reset();
                    while (!inherit.end()) {
                        switch (inherit.current().kind()) {
                            case 16: 
                            case 17: 
                            case 29: {
                                output.println("<A HREF=\"" + this.get_link(inherit.current(), obj) + "\">" + inherit.current().name() + "</A>");
                            }
                        }
                        inherit.next();
                    }
                    output.println("</CODE></TD></TR>\n");
                    output.println("</TABLE><BR>\n");
                }
                ++i;
            }
        }
        this.translateContentTable(obj, output, 2);
        --this.level;
        output.println("</BODY>");
        output.println("</HTML>");
        output.close();
    }

    public void translateInterface(IdlObject obj, File writeInto) {
        IdlInterface itf = (IdlInterface)obj;
        File new_path = this.createDirectory(obj.name(), writeInto);
        PrintWriter output = this.create_file(obj.name(), new_path);
        ++this.level;
        this.write_alldescriptions_file(obj.name() + " : All descriptions", new_path, obj);
        String desc = "";
        this.write_page_title(obj.name(), output);
        this.write_navigation_bar(output);
        this.write_title("interface " + obj.name(), output);
        this.translateHierarchy(obj, output);
        this.write_description(obj, output);
        desc = desc + "<UL>";
        if (itf.abstract_interface()) {
            desc = desc + "abstract ";
        }
        desc = desc + "interface " + obj.name();
        Vector inheritance = itf.getInheritance();
        if (inheritance.size() != 0) {
            desc = desc + " : ";
            int i = 0;
            while (i < inheritance.size()) {
                desc = desc + "<A HREF=\"" + this.get_link((IdlInterface)inheritance.elementAt(i), obj) + "\" TARGET=\"descriptionFrame\">" + this.fullname_idl((IdlInterface)inheritance.elementAt(i)) + "</A>";
                if (i + 1 < inheritance.size()) {
                    desc = desc + ", ";
                }
                ++i;
            }
        }
        desc = desc + "<BR><BR></UL>";
        output.println(desc);
        this.translateContentTable(obj, output, 1);
        IdlInterface inherit = null;
        if (inheritance.size() != 0) {
            int i = 0;
            while (i < inheritance.size()) {
                inherit = (IdlInterface)inheritance.elementAt(i);
                if (!inherit.included()) {
                    output.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
                    output.println("<TR BGCOLOR=\"#EEEEFF\" ID=\"TableSubHeadingColor\">");
                    output.println("<TD><B>Attributes and operations inherited from <A HREF=\"" + this.get_link(inherit, obj) + "\">" + this.fullname_idl(inherit) + "</A></B></TD>");
                    output.println("</TR>");
                    output.println("<TR BGCOLOR=\"white\" ID=\"TableRowColor\">");
                    output.println("<TD><CODE>\n");
                    inherit.reset();
                    while (!inherit.end()) {
                        switch (inherit.current().kind()) {
                            case 16: 
                            case 17: {
                                output.println("<A HREF=\"" + this.get_link(inherit.current(), obj) + "\">" + inherit.current().name() + "</A>");
                            }
                        }
                        inherit.next();
                    }
                    output.println("</CODE></TD></TR>\n");
                    output.println("</TABLE><BR>\n");
                }
                ++i;
            }
        }
        this.translateContentTable(obj, output, 2);
        --this.level;
        output.println("</BODY>");
        output.println("</HTML>");
        output.close();
    }

    public String correctIdentifier(String expr) {
        String correct_identifier = "";
        int index = 0;
        int last_index = 0;
        Vector<String> list = new Vector<String>();
        int i = 0;
        String item = null;
        while ((index = expr.indexOf(".", last_index)) != last_index) {
            if (index == -1) {
                item = expr.substring(last_index, expr.length());
                list.addElement(item);
                break;
            }
            item = expr.substring(last_index, index);
            list.addElement(item);
            last_index = index + 1;
        }
        i = 0;
        while (i < list.size()) {
            item = (String)list.elementAt(i);
            if (this._root.isDefined(item, false)) break;
            ++i;
        }
        int j = i;
        while (j < list.size()) {
            correct_identifier = correct_identifier + (String)list.elementAt(j);
            if (j + 1 < list.size()) {
                correct_identifier = correct_identifier + "::";
            }
            ++j;
        }
        return correct_identifier;
    }

    /*
     * Unable to fully structure code
     */
    public String adaptExpression(String expr) {
        tmp = new char[500];
        adapt_expr = "";
        index = 0;
        tmp_index = 0;
        while (index != expr.length()) {
            block7: {
                block8: {
                    if (!Character.isDigit(expr.charAt(index))) break block7;
                    if (expr.charAt(index) != '0' || index + 1 >= expr.length() || expr.charAt(index + 1) != 'X' && expr.charAt(index + 1) != 'x') ** GOTO lbl15
                    tmp[tmp_index++] = expr.charAt(index++);
                    tmp[tmp_index++] = expr.charAt(index++);
                    while (index < expr.length() && (Character.isDigit(expr.charAt(index)) || expr.charAt(index) >= 'A' && expr.charAt(index) <= 'F' || expr.charAt(index) >= 'a' && expr.charAt(index) <= 'f')) {
                        tmp[tmp_index++] = expr.charAt(index++);
                    }
                    break block8;
lbl-1000:
                    // 1 sources

                    {
                        tmp[tmp_index++] = expr.charAt(index++);
lbl15:
                        // 2 sources

                        ** while (index < expr.length() && (Character.isDigit((char)expr.charAt((int)index)) || expr.charAt((int)index) == '.'))
                    }
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + new String(tmp, 0, tmp_index);
                tmp_index = 0;
                continue;
            }
            if (Character.isLetter(expr.charAt(index))) {
                while (index < expr.length() && (Character.isLetterOrDigit(expr.charAt(index)) || expr.charAt(index) == '.' || expr.charAt(index) == '_')) {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + this.correctIdentifier(new String(tmp, 0, tmp_index));
                tmp_index = 0;
                continue;
            }
            if (expr.charAt(index) == '\"') {
                ++index;
                while (expr.charAt(index) != '\"') {
                    tmp[tmp_index++] = expr.charAt(index++);
                }
                tmp[tmp_index] = '\u0000';
                adapt_expr = adapt_expr + "\"" + new String(tmp, 0, tmp_index) + "\"";
                tmp_index = 0;
                ++index;
                continue;
            }
            tmp[0] = expr.charAt(index++);
            tmp[1] = '\u0000';
            adapt_expr = adapt_expr + new String(tmp, 0, 1);
        }
        return adapt_expr;
    }

    public void translateConstant(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        desc = desc + "<UL>" + "const ";
        desc = this.translateType(obj.current(), desc, obj.name(), true, obj);
        desc = desc + " = " + this.adaptExpression(((IdlConst)obj).expression());
        desc = desc + ";</UL><BR>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateNative(IdlObject obj, PrintWriter output) {
        String desc = "";
        output.println("<A NAME=\"" + obj.name() + "\"><!-- --></A><H3>");
        output.println(obj.name() + "</H3>");
        output.println("<PRE>");
        desc = desc + "<UL>" + "native " + obj.name() + ";<BR></UL>";
        output.println(desc);
        output.println("</PRE><DL>");
        output.println("<DD>");
        this.write_description(obj, output);
        output.println("</DD>");
        output.println("</DL>");
        output.println("<HR>");
    }

    public void translateInternalDescription(IdlObject obj, File writeInto, PrintWriter output) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 7: {
                        this.translateConstant(obj.current(), output);
                        break;
                    }
                    case 2: {
                        this.translateEnum(obj.current(), output);
                        break;
                    }
                    case 3: {
                        this.translateStruct(obj.current(), output);
                        break;
                    }
                    case 4: {
                        this.translateUnion(obj.current(), output);
                        break;
                    }
                    case 13: {
                        this.translateTypedef(obj.current(), output);
                        break;
                    }
                    case 14: {
                        this.translateException(obj.current(), output);
                        break;
                    }
                    case 25: {
                        this.translateNative(obj.current(), output);
                    }
                }
            }
            obj.next();
        }
    }

    public void translateDescription(IdlObject obj, File output) {
        obj.reset();
        while (!obj.end()) {
            if (!obj.current().included()) {
                switch (obj.current().kind()) {
                    case 1: {
                        this.translateModule(obj.current(), output);
                        break;
                    }
                    case 28: {
                        this.translateValueType(obj.current(), output);
                        break;
                    }
                    case 15: {
                        this.translateInterface(obj.current(), output);
                    }
                }
            }
            obj.next();
        }
    }

    public void translateToHTML(IdlObject root, String title, String packageName) {
        this._root = root;
        File first = null;
        if (IdlDoc.outdir != null) {
            first = new File(IdlDoc.outdir);
        }
        File writeInto = this.createDirectory(packageName, first);
        this.write_index_file(title, writeInto);
        this.write_index(writeInto);
        this.write_overview_file(root, title, writeInto);
        this.write_alldescriptions_file_index(title, writeInto, root);
        this.write_summary_file(title, writeInto);
        this.write_tree(writeInto);
        this.write_deprecated(writeInto);
        this.translateDescription(root, writeInto);
        if (IdlDoc.stylesheet) {
            this.write_style_sheet(writeInto);
        }
    }
}

