package org.omg.CORBA;

/**
 * This exception indicates that the caller has invoked operations
 * in the wrong order. For example, it can be raised by an ORB if an
 * application makes an ORB-related call without having correctly
 * initialized the ORB first.
 */

public class BAD_INV_ORDER extends org.omg.CORBA.SystemException
{
    //
    // Default constructor
    //
    public BAD_INV_ORDER()
    {
        super( null, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with reason string
    //
    public BAD_INV_ORDER( String orb_reason )
    {
        super( orb_reason, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public BAD_INV_ORDER( int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( null, minor, completed );
    }

    //
    // Full constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public BAD_INV_ORDER( String orb_reason, int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( orb_reason, minor, completed );
    }
}
