/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/

package org.openorb.compiler.doc;

import org.openorb.compiler.object.*;
import org.openorb.compiler.parser.*;
import org.openorb.compiler.doc.html.*;
import org.openorb.compiler.doc.rtf.*;
import java.util.*;
import java.net.URL;
import java.net.MalformedURLException;

/**
 * This class is the IDL parser for generating documentations
 */
public class IdlDoc
{
    /**
     * IDL file name 
     */
    public static String [] idl_file_name;

    /**
     * IDL files list
     */
    public static java.util.Vector idl_file_name_list;

    /**
     * ORB release version
    public static final String Release = "org.openorb version 1.0";
     */

    /**
     * Generated package name
     */
    public static String packageName = null;

    /**
     * Indicates if the package name is used
     */
    public static boolean use_package = true;

    /**
     * Indicates the output directory
     */
    public static String outdir = null;

    /**
     * Stylesheet to use 
     */
    public static boolean stylesheet = false;

    /**
     * Is the target HTML file
     */
    public static boolean htmlDoc = false;

    /**
     * Documentation title
     */
    public static String title = "IDL Documentation";
    /**
     * Documentation header
     */
    public static String header = "";

    /**
     * Documentation footer 
     */
    public static String footer = "";

    /**
     * Doc file name
     */
    public static String filename = "";

    /**
     * Doc codepage for html files.
     */
    public static String codepage = "ISO-8859-1";

    /**
     * Indicated of the prefixes are used
     */
    public static boolean usePrefix = true;

    /**
     * Print help
     */
    public static void printUsage()
    {
        System.out.println( "" );
        System.out.println( "" );
        System.out.println( "#################################################" );
        System.out.println( "#                    OpenORB                    #" );
        System.out.println( "#                -----------------              #" );
        System.out.println( "#         (c) 2002 The Community OpenORB        #" );
        System.out.println( "#################################################" );
        System.out.println( "# Java Doc Compiler, Release 1.0                #" );
        System.out.println( "#################################################" );
        System.out.println( "" );
        System.out.println( "" );
        System.out.println( "Options" );
        System.out.println( "-------" );
        System.out.println( "\t-release" );
        System.out.println( "\t\tShow version number" );
        System.out.println( "\t-html" );
        System.out.println( "\t\tCreate HTML output" );
        System.out.println( "\t-outdir:" );
        System.out.println( "\t\tProvide a way to specify the ouput dir. This option" );
        System.out.println( "\t\twill not use the corba_pkg directory." );
        System.out.println( "\t\tFor example :" );
        System.out.println( "\t\t idl2doc demo.idl -outdir:/home/me/" );
        System.out.println( "\t-nopackage" );
        System.out.println( "\t\tDon't use a package name" );
        System.out.println( "\t-package: package_name" );
        System.out.println( "\t\tGenerate files in package_name" );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl demo.idl -package:exemple" );
        System.out.println( "\t-I" );
        System.out.println( "\t\tAllow specification of include directory" );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t  idl demo.idl -I/home/me/idl -I../autre" );
        System.out.println( "\t-D" );
        System.out.println( "\t\tDefine a symbole. It is equivalent to #define" );
        System.out.println( "\t-all" );
        System.out.println( "\t\tGenerate documentation for included files." );
        System.out.println( "\t-stylesheet ( for HTML documentation only )" );
        System.out.println( "\t\tGenerate a style sheet for HTML documentation." );
        System.out.println( "\t-title:" );
        System.out.println( "\t\tSet the documentation title." );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl2html demo.idl \"-title:My Doc Title\"" );
        System.out.println( "\t-codepage:" );
        System.out.println( "\t\tSet the codepage for the generated html files." );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl2html demo.idl -codepage:ISO-8859-5" );
        System.out.println( "\t-noprefix" );
        System.out.println( "\t\t Disable usage of prefix for package name." );
        System.out.println( "\t-header ( for RTF documentation only ) :" );
        System.out.println( "\t\tSet the documentation header." );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl2rtf demo.idl \"-header:My Doc header\"" );
        System.out.println( "\t-footer ( for RTF documentation only ) :" );
        System.out.println( "\t\tSet the documentation footer." );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl2rtf demo.idl \"-footer:My Doc footer\"" );
        System.out.println( "\t-docname:" );
        System.out.println( "\t\tSet the documentation file name for RTF documentation." );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl2rtf demo.idl -docname:mydoc.rtf" );
        System.out.println( "\t-codepage:" );
        System.out.println( "\t\tSet the codepage for the generated files." );
        System.out.println( "\t\tExample:" );
        System.out.println( "\t\t idl2rtf demo.idl -docname:mydoc.rtf" );
        System.out.println( "" );
        System.out.println( "" );
        System.exit( 0 );
    }

    /**
    * Scan commang line args
    *
    * @param args  args list
    */
    public static void analyse_arguments( String[] args )
    {
        org.openorb.compiler.IdlCompiler.includeList = new Vector();
        org.openorb.compiler.IdlCompiler.definedMacros = new Hashtable();

        for ( int i = 0; i < args.length; i++ )
        {
            if ( args[ i ].charAt( 0 ) != '-' )
                idl_file_name_list.addElement( args[ i ] );
            else
                if ( args[ i ].equals( "-release" ) )
                {
                    System.out.println( org.openorb.ReleaseInfo.VERSION );
                    System.exit( 0 );
                }
                else
                    if ( args[ i ].equals( "-h" ) )
                        printUsage();
                    else
                        if ( args[ i ].equals( "-html" ) )
                            htmlDoc = true;
                        else
                            if ( args[ i ].equals( "-help" ) )
                                printUsage();
                            else
                                if ( args[ i ].equals( "-nopackage" ) )
                                    use_package = false;
                                else
                                    if ( args[ i ].equals( "-noprefix" ) )
                                        usePrefix = false;
                                    else
                                        if ( args[ i ].equals( "-stylesheet" ) )
                                            stylesheet = true;
                                        else
                                            if ( args[ i ].equals( "-all" ) )
                                                org.openorb.compiler.IdlCompiler.map_all = true;
                                            else
                                                if ( args[ i ].startsWith( "-package:" ) )
                                                {
                                                    try
                                                    {
                                                        packageName = args[ i ].substring( 9, args[ i ].length() );
                                                    }
                                                    catch ( StringIndexOutOfBoundsException ex )
                                                    { }

                                                    if ( packageName.equals( "" ) )
                                                    {
                                                        System.out.println( "Package name cannot be empty..." );
                                                        System.exit( 0 );
                                                    }
                                                }
                                                else
                                                    if ( args[ i ].startsWith( "-title:" ) )
                                                    {
                                                        try
                                                        {
                                                            title = args[ i ].substring( 7, args[ i ].length() );
                                                        }
                                                        catch ( StringIndexOutOfBoundsException ex )
                                                        { }

                                                    }
                                                    else
                                                        if ( args[ i ].startsWith( "-header:" ) )
                                                        {
                                                            try
                                                            {
                                                                header = args[ i ].substring( 7, args[ i ].length() );
                                                            }
                                                            catch ( StringIndexOutOfBoundsException ex )
                                                            { }

                                                        }
                                                        else
                                                            if ( args[ i ].startsWith( "-footer:" ) )
                                                            {
                                                                try
                                                                {
                                                                    footer = args[ i ].substring( 7, args[ i ].length() );
                                                                }
                                                                catch ( StringIndexOutOfBoundsException ex )
                                                                { }

                                                            }
                                                            else
                                                                if ( args[ i ].startsWith( "-docname:" ) )
                                                                {
                                                                    try
                                                                    {
                                                                        filename = args[ i ].substring( 9, args[ i ].length() );
                                                                    }
                                                                    catch ( StringIndexOutOfBoundsException ex )
                                                                    { }

                                                                }
                                                                else
                                                                    if ( args[ i ].startsWith( "-outdir:" ) )
                                                                    {
                                                                        try
                                                                        {
                                                                            outdir = args[ i ].substring( 8, args[ i ].length() );
                                                                        }
                                                                        catch ( StringIndexOutOfBoundsException ex )
                                                                        { }

                                                                        if ( packageName == null )
                                                                        {
                                                                            packageName = "";
                                                                            use_package = false;
                                                                        }

                                                                    }
                                                                    else
                                                                        if ( args[ i ].startsWith( "-codepage:" ) )
                                                                        {
                                                                            try
                                                                            {
                                                                                codepage = args[ i ].substring( 10, args[ i ].length() );
                                                                            }
                                                                            catch ( StringIndexOutOfBoundsException ex )
                                                                            { }
                                                                        }
                                                                        else
                                                                            if ( args[ i ].startsWith( "-I" ) )
                                                                            {
                                                                                try
                                                                                {
                                                                                    String name = args[ i ].substring( 2, args[ i ].length() );
                                                                                    URL url = null;
    
                                                                                    try
                                                                                    {
                                                                                        url = new URL( name );
                                                                                    }
                                                                                    catch ( MalformedURLException ex )
                                                                                    {
                                                                                        try
                                                                                        {
                                                                                            url = new java.io.File( name ).toURL();
                                                                                        }
                                                                                        catch ( MalformedURLException ex1 )
                                                                                        {}
    
                                                                                    }
    
                                                                                    if ( url != null )
                                                                                        org.openorb.compiler.IdlCompiler.includeList.addElement( url );
                                                                                }
                                                                                catch ( StringIndexOutOfBoundsException ex )
                                                                                { }
    
                                                                            }
                                                                            else
                                                                                if ( args[ i ].startsWith( "-D" ) )
                                                                                {
                                                                                    try
                                                                                    {
                                                                                        int idx = args[ i ].indexOf( '=' );
    
                                                                                        if ( idx < 0 )
                                                                                            org.openorb.compiler.IdlCompiler.definedMacros.put( args[ i ].substring( 2, args[ i ].length() ) , "" );
                                                                                        else
                                                                                            org.openorb.compiler.IdlCompiler.definedMacros.put( args[ i ].substring( 2, idx ) , args[ i ].substring( idx + 1 ) );
                                                                                    }
                                                                                    catch ( StringIndexOutOfBoundsException ex )
                                                                                    { }
    
                                                                                }
                                                                                else
                                                                                {
                                                                                    System.out.println( "Bad parameter" );
                                                                                    System.out.println( "Please, use no flag to display all compiler option flags" );
                                                                                    System.exit( 0 );
                                                                                }
        }

        if ( packageName == null )
            packageName = new String( "corba_pkg" );

        org.openorb.compiler.IdlCompiler.packageName = packageName;

        idl_file_name = new String[ idl_file_name_list.size() ];

        for ( int i = 0; i < idl_file_name_list.size(); i++ )
            idl_file_name[ i ] = ( String ) idl_file_name_list.elementAt( i );
    }

    // ===========================
    // Entry point
    // ===========================
    /**
    * The compiler starts here
    *
    * @param args  commmand line args 
    */
    public static void main( String[] args )
    {

        IdlObject CompilationGraph;
        IdlParser Parser = null;

        SymboleDef s;

        idl_file_name_list = new java.util.Vector();

        // ----------------------------------------------
        // Scan the args
        // ----------------------------------------------

        if ( args.length != 0 )
            analyse_arguments( args );
        else
            printUsage();

        org.openorb.compiler.IdlCompiler.idl_file_name = idl_file_name;

        if ( idl_file_name.length == 0 )
            printUsage();



        Parser = new IdlParser();

        System.out.println( "OpenORB Doc generator" );

        // --------------------
        // Compile
        // --------------------

        CompilationGraph = null;

        for ( int i = 0; i < idl_file_name.length; i++ )
            CompilationGraph = Parser.compile_idl( idl_file_name[ i ] );

        if ( Parser.totalError != 0 )
        {
            System.out.println( "there are errors..." );
            System.out.println( "compilation process stopped !" );
            System.exit( 0 );
        }

        // -----------------------------
        // HTML generation
        // -----------------------------
        if ( htmlDoc )
        {
            System.out.println( "IDL To HTML" );
            IdlToHTML toHTML = new IdlToHTML();
            toHTML.translateToHTML( CompilationGraph, title, packageName );
        }
        else
        {
            System.out.println( "IDL To RTF" );
            IdlToRTF toRTF = new IdlToRTF();

            if ( filename == null )
            {
                System.out.println( "IDL to RTF fatal error : you must specify an file name for the RTF documentation with '-docname:' flag." );
                System.exit( 0 );
            }

            toRTF.translateToRTF( CompilationGraph, filename, title, header, footer );
        }
    }

}
