/*
* Copyright (C) The Community OpenORB Project. All rights reserved.
*
* This software is published under the terms of The OpenORB Community Software
* License version 1.0, a copy of which has been included with this distribution
* in the LICENSE.txt file.
*/
package org.openorb.util;

/**
 * Identity hash table key. Use to wrap objects to insert into hash maps
 * where the entry should be hashed/looked up on the actual object, rather
 * than any equals / hashCode operations it defines.
 * 
 * @author Chris Wood
 * @version $Revision: 1.4 $ $Date: 2002/06/28 08:59:06 $ 
 */
public class IdentityKey
{
    /** The target member. */
    private Object m_target;

    /**
     * Constructor.
     *
     * @param target The object with which to initialize the internal member.
     */
    public IdentityKey( Object target )
    {
        m_target = target;
    }

    /**
     * Returns the internal target member.
     *
     * @return The target member.
     */
    public Object getTarget()
    {
        return m_target;
    }

    /**
     * Return the hash code of the member.
     *
     * @return The system identity hash code of the internal member.
     */
    public int hashCode()
    {
        return System.identityHashCode( m_target );
    }

    /**
     * Checks whether two IdentityKey instances are equal.
     *
     * @param obj The instance to compare this instance to.
     * @return True if the instances are equal, false oterhwise.
     */
    public boolean equals( Object obj )
    {
        if ( !( obj instanceof IdentityKey ) )
            return false;

        return m_target == ( ( IdentityKey ) obj ).m_target;
    }
}
