/*
 * TreeExplorerExample.java
 *
 * Created on December 10, 2002, 2:54 PM
 */

package gpcourse;

import cern.gp.explorer.TreeExplorer;
import cern.gp.explorer.TreeTableExplorer;
import cern.gp.explorer.test.helpers.SimpleDemoBean;
import cern.gp.nodes.GPNode;
import cern.gp.nodes.NodeFactory;
import cern.gp.windows.WindowUtils;
import gp.example.nodes.children.SimpleChildrenListManager;
import java.beans.IntrospectionException;

/**
 *
 * @author  ksigerud
 */
public class TreeExplorerExample {
  
  /** Creates a new instance of TreeExplorerExample */
  public TreeExplorerExample() {
  }
  
  /**
   * @param args the command line arguments
   */
  public static void main(String[] args) {
    try {
      TreeTableExplorer myExplorer = new TreeTableExplorer();
      GPNode myRootNode = NodeFactory.createNode(new ExampleBean(), new ExampleChildrenListManager());
      myExplorer.setRootNode(myRootNode);
      myExplorer.setTableColumns(ExampleBean.class, new String[] { "name", "value", "niceExercise", "startTime" });
      WindowUtils.openInMode(myExplorer, "My TreeExplorerExample");
    } catch (IntrospectionException ie) {
      ie.printStackTrace();
    }
  }
  
}
