/*
 * ValueComparator.java
 *
 * Created on November 26, 2002, 12:22 PM
 */

package gpcourse;

import cern.gp.explorer.test.helpers.SimpleDemoBean;
import cern.gp.nodes.GPNode;
import java.util.Comparator;

/**
 * A comparator for ExampleBean, that numerically orders them by the index in the
 * name of the bean
 */
public class ValueComparator implements Comparator {
  
  public int compare(Object one, Object two) {
    if (!(((GPNode) one).getBean() instanceof ExampleBean) || !(((GPNode) one).getBean() instanceof ExampleBean)) {
      return 0;
    }
    
    // both one and two are ExampleBean, convert them for readability of code
    ExampleBean beanOne = (ExampleBean) ((GPNode) one).getBean();
    ExampleBean beanTwo = (ExampleBean) ((GPNode) two).getBean();
    
    // isolate the index at the end of the String returned by getName() and convert it to an int:
    String indexOneString = beanOne.getName().substring(ExampleChildrenListManager.BEAN_NAME_PREFIX.length());
    String indexTwoString = beanTwo.getName().substring(ExampleChildrenListManager.BEAN_NAME_PREFIX.length());
    int indexOne = Integer.parseInt(indexOneString);
    int indexTwo = Integer.parseInt(indexTwoString);
    
    if (indexOne > indexTwo) {
      return 1;
    } else if (indexOne < indexTwo) {
      return -1;
    } else {
      return 0;
    }
  }
}
