/* Generated By:JavaCC: Do not edit this line. DTDParser.java */
package org.exolab.castor.xml.dtd.parser;

import org.exolab.castor.xml.dtd.*;

import java.io.*;

/**
 * Main XML DTD parser. Parses DTD documents with <b>parameter entity
 * references</b> already substituted by corresponding <b>replacement text</b>.
 * Constructs DTD document object.
 * @author <a href="mailto:totok@intalio.com">Alexander Totok</a>
 * @version $Revision: 1.2 $ $Date: 2004/10/01 13:25:16 $
 */
public class DTDParser implements DTDParserConstants {

/**
 * Main parsing method that starts parsing process.
 * @return corresponding DTD document object.
 */
  final public DTDdocument Input() throws ParseException, DTDException {
   DTDdocument document = new DTDdocument();
    if (jj_2_1(3)) {
      jj_consume_token(S);
    } else {
      ;
    }
    label_1:
    while (true) {
      if (jj_2_2(3)) {
        ;
      } else {
        break label_1;
      }
      if (jj_2_8(3)) {
        ElementDecl(document);
        if (jj_2_3(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
      } else if (jj_2_9(3)) {
        AttlistDecl(document);
        if (jj_2_4(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
      } else if (jj_2_10(3)) {
        GEntityDecl(document);
        if (jj_2_5(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
      } else if (jj_2_11(3)) {
        NotationDecl(document);
        if (jj_2_6(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
      } else if (jj_2_12(3)) {
        Comment();
        if (jj_2_7(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(0);
     {if (true) return document;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parsing procedure corresponding to the <b>Element Declaration</b> nonterminal.
 * @param document DTD document to add this <b>Element Declaration</b> to.
 */
  final public void ElementDecl(DTDdocument document) throws ParseException, DTDException {
   Token token;
   Element element = new Element(document);
   ContentParticle cp;
    jj_consume_token(BEGIN_ELEMENT_DECL);
    jj_consume_token(S);
    token = jj_consume_token(NAME);
                    element.setName(token.image);
    jj_consume_token(S);
    if (jj_2_16(3)) {
      jj_consume_token(ANY);
              element.setAnyContent();
    } else if (jj_2_17(3)) {
      jj_consume_token(EMPTY);
                element.setEmptyContent();
    } else if (jj_2_18(3)) {
      if (jj_2_14(3)) {
        Mixed(element);
      } else if (jj_2_15(3)) {
        cp = SeqOrChoiceContPart();
        if (jj_2_13(3)) {
          OccuranceSpecification(cp);
        } else {
          ;
        }
           element.setElemOnlyContent(cp);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_19(3)) {
      jj_consume_token(S);
    } else {
      ;
    }
    jj_consume_token(END_ELEMENT_DECL);
     document.addElement(element);
  }

/**
 * Parsing procedure corresponding to the <b>Mixed Element Content</b>
 * nonterminal.
 * @param element <b>Element</b> which content is being defined.
 */
  final public void Mixed(Element element) throws ParseException, DTDException {
   Token token;
    jj_consume_token(LEFT_PAREN);
    if (jj_2_20(3)) {
      jj_consume_token(S);
    } else {
      ;
    }
    jj_consume_token(PCDATA);
    if (jj_2_21(3)) {
      jj_consume_token(S);
    } else {
      ;
    }
                                          element.setMixedContent();
    if (jj_2_25(3)) {
      label_2:
      while (true) {
        jj_consume_token(OR);
        if (jj_2_22(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
        token = jj_consume_token(NAME);
        if (jj_2_23(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
           element.addMixedContentChild(token.image);
        if (jj_2_24(3)) {
          ;
        } else {
          break label_2;
        }
      }
      jj_consume_token(RIGHT_PAREN);
      jj_consume_token(STAR);
    } else if (jj_2_26(3)) {
      jj_consume_token(RIGHT_PAREN);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Parsing procedure corresponding to the <b>Content Particle</b> nonterminal.
 * @return corresponding <b>Content Particle</b> object.
 */
  final public ContentParticle ContPart() throws ParseException {
   ContentParticle cp;
   Token token;
    if (jj_2_27(3)) {
      token = jj_consume_token(NAME);
                       cp = new ContentParticle(token.image);
    } else if (jj_2_28(3)) {
      cp = SeqOrChoiceContPart();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_29(3)) {
      OccuranceSpecification(cp);
    } else {
      ;
    }
     {if (true) return cp;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parsing procedure corresponding to the <b>Content Particle</b> nonterminal
 * of the partial form: choice list of content particles, or sequence list
 * of content particles.
 * @return corresponding <b>Content Particle</b> object.
 */
  final public ContentParticle SeqOrChoiceContPart() throws ParseException {
   ContentParticle cp = new ContentParticle();
   ContentParticle auxilCP;
    jj_consume_token(LEFT_PAREN);
    if (jj_2_30(3)) {
      jj_consume_token(S);
    } else {
      ;
    }
    auxilCP = ContPart();
    if (jj_2_31(3)) {
      jj_consume_token(S);
    } else {
      ;
    }
    if (jj_2_38(3)) {
      label_3:
      while (true) {
        jj_consume_token(OR);
                cp.addChild(auxilCP);
        if (jj_2_32(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
        auxilCP = ContPart();
        if (jj_2_33(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
        if (jj_2_34(3)) {
          ;
        } else {
          break label_3;
        }
      }
        cp.addChild(auxilCP); cp.setChoiceType();
      jj_consume_token(RIGHT_PAREN);
    } else if (jj_2_39(3)) {
      label_4:
      while (true) {
        jj_consume_token(AND);
                 cp.addChild(auxilCP);
        if (jj_2_35(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
        auxilCP = ContPart();
        if (jj_2_36(3)) {
          jj_consume_token(S);
        } else {
          ;
        }
        if (jj_2_37(3)) {
          ;
        } else {
          break label_4;
        }
      }
        cp.addChild(auxilCP); cp.setSeqType();
      jj_consume_token(RIGHT_PAREN);
    } else if (jj_2_40(3)) {
      jj_consume_token(RIGHT_PAREN);
                      cp = auxilCP;
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return cp;}
    throw new Error("Missing return statement in function");
  }

/**
 * Method to parse occurance specification of a <b>Content Particle</b>,
 * that is "?", "*" or "+".
 * @param cp <b>Content Particle</b> being processed.
 */
  final public void OccuranceSpecification(ContentParticle cp) throws ParseException {
    if (jj_2_41(3)) {
      jj_consume_token(STAR);
               cp.setZeroOrMoreOccurances();
    } else if (jj_2_42(3)) {
      jj_consume_token(PLUS);
         if (cp.isOneOccurance() || cp.isOneOrMoreOccurances())
         cp.setOneOrMoreOccurances();
         else cp.setZeroOrMoreOccurances();
    } else if (jj_2_43(3)) {
      jj_consume_token(QUESTION);
         if (cp.isOneOccurance() || cp.isZeroOrOneOccurance())
         cp.setZeroOrOneOccurance();
         else cp.setZeroOrMoreOccurances();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Parsing procedure corresponding to the <b>Attribute Declaration</b> nonterminal.
 * @param document DTD document to add this <b>Attribute Declaration</b> to.
 */
  final public void AttlistDecl(DTDdocument document) throws ParseException, DTDException {
   Token token;
   Element element;
   Attribute attribute;
   String str;
    jj_consume_token(BEGIN_ATTR_DECL);
    jj_consume_token(S_ATTR);
    token = jj_consume_token(NAME_ATTR);
      element = document.getElement(token.image);
      if (element == null) {
         String err = "Main parser: element \"" + token.image + "\" has not been";
         err += " defined, while its attribute is being defined...";
         {if (true) throw new DTDException(err);}
      }
    label_5:
    while (true) {
      jj_consume_token(S_ATTR);
      token = jj_consume_token(NAME_ATTR);
      jj_consume_token(S_ATTR);
        attribute = new Attribute(element, token.image);
      if (jj_2_58(3)) {
        jj_consume_token(CDATA);
           attribute.setStringType();
      } else if (jj_2_59(3)) {
        jj_consume_token(ID);
           attribute.setIDType();
      } else if (jj_2_60(3)) {
        jj_consume_token(IDREF);
           attribute.setIDREFType();
      } else if (jj_2_61(3)) {
        jj_consume_token(IDREFS);
           attribute.setIDREFSType();
      } else if (jj_2_62(3)) {
        jj_consume_token(ENTITY);
           attribute.setENTITYType();
      } else if (jj_2_63(3)) {
        jj_consume_token(ENTITIES);
           attribute.setENTITIESType();
      } else if (jj_2_64(3)) {
        jj_consume_token(NMTOKEN);
           attribute.setNMTOKENType();
      } else if (jj_2_65(3)) {
        jj_consume_token(NMTOKENS);
           attribute.setNMTOKENSType();
      } else if (jj_2_66(3)) {
        jj_consume_token(NOTATION);
        jj_consume_token(S_ATTR);
           attribute.setNOTATIONType();
        jj_consume_token(LEFT_PAREN_ATTR);
        if (jj_2_44(3)) {
          jj_consume_token(S_ATTR);
        } else {
          ;
        }
        token = jj_consume_token(NAME_ATTR);
        if (jj_2_45(3)) {
          jj_consume_token(S_ATTR);
        } else {
          ;
        }
           attribute.addValue(token.image);
        label_6:
        while (true) {
          if (jj_2_46(3)) {
            ;
          } else {
            break label_6;
          }
          jj_consume_token(OR_ATTR);
          if (jj_2_47(3)) {
            jj_consume_token(S_ATTR);
          } else {
            ;
          }
          token = jj_consume_token(NAME_ATTR);
          if (jj_2_48(3)) {
            jj_consume_token(S_ATTR);
          } else {
            ;
          }
              attribute.addValue(token.image);
        }
        jj_consume_token(RIGHT_PAREN_ATTR);
      } else if (jj_2_67(3)) {
        jj_consume_token(LEFT_PAREN_ATTR);
        if (jj_2_49(3)) {
          jj_consume_token(S_ATTR);
        } else {
          ;
        }
        if (jj_2_50(3)) {
          token = jj_consume_token(NAME_ATTR);
        } else if (jj_2_51(3)) {
          token = jj_consume_token(NMTOKEN_ATTR);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        if (jj_2_52(3)) {
          jj_consume_token(S_ATTR);
        } else {
          ;
        }
           attribute.addValue(token.image);
        label_7:
        while (true) {
          if (jj_2_53(3)) {
            ;
          } else {
            break label_7;
          }
          jj_consume_token(OR_ATTR);
          if (jj_2_54(3)) {
            jj_consume_token(S_ATTR);
          } else {
            ;
          }
          if (jj_2_55(3)) {
            token = jj_consume_token(NAME_ATTR);
          } else if (jj_2_56(3)) {
            token = jj_consume_token(NMTOKEN_ATTR);
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          if (jj_2_57(3)) {
            jj_consume_token(S_ATTR);
          } else {
            ;
          }
              attribute.addValue(token.image);
        }
        jj_consume_token(RIGHT_PAREN_ATTR);
           attribute.setEnumerationType();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      jj_consume_token(S_ATTR);
      if (jj_2_68(3)) {
        jj_consume_token(REQUIRED);
           attribute.setREQUIRED();
      } else if (jj_2_69(3)) {
        jj_consume_token(IMPLIED);
           attribute.setIMPLIED();
      } else if (jj_2_70(3)) {
        jj_consume_token(FIXED);
        jj_consume_token(S_ATTR);
        str = AttrValue();
            attribute.setDefaultValue(str);
            attribute.setFIXED();
      } else if (jj_2_71(3)) {
        str = AttrValue();
           attribute.setDefaultValue(str);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
        element.addAttribute(attribute);
      if (jj_2_72(3)) {
        ;
      } else {
        break label_5;
      }
    }
    if (jj_2_73(3)) {
      jj_consume_token(S_ATTR);
    } else {
      ;
    }
    jj_consume_token(END_ATTR_DECL);
  }

/**
 * Parsing procedure corresponding to the <b>Attribute Value</b> nonterminal.
 * @return String containing parsed value.
 */
  final public String AttrValue() throws ParseException {
   Token token;
   String value = "";
    if (jj_2_76(3)) {
      jj_consume_token(START_DQ_ATTR);
      label_8:
      while (true) {
        if (jj_2_74(3)) {
          ;
        } else {
          break label_8;
        }
        token = jj_consume_token(ATTR_VALUE_CHAR_DQ);
           value += token.image;
      }
      jj_consume_token(END_DQ_ATTR);
    } else if (jj_2_77(3)) {
      jj_consume_token(START_SQ_ATTR);
      label_9:
      while (true) {
        if (jj_2_75(3)) {
          ;
        } else {
          break label_9;
        }
        token = jj_consume_token(ATTR_VALUE_CHAR_SQ);
           value += token.image;
      }
      jj_consume_token(END_SQ_ATTR);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parsing procedure corresponding to the <b>General Entity
 * Declaration</b> nonterminal.
 * @param document DTD document to add this <b>General Entity Declaration</b> to.
 */
  final public void GEntityDecl(DTDdocument document) throws ParseException {
   Token token;
   GeneralEntity ge;
   String str;
   String pubLit;
   String sysLit;
    jj_consume_token(BEGIN_GE_DECL);
    jj_consume_token(S_GE);
    token = jj_consume_token(NAME_GE);
    jj_consume_token(S_GE);
     ge = new GeneralEntity(document, token.image);
    if (jj_2_81(3)) {
      str = GEValue();
        ge.setValue(str);
    } else if (jj_2_82(3)) {
      if (jj_2_78(3)) {
        jj_consume_token(PUBLIC_GE);
        token = jj_consume_token(PUBLITER_GE);
            str = token.image;
            pubLit = str.substring(1,str.length()-1);
        jj_consume_token(S_GE_PUB);
        token = jj_consume_token(SYSLITER_GE);
            str = token.image;
            sysLit = str.substring(1,str.length()-1);
            ge.setExternalPublic(pubLit,sysLit);
      } else if (jj_2_79(3)) {
        jj_consume_token(SYSTEM_GE);
        token = jj_consume_token(SYSLITER_GE);
            str = token.image;
            sysLit = str.substring(1,str.length()-1);
            ge.setExternalSystem(sysLit);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
      if (jj_2_80(3)) {
        jj_consume_token(S_GE);
        jj_consume_token(NDATA);
        jj_consume_token(S_GE);
        token = jj_consume_token(NAME_GE);
          ge.setNDATA(token.image);
      } else {
        ;
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_83(3)) {
      jj_consume_token(S_GE);
    } else {
      ;
    }
    jj_consume_token(END_GE_DECL);
     document.addGeneralEntity(ge);
  }

/**
 * Parsing procedure corresponding to the <b>General Entity Value</b> nonterminal.
 * @return String containing parsed value.
 */
  final public String GEValue() throws ParseException {
   Token token;
   String value = "";
    if (jj_2_86(3)) {
      jj_consume_token(START_DQ_GE);
      label_10:
      while (true) {
        if (jj_2_84(3)) {
          ;
        } else {
          break label_10;
        }
        token = jj_consume_token(GE_VAlUE_CHAR_DQ);
           value += token.image;
      }
      jj_consume_token(END_DQ_GE);
    } else if (jj_2_87(3)) {
      jj_consume_token(START_SQ_GE);
      label_11:
      while (true) {
        if (jj_2_85(3)) {
          ;
        } else {
          break label_11;
        }
        token = jj_consume_token(GE_VAlUE_CHAR_SQ);
           value += token.image;
      }
      jj_consume_token(END_SQ_GE);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

/**
 * Parsing procedure corresponding to the <b>Notation Declaration</b> nonterminal.
 * @param document DTD document to add this <b>Notation Declaration</b> to.
 */
  final public void NotationDecl(DTDdocument document) throws ParseException, DTDException {
   Token token;
   Notation notation;
   String str;
   String pubLit;
   String sysLit = "";
    jj_consume_token(BEGIN_NOTATION_DECL);
    jj_consume_token(S_NOT);
    token = jj_consume_token(NAME_NOT);
    jj_consume_token(S_NOT);
     notation = new Notation(document, token.image);
    if (jj_2_90(3)) {
      jj_consume_token(PUBLIC_NOT);
      token = jj_consume_token(PUBLITER_NOT);
         str = token.image;
         pubLit = str.substring(1,str.length()-1);
      if (jj_2_88(3)) {
        jj_consume_token(S_NOT_SYS);
      } else {
        ;
      }
      if (jj_2_89(3)) {
        token = jj_consume_token(SYSLITER_NOT);
            str = token.image;
            sysLit = str.substring(1,str.length()-1);
      } else {
        ;
      }
        notation.setPublic(pubLit,sysLit);
    } else if (jj_2_91(3)) {
      jj_consume_token(SYSTEM_NOT);
      token = jj_consume_token(SYSLITER_NOT);
         str = token.image;
         sysLit = str.substring(1,str.length()-1);
         notation.setSystem(sysLit);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_92(3)) {
      jj_consume_token(S_NOT_SYS);
    } else {
      ;
    }
    jj_consume_token(END_NOTATION_DECL);
     document.addNotation(notation);
  }

/**
 * Parsing procedure corresponding to the <b>Comment</b> nonterminal.
 */
  final public void Comment() throws ParseException {
    jj_consume_token(BEGIN_COMMENT);
    label_12:
    while (true) {
      if (jj_2_93(3)) {
        ;
      } else {
        break label_12;
      }
      if (jj_2_94(3)) {
        jj_consume_token(COMMENT_CHAR);
      } else if (jj_2_95(3)) {
        jj_consume_token(DASH);
        jj_consume_token(COMMENT_CHAR);
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    jj_consume_token(END_COMMENT);
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_16();
    jj_save(15, xla);
    return retval;
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_17();
    jj_save(16, xla);
    return retval;
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_18();
    jj_save(17, xla);
    return retval;
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_19();
    jj_save(18, xla);
    return retval;
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_20();
    jj_save(19, xla);
    return retval;
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_21();
    jj_save(20, xla);
    return retval;
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_22();
    jj_save(21, xla);
    return retval;
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_23();
    jj_save(22, xla);
    return retval;
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_24();
    jj_save(23, xla);
    return retval;
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_25();
    jj_save(24, xla);
    return retval;
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_26();
    jj_save(25, xla);
    return retval;
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_27();
    jj_save(26, xla);
    return retval;
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_28();
    jj_save(27, xla);
    return retval;
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_29();
    jj_save(28, xla);
    return retval;
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_30();
    jj_save(29, xla);
    return retval;
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_31();
    jj_save(30, xla);
    return retval;
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_32();
    jj_save(31, xla);
    return retval;
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_33();
    jj_save(32, xla);
    return retval;
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_34();
    jj_save(33, xla);
    return retval;
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_35();
    jj_save(34, xla);
    return retval;
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_36();
    jj_save(35, xla);
    return retval;
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_37();
    jj_save(36, xla);
    return retval;
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_38();
    jj_save(37, xla);
    return retval;
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_39();
    jj_save(38, xla);
    return retval;
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_40();
    jj_save(39, xla);
    return retval;
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_41();
    jj_save(40, xla);
    return retval;
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_42();
    jj_save(41, xla);
    return retval;
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_43();
    jj_save(42, xla);
    return retval;
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_44();
    jj_save(43, xla);
    return retval;
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_45();
    jj_save(44, xla);
    return retval;
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_46();
    jj_save(45, xla);
    return retval;
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_47();
    jj_save(46, xla);
    return retval;
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_48();
    jj_save(47, xla);
    return retval;
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_49();
    jj_save(48, xla);
    return retval;
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_50();
    jj_save(49, xla);
    return retval;
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_51();
    jj_save(50, xla);
    return retval;
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_52();
    jj_save(51, xla);
    return retval;
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_53();
    jj_save(52, xla);
    return retval;
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_54();
    jj_save(53, xla);
    return retval;
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_55();
    jj_save(54, xla);
    return retval;
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_56();
    jj_save(55, xla);
    return retval;
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_57();
    jj_save(56, xla);
    return retval;
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_58();
    jj_save(57, xla);
    return retval;
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_59();
    jj_save(58, xla);
    return retval;
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_60();
    jj_save(59, xla);
    return retval;
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_61();
    jj_save(60, xla);
    return retval;
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_62();
    jj_save(61, xla);
    return retval;
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_63();
    jj_save(62, xla);
    return retval;
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_64();
    jj_save(63, xla);
    return retval;
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_65();
    jj_save(64, xla);
    return retval;
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_66();
    jj_save(65, xla);
    return retval;
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_67();
    jj_save(66, xla);
    return retval;
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_68();
    jj_save(67, xla);
    return retval;
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_69();
    jj_save(68, xla);
    return retval;
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_70();
    jj_save(69, xla);
    return retval;
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_71();
    jj_save(70, xla);
    return retval;
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_72();
    jj_save(71, xla);
    return retval;
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_73();
    jj_save(72, xla);
    return retval;
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_74();
    jj_save(73, xla);
    return retval;
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_75();
    jj_save(74, xla);
    return retval;
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_76();
    jj_save(75, xla);
    return retval;
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_77();
    jj_save(76, xla);
    return retval;
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_78();
    jj_save(77, xla);
    return retval;
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_79();
    jj_save(78, xla);
    return retval;
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_80();
    jj_save(79, xla);
    return retval;
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_81();
    jj_save(80, xla);
    return retval;
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_82();
    jj_save(81, xla);
    return retval;
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_83();
    jj_save(82, xla);
    return retval;
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_84();
    jj_save(83, xla);
    return retval;
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_85();
    jj_save(84, xla);
    return retval;
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_86();
    jj_save(85, xla);
    return retval;
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_87();
    jj_save(86, xla);
    return retval;
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_88();
    jj_save(87, xla);
    return retval;
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_89();
    jj_save(88, xla);
    return retval;
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_90();
    jj_save(89, xla);
    return retval;
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_91();
    jj_save(90, xla);
    return retval;
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_92();
    jj_save(91, xla);
    return retval;
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_93();
    jj_save(92, xla);
    return retval;
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_94();
    jj_save(93, xla);
    return retval;
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_95();
    jj_save(94, xla);
    return retval;
  }

  final private boolean jj_3_69() {
    if (jj_scan_token(IMPLIED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_14() {
    if (jj_3R_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_scan_token(REQUIRED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_14()) {
    jj_scanpos = xsp;
    if (jj_3_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_scan_token(EMPTY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(NAME_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_scan_token(DASH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COMMENT_CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_scan_token(ANY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_53() {
    if (jj_scan_token(OR_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_54()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_55()) {
    jj_scanpos = xsp;
    if (jj_3_56()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_57()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_scan_token(COMMENT_CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_93() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) {
    jj_scanpos = xsp;
    if (jj_3_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_50() {
    if (jj_scan_token(NAME_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_17() {
    if (jj_scan_token(BEGIN_COMMENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_93()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(END_COMMENT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_13() {
    if (jj_scan_token(BEGIN_ELEMENT_DECL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_scan_token(LEFT_PAREN_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_49()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_50()) {
    jj_scanpos = xsp;
    if (jj_3_51()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_52()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_53()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RIGHT_PAREN_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_46() {
    if (jj_scan_token(OR_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_47()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_48()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_scan_token(S_NOT_SYS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_scan_token(NOTATION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LEFT_PAREN_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_17()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_7()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_scan_token(NMTOKENS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_scan_token(SYSTEM_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SYSLITER_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_11() {
    if (jj_3R_16()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_scan_token(NMTOKEN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_3R_15()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_89() {
    if (jj_scan_token(SYSLITER_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    if (jj_3R_14()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_63() {
    if (jj_scan_token(ENTITIES)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_13()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_8()) {
    jj_scanpos = xsp;
    if (jj_3_9()) {
    jj_scanpos = xsp;
    if (jj_3_10()) {
    jj_scanpos = xsp;
    if (jj_3_11()) {
    jj_scanpos = xsp;
    if (jj_3_12()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_scan_token(ENTITY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_scan_token(S_NOT_SYS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_scan_token(IDREFS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(IDREF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_scan_token(PUBLIC_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PUBLITER_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_89()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_scan_token(CDATA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_16() {
    if (jj_scan_token(BEGIN_NOTATION_DECL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME_NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_14() {
    if (jj_scan_token(BEGIN_ATTR_DECL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_scan_token(GE_VAlUE_CHAR_SQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_scan_token(START_SQ_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_85()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(END_SQ_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_scan_token(GE_VAlUE_CHAR_DQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_scan_token(START_DQ_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_84()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(END_DQ_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_23() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(QUESTION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_scan_token(S_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_18() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_41()) {
    jj_scanpos = xsp;
    if (jj_3_42()) {
    jj_scanpos = xsp;
    if (jj_3_43()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_scan_token(S_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NDATA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_scan_token(SYSTEM_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SYSLITER_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_scan_token(RIGHT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_35() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_35()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_36()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_30() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_39() {
    Token xsp;
    if (jj_3_37()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_37()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RIGHT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_32()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_33()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_scan_token(PUBLIC_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PUBLITER_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_GE_PUB)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_38() {
    Token xsp;
    if (jj_3_34()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_34()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RIGHT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_78()) {
    jj_scanpos = xsp;
    if (jj_3_79()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_80()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_3R_23()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_20() {
    if (jj_scan_token(LEFT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_30()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_21()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_31()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_38()) {
    jj_scanpos = xsp;
    if (jj_3_39()) {
    jj_scanpos = xsp;
    if (jj_3_40()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_15() {
    if (jj_scan_token(BEGIN_GE_DECL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME_GE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_29() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_28() {
    if (jj_3R_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_scan_token(NAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_scan_token(ATTR_VALUE_CHAR_SQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_21() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_27()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_29()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_scan_token(START_SQ_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_75()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(END_SQ_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_scan_token(ATTR_VALUE_CHAR_DQ)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_22() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_scan_token(START_DQ_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_74()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(END_DQ_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_scan_token(RIGHT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_22()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAME)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_23()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_76()) {
    jj_scanpos = xsp;
    if (jj_3_77()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_25() {
    Token xsp;
    if (jj_3_24()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_24()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RIGHT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_19() {
    if (jj_scan_token(LEFT_PAREN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(PCDATA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_21()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_25()) {
    jj_scanpos = xsp;
    if (jj_3_26()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_scan_token(NMTOKEN_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_scan_token(NMTOKEN_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_13() {
    if (jj_3R_18()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_scan_token(FIXED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_22()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_scan_token(S)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_20()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_scan_token(S_ATTR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public DTDParserTokenManager token_source;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[0];
  final private int[] jj_la1_0 = {};
  final private int[] jj_la1_1 = {};
  final private int[] jj_la1_2 = {};
  final private JJCalls[] jj_2_rtns = new JJCalls[95];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public DTDParser(CharStream stream) {
    token_source = new DTDParserTokenManager(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CharStream stream) {
    token_source.ReInit(stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public DTDParser(DTDParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(DTDParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 0; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enumeration = jj_expentries.elements(); enumeration.hasMoreElements();) {
        int[] oldentry = (int[])(enumeration.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  final public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[77];
    for (int i = 0; i < 77; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 0; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 77; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 95; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
