/*
 * DefaultPrinterDialog.java
 *
 * Created on February 8, 2005, 11:04 AM
 */

package cern.laser.guiplatform.printing;

import cern.laser.console.LaserConsoleException;
import cern.laser.console.User;
import cern.laser.guiplatform.util.AppRegister;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.apache.log4j.Logger;
import cern.laser.guiplatform.util.LogFactory;
/**
 *
 * @author  woloszyn
 */
public class DefaultPrinterDialog extends javax.swing.JDialog {
    
    /** logger */
    protected static Logger logger = LogFactory.getLogger(DefaultPrinterDialog.class.getName());
    
    /** Creates new form DefaultPrinterDialog */
    public DefaultPrinterDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        defaultPrinterTextField = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        saveButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();

        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        setTitle("Default Printer Configuration");
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
            public void windowOpened(java.awt.event.WindowEvent evt) {
                formWindowOpened(evt);
            }
        });

        getContentPane().add(defaultPrinterTextField, new org.netbeans.lib.awtextra.AbsoluteConstraints(170, 30, 210, 20));

        jLabel1.setText("Default printer name");
        getContentPane().add(jLabel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 30, -1, -1));

        jLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        jLabel2.setText("i.e. 936-r030-tek");
        getContentPane().add(jLabel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(260, 60, -1, -1));

        saveButton.setText("Save");
        saveButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                saveButtonActionPerformed(evt);
            }
        });

        getContentPane().add(saveButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(20, 100, 90, -1));

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        getContentPane().add(cancelButton, new org.netbeans.lib.awtextra.AbsoluteConstraints(290, 100, 90, -1));

        pack();
    }//GEN-END:initComponents

    private void saveButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_saveButtonActionPerformed
        // pessimistic beginning
        
        NotifyDescriptor errorDescriptor = new NotifyDescriptor.Message(
        "Connection problem. The printer will not be saved.",
        NotifyDescriptor.ERROR_MESSAGE);
        
        User user = AppRegister.getInstance().getRegisteredUser();
        if ( user==null) {
            logger.debug("User in AppRegister is empty");
            DialogDisplayer.getDefault().notify(errorDescriptor);
            closeDialog(null);
            return;
        }
        try {
            user.setDefaultPrinter( defaultPrinterTextField.getText() );
            logger.debug("default printer stored");
        }
        catch ( LaserConsoleException ex) {
            logger.debug("Cannot save user's default printer");            
            
            DialogDisplayer.getDefault().notify(errorDescriptor);                        
        }
        closeDialog(null);
    }//GEN-LAST:event_saveButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        closeDialog(null);
    }//GEN-LAST:event_cancelButtonActionPerformed

    private void formWindowOpened(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowOpened
        User user = AppRegister.getInstance().getRegisteredUser();
        if ( user==null)
            return;
        try {
            String defaultPrinterName = user.getDefaultPrinter();
            defaultPrinterTextField.setText(defaultPrinterName);
        }
        catch ( LaserConsoleException ex) {
            logger.debug("Cannot get user's default printer");
            NotifyDescriptor errorDescriptor = new NotifyDescriptor.Message(
            "Connection problem [" + ex.getClass().getName() + "]",
            NotifyDescriptor.ERROR_MESSAGE);
            
            DialogDisplayer.getDefault().notify(errorDescriptor);
            
            closeDialog(null);
        }
    }//GEN-LAST:event_formWindowOpened
    
    
    public static String getDefaultPrinterName() {
    	User user = AppRegister.getInstance().getRegisteredUser();
        if (user != null)       
        	try {
        		logger.debug("got user's default printer");
        		return user.getDefaultPrinter();        
        	} catch (LaserConsoleException ex) {
        		logger.debug("Cannot get user's default printer");
        	}            
        return null;
    }
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        dispose();
    }//GEN-LAST:event_closeDialog
    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new DefaultPrinterDialog(new javax.swing.JFrame(), true).show();
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JTextField defaultPrinterTextField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JButton saveButton;
    // End of variables declaration//GEN-END:variables
    
}
