package cern.laser.guiplatform.windows.search;

import java.beans.IntrospectionException;
import java.util.Collection;
import java.util.Iterator;

import org.apache.log4j.Logger;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

import cern.gp.nodes.GPNode;
import cern.laser.client.data.Category;
import cern.laser.guiplatform.category.CategoryBean;
import cern.laser.guiplatform.util.AppRegister;
import cern.laser.guiplatform.util.Constants;
import cern.laser.guiplatform.util.LogFactory;
import cern.laser.guiplatform.windows.category.ChooseCategoryPanel;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
 */

/** An openable window available to the IDE's window manager.
 *
 * @author woloszyn
 */
public class CategorySelectorWindow extends TopComponent /* or CloneableTopComponent */ {
    private Logger logger = LogFactory.getLogger(CategorySelectorWindow.class.getName());
    private Category [] choosenCategories;
    
    private int windowMode; // this window can be used for different purposes, this variable determine in which mode window works
    
    // REMEMBER: You should have a public default constructor!
    // This is for externalization. If you have a nondefault
    // constructor for normal creation of the component, leave
    // in a default constructor that will put the component into
    // a consistent but unconfigured state, and make sure readExternal
    // initializes it properly. Or, be creative with writeReplace().
    public CategorySelectorWindow() {
        this(null, Constants.SEARCH_WINDOW_MODE_SEARCH_ACTIVE_LIST);
    }
    
    public CategorySelectorWindow(Category [] categories, int windowMode) {
        this.choosenCategories = categories;
        this.windowMode = windowMode;
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH

        switch( windowMode ) {
            case Constants.SEARCH_WINDOW_MODE_ARCHIVE_SEARCH :
                setName(NbBundle.getMessage(SearchWindow.class, "LBL_search_component_name_archive")+ " - Categories Selection");
                break;
            case Constants.SEARCH_WINDOW_MODE_GET_ALARMINFO :
                setName(NbBundle.getMessage(SearchWindow.class, "LBL_search_component_name_alarminfo")+ " - Categories Selection");
                break;
            case Constants.SEARCH_WINDOW_MODE_SEARCH_ACTIVE_LIST :
                setName(NbBundle.getMessage(SearchWindow.class, "LBL_search_component_name_search")+ " - Categories Selection");
                break;
            default:
                setName("No label found, check Bundle file!");
        }
    }
    
    /*
    public HelpCtx getHelpCtx() {
        return new HelpCtx(CategorySelectorWindow.class);
    }
     */
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new CategorySelectorWindow();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        buttonsPanel = new javax.swing.JPanel();
        searchButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        categoryPanel = new ChooseCategoryPanel( choosenCategories );

        setLayout(new java.awt.BorderLayout());

        searchButton.setText("Search");
        searchButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                searchButtonActionPerformed(evt);
            }
        });

        buttonsPanel.add(searchButton);

        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        buttonsPanel.add(cancelButton);

        add(buttonsPanel, java.awt.BorderLayout.SOUTH);

        add(categoryPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        storeCategorySelection();     
        close();
    }//GEN-LAST:event_cancelButtonActionPerformed
    
    private void searchButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_searchButtonActionPerformed
        storeCategorySelection();
        // put here creation Search Window with argument Selected Categories from this window
        TopComponent top = new SearchWindow( windowMode, getChoosenCategoriesArray() );
        top.open();
        
        close();
    }//GEN-LAST:event_searchButtonActionPerformed
    /**
     * storing the category selection in application register
     */ 
    
    private void storeCategorySelection() {        
        Category [] newCategories = ((ChooseCategoryPanel)categoryPanel).getChoosenCategoriesArray();
        AppRegister.getInstance().setSearchCategories(newCategories);
    }
    
    public Category [] getChoosenCategoriesArray() {
        return ((ChooseCategoryPanel)categoryPanel).getChoosenCategoriesArray();
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonsPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel categoryPanel;
    private javax.swing.JButton searchButton;
    // End of variables declaration//GEN-END:variables
    
    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String CategorySelectorWindow_MODE = "CategorySelectorWindow";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(CategorySelectorWindow_MODE);
        if (m == null) {
            try {
                m = ws.createMode(CategorySelectorWindow_MODE, // code name
                                   NbBundle.getMessage(CategorySelectorWindow.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/search/CategorySelectorWindowIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    /*
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
        return ...WindowManager.getDefault().getCurrentWorkspace().getBounds()...;
    }
     */
    
    /*
    // If you want it to open on a specific workspace:
    public static final String CategorySelectorWindow_WORKSPACE = NbBundle.getMessage(CategorySelectorWindow.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(CategorySelectorWindow_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(CategorySelectorWindow_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static CategorySelectorWindow theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.
    
    public void updateCategoryTreeExplorer() 
    throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel) categoryPanel).updateCategoryTreeExplorer();
    }
    
    /**
     * This method adds category to choosen category explorer
     * @param node category to be added
     */
    public void addCategory(GPNode node)
    throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel) categoryPanel).addCategory(node);
    }
    /**
     * This method adds category to choosen category explorer
     * @param node category to be added
     */
    public void addCategoryWithoutChildren(GPNode node)
    throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel) categoryPanel).addCategoryWithoutChildren(node);
    }
    
    public void addSubCategories(GPNode node)
    throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel) categoryPanel).addSubCategories(node);
    }
    public void removeCategoryWithoutChildren(GPNode node)
    throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel) categoryPanel).removeCategoryWithoutChildren(node);
    }
    public void removeSubCategories(GPNode node)
    throws IntrospectionException, CloneNotSupportedException {
        ((ChooseCategoryPanel) categoryPanel).removeSubCategories(node);
    }
    /**
     * This method remove category from ChoosenCategoryExplorer
     */
    public void removeCategory(GPNode node) {
        ((ChooseCategoryPanel) categoryPanel).removeCategory(node);
    }
    
    /**
     * This method remove all categories from ChoosenCategoryExplorer
     */
    public void removeAllCategories() {
        ((ChooseCategoryPanel) categoryPanel).removeAllCategories();
    }
    public void loadAllCategoriesInTreeExplorer() {
        ((ChooseCategoryPanel) categoryPanel).loadAllCategoriesInTreeExplorer();
    }
    /**
     * Getter method for choosen categories
     *
     * @return Array of Categories
     */
    public Category [] getChoosenCategories() {
        Collection categoryBeansCollection =  ((ChooseCategoryPanel) categoryPanel).getChoosenCategories() ;
        Category [] categories = new Category[categoryBeansCollection.size()];
        int i=0;
        for( Iterator iter = categoryBeansCollection.iterator(); iter.hasNext(); i++) {
            CategoryBean categoryBean = (CategoryBean) iter.next();
            categories[i] = categoryBean.getCategory();
        }
        return categories;
    }
}
