package cern.laser.guiplatform.windows.search;

import cern.laser.client.services.selection.AlarmSearchListener;
import cern.laser.client.services.selection.LaserSearchException;

import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

// As needed:
/*
import java.io.*;
import java.net.*;
import org.openide.ErrorManager;
import org.openide.actions.*;
import org.openide.awt.UndoRedo;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Utilities;
import org.openide.util.actions.*;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.io.*;
*/

/** An openable window available to the IDE's window manager.
 *
 * @author woloszyn
 */
public class ProgressDialog extends TopComponent implements AlarmSearchListener /* or CloneableTopComponent */ {
    
    // REMEMBER: You should have a public default constructor!
    // This is for externalization. If you have a nondefault
    // constructor for normal creation of the component, leave
    // in a default constructor that will put the component into
    // a consistent but unconfigured state, and make sure readExternal
    // initializes it properly. Or, be creative with writeReplace().
    public ProgressDialog() {
        initComponents();
        setCloseOperation(CLOSE_LAST); // or CLOSE_EACH
        // Display name of this window (not needed if you use the DataObject constructor):
        setName(NbBundle.getMessage(ProgressDialog.class, "LBL_dialog_component_name"));
        // You may set the icon, but often it is better to set the icon for an associated mode instead:
        // setIcon(Utilities.loadImage("cern/laser/guiplatform/windows/search/ProgressDialogIcon.gif", true));
        // Use the Component Inspector to set tool-tip text. This will be saved
        // automatically. Other JComponent properties you may need to save yuorself.
        // At any time you can affect the node selection:
        // setActivatedNodes(new Node[] {...});
    }
    /**
     * Set text in info label
     */    
    public void setInfoText(int lineNumber, String text) {
        if ( lineNumber<1 || lineNumber>5) {
            return;
        }
        switch( lineNumber ) {
            case 1 :
                infoLabel1.setText(text);
                break;
            case 2 :
                infoLabel2.setText(text);
                break;
            case 3 :
                infoLabel3.setText(text);
                break;
            case 4 :
                infoLabel4.setText(text);
                break;
            case 5 :
                infoLabel5.setText(text);
                break;
        }        
    }
    public void clearInfoText() {
        infoLabel1.setText("");
        infoLabel2.setText("");
        infoLabel3.setText("");
        infoLabel4.setText("");
        infoLabel5.setText("");
    }

    /*
    public HelpCtx getHelpCtx() {
        return new HelpCtx(ProgressDialog.class);
    }
    */
    
    /*
    // If you are using CloneableTopComponent, probably you should override:
    protected CloneableTopComponent createClonedObject() {
        return new ProgressDialog();
    }
    protected boolean closeLast() {
        // You might want to prompt the user first and maybe return false:
        return true;
    }
     */
    
    // APPEARANCE
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the FormEditor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        mainPanel = new javax.swing.JPanel();
        infoLabel1 = new javax.swing.JLabel();
        infoLabel2 = new javax.swing.JLabel();
        infoLabel3 = new javax.swing.JLabel();
        infoLabel4 = new javax.swing.JLabel();
        infoLabel5 = new javax.swing.JLabel();
        infoLable6 = new javax.swing.JLabel();
        buttonsPanel = new javax.swing.JPanel();
        jButton1 = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        setPreferredSize(new java.awt.Dimension(300, 200));
        mainPanel.setLayout(new java.awt.GridLayout(8, 1));

        infoLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel1.setText("Search in progress...");
        mainPanel.add(infoLabel1);

        infoLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        infoLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel2.setText("---");
        infoLabel2.setMaximumSize(new java.awt.Dimension(430, 150));
        infoLabel2.setMinimumSize(new java.awt.Dimension(430, 150));
        mainPanel.add(infoLabel2);

        infoLabel3.setFont(new java.awt.Font("Dialog", 0, 12));
        infoLabel3.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel3.setText("---");
        mainPanel.add(infoLabel3);

        infoLabel4.setFont(new java.awt.Font("Dialog", 0, 12));
        infoLabel4.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel4.setText("---");
        mainPanel.add(infoLabel4);

        infoLabel5.setFont(new java.awt.Font("Dialog", 0, 12));
        infoLabel5.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLabel5.setText("---");
        mainPanel.add(infoLabel5);

        infoLable6.setFont(new java.awt.Font("Dialog", 0, 12));
        infoLable6.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        infoLable6.setText("---");
        mainPanel.add(infoLable6);

        add(mainPanel, java.awt.BorderLayout.NORTH);

        jButton1.setText("Stop");
        buttonsPanel.add(jButton1);

        add(buttonsPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents

    public boolean isSearchCancelled() {
        return false;
    }    
    
    public void onSearchAlarm(cern.laser.client.data.Alarm alarm) {
        // increment counter
    }    
    
    public void onSearchException(LaserSearchException laserSearchException) {
        clearInfoText();
        setInfoText(3,"Search problem, try again later.");
        close();    
    }
    
    public void searchFinished() {
        clearInfoText();
        setInfoText(3,"Search finished");
        close();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonsPanel;
    private javax.swing.JLabel infoLabel1;
    private javax.swing.JLabel infoLabel2;
    private javax.swing.JLabel infoLabel3;
    private javax.swing.JLabel infoLabel4;
    private javax.swing.JLabel infoLabel5;
    private javax.swing.JLabel infoLable6;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel mainPanel;
    // End of variables declaration//GEN-END:variables
    
    // MODES AND WORKSPACES
    
    /*
    // If you want it to open in a specific mode:
    public static final String ProgressDialog_MODE = "ProgressDialog";
    public void open(Workspace ws) {
        super.open(ws);
        if (ws == null) ws = WindowManager.getDefault().getCurrentWorkspace();
        Mode m = ws.findMode(ProgressDialog_MODE);
        if (m == null) {
            try {
                m = ws.createMode(ProgressDialog_MODE, // code name
                                   NbBundle.getMessage(ProgressDialog.class, "LBL_mode_name"), // display name
                                   new URL("nbresloc:/cern/laser/guiplatform/windows/search/ProgressDialogIcon.gif"));
            } catch (MalformedURLException mfue) {
                ErrorManager.getDefault().notify(mfue);
                return;
            }
            // If you want it in a specific position:
            // m.setBounds(...ws.getBounds()...);
        }
        m.dockInto(this);
    }
     */
    
    /*
    // If you are not specifying a mode you may wish to use:
    public Dimension getPreferredSize() {
        return ...WindowManager.getDefault().getCurrentWorkspace().getBounds()...;
    }
     */
    
    /*
    // If you want it to open on a specific workspace:
    public static final String ProgressDialog_WORKSPACE = NbBundle.getMessage(ProgressDialog.class, "LBL_workspace_name");
    public void open() {
        WindowManager wm = WindowManager.getDefault();
        Workspace ws = wm.findWorkspace(ProgressDialog_WORKSPACE);
        if (ws == null)
            ws = wm.createWorkspace(ProgressDialog_WORKSPACE);
        open(ws);
        ws.activate();
    }
     */
    
    // PERSISTENCE
    
    private static final long serialVersionUID = 1L;
	/* (non-Javadoc)
	 * @see cern.laser.client.services.selection.AlarmSearchListener#onSearchException(cern.laser.client.services.selection.LaserSearchException)
	 */
    
    /*
    // If you wish to keep any state between IDE restarts, put it here:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        setSomeState((SomeType)in.readObject());
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(getSomeState());
    }
     */
    
    /*
    // The above assumes that the SomeType is safely serializable, e.g. String or Date.
    // If it is some class of your own that might change incompatibly, use e.g.:
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        NbMarshalledObject read = (NbMarshalledObject)in.readObject();
        if (read != null) {
            try {
                setSomeState((SomeType)read.get());
            } catch (Exception e) {
                ErrorManager.getDefault().notify(e);
                // If the problem would make this component inconsistent, use:
                // throw new SafeException(e);
            }
        }
    }
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        Object toWrite;
        try {
            toWrite = new NbMarshalledObject(getSomeState());
        } catch (Exception e) {
            ErrorManager.getDefault().notify(e);
            toWrite = null;
            // Again you may prefer to use:
            // throw new SafeException(e);
        }
        out.writeObject(toWrite);
    }
     */
    
    /*
    // Use this to discard the component after restarts (make it nonpersistent):
    private Object readResolve() throws ObjectStreamException {
        return null;
        // If you wish to conditionally discard it, make readExternal set
        // or clear some flag acc. to the condition, then use:
        // return discardFlag ? null : this;
        // Singleton component using private static ProgressDialog theInstance:
        // if (theInstance == null) theInstance = this;
        // return theInstance;
    }
     */
    
    // ACTIONS
    
    /*
    // If you wish to have extra actions appear in the window's
    // popup menu, they can go here:
    public SystemAction[] getSystemActions() {
        SystemAction[] supe = super.getSystemActions();
        SystemAction[] mine = new SystemAction[supe.length + 1];
        System.arraycopy(supe, 0, mine, 0, supe.length);
        mine[supe.length] = SystemAction.get(SomeActionOfMine.class);
        return mine;
    }
     */
    
    /*
    // Associate implementations with copying, searching, etc.:
    protected void componentActivated() {
        ((CallbackSystemAction)SystemAction.get(FindAction.class)).setActionPerformer(new ActionPerformer() {
                public void performAction(SystemAction action) {
                    // search this component somehow
                }
            });
        // similar for CopyAction, CutAction, DeleteAction, GotoAction, ReplaceAction, etc.
        // for PasteAction, use:
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(new PasteType[] {...});
    }
    protected void componentDeactivated() {
        // FindAction will be turned off by itself
        // ((PasteAction)SystemAction.get(PasteAction.class)).setPasteTypes(null);
    }
     */
    
    /*
    // If you want UndoAction and RedoAction to be enabled on this component:
    public UndoRedo getUndoRedo() {
        return new MyUndoRedo(this);
    }
     */
    
    // Printing, saving, compiling, etc.: use cookies on some appropriate node and
    // use this node as the node selection.
    
}
