#include <DDSHelper.h>
#include <ace/Service_Config.h>
#include <string.h>
#include <stdlib.h>
#include <dds/DCPS/transport/simpleTCP/SimpleTcpGenerator.h>

using namespace ddsnc;

static bool factories_init = false;

DDSHelper::DDSHelper(const char* channelName)
{
	init(channelName, "corbaloc:iiop:127.0.0.1:3999/DCPSInfoRepo");
}

DDSHelper::DDSHelper(const char* channelName, const char *DCPSInfoRepoLoc)
{
	init(channelName, DCPSInfoRepoLoc);
}

void DDSHelper::init(const char* channelName, const char* DCPSInfoRepoLoc)
{
	int argc;
	char* argv[7];
	argc=7;

	argv[0] = strdup("Participant");
	argv[1] = strdup("-DCPSInforepo");
	argv[2] = strdup(DCPSInfoRepoLoc);
	//DCPS Debug Level
	argv[3] = strdup("-DCPSDebugLevel");
	argv[4] = strdup("0");
	//Transport Debug Level
	argv[5] = strdup("-DCPSTransportDebugLevel");
	argv[6] = strdup("0");

	std::cerr << "Registering TransportImpl" << std::endl;
/* Fedora 8 systems have a problem with next line of code. If the component is
 * referenced by a simple client the DDS Notiification Channel works only once
 * time, the second time the maciContainer will exit with a Segmentation Fault
 * generated by ACE library. The error cannot be replicated if it used
 * object explorer. Maybe this error can affect to all RedHat OSs similar to
 * Fedora 8 (SL 5.2). The line below works great under Ubuntu 8.04
 */
//	ACE_Service_Config::process_directive(
//			"static DCPS_SimpleTcpLoader \"-type SimpleTcp\"");

	transport_impl_id=1;
	factories_init = true;

	try{
		OpenDDS::DCPS::SimpleTcpGenerator* generator;
		generator = new OpenDDS::DCPS::SimpleTcpGenerator ();
	
		TheTransportFactory->register_generator ("SimpleTcp",
				generator);
	}
	/*
	 * if the transport generator is already registered we do nothing
	 */
	catch(...){}
	
	dpf=TheParticipantFactoryWithArgs(argc, (ACE_TCHAR**)argv);
	
	initialized=false;
	setPartitionName(channelName);

//	::std::string channelStr(channelName);
//	 int pos=channelStr.find_last_of("_");
//   if(pos<0){
//
//      setTopicName(channelName);
//      return;
//   }
//   setTopicName(channelStr.substr(++pos).c_str());
//	  std::cerr << "Trying to set topic name: " << topicName <<std::endl;
//   setPartitionName(channelStr.substr(0,--pos).c_str());

}

int DDSHelper::createParticipant(){
	std::cerr << "DDSHelper::createParticipant" << std::endl;
	participant = dpf->create_participant(DOMAIN_ID,
			PARTICIPANT_QOS_DEFAULT,
			DDS::DomainParticipantListener::_nil());

	if (CORBA::is_nil(participant.in())){
		std::cerr << "Create Participant Failed." << std::endl;
		return 1;
	}
	
	std::cerr << "Created the participant" << std::endl;
	
	return 0;
}


void DDSHelper::initializeTransport(){
	try{
		std::cerr << " DDSHelper::initializeTransport()" << std::endl;
		transport_impl=
			TheTransportFactory->create_transport_impl(transport_impl_id,
					"SimpleTcp", ::OpenDDS::DCPS::AUTO_CONFIG);
		
		std::cerr << "Transport ID:" << transport_impl_id << std::endl;

		OpenDDS::DCPS::TransportConfiguration_rch config =
			TheTransportFactory->get_configuration(transport_impl_id);
		OpenDDS::DCPS::SimpleTcpConfiguration * tcp_config = 
			dynamic_cast<OpenDDS::DCPS::SimpleTcpConfiguration *>(config.in());

		::std::cerr << "TCP Address: "<< 
			tcp_config->local_address_str_ << ::std::endl;

		std::cerr << "Finishing configuration" << std::endl;

	}
	catch(OpenDDS::DCPS::Transport::Duplicate &ex){
		transport_impl_id++;
		initializeTransport();	
//		transport_impl=TheTransportFactory->obtain(transport_impl_id);
	}

	std::cerr << "Transport ID:" << transport_impl_id << std::endl;

	OpenDDS::DCPS::TransportConfiguration_rch config =
		TheTransportFactory->get_configuration(transport_impl_id);
	OpenDDS::DCPS::SimpleTcpConfiguration * tcp_config = 
		dynamic_cast<OpenDDS::DCPS::SimpleTcpConfiguration *>(config.in());

	::std::cerr << "TCP Address: "<< 
		tcp_config->local_address_str_ << ::std::endl;

	std::cerr << "Finishing configuration" << std::endl;

}

void DDSHelper::setTopicName(const char* topicName)
{
	this->topicName=strdup(topicName);
}

void DDSHelper::initializeTopic(const char* topicName, CORBA::String_var typeName)
{
	std::cerr << "Initializing topic: " << this->topicName << std::endl;
	std::cerr << "with type: " << typeName << std::endl;
	participant->get_default_topic_qos(topicQos);
	topic=participant->create_topic(topicName, typeName.in(),
			topicQos, DDS::TopicListener::_nil());

	if (CORBA::is_nil(topic.in())){
         std::cerr << "create_topic failed" << std::endl;
	}
	
}

void DDSHelper::initializeTopic(CORBA::String_var typeName)
{
	std::string topicStr (typeName);
	int f = topicStr.find_first_of(":");
	int l = topicStr.find_last_of(":");
	topicName = strdup(topicStr.substr(f+1, (l-1)-f).c_str());
	initializeTopic(topicName, typeName);
}

void DDSHelper::setPartitionName(const char* partitionName){
	this->partitionName=strdup(partitionName);
}

void DDSHelper::disconnect()
{
	std::cerr<< "DDSHelper::disconnect()"<<std::endl;
	if(initialized==true){
		std::cerr<< "DDSHelper::disconnect()"<<std::endl;
		participant->delete_contained_entities();
		dpf->delete_participant(participant.in());
		TheTransportFactory->release(transport_impl_id);
		//TheServiceParticipant->shutdown();
		initialized=false;
	}
}

DDSHelper::~DDSHelper()
{
	std::cerr << "DDSHelper::~DDSHelper()" << std::endl;
	disconnect();
	free(partitionName);
	free(topicName);
}

void DDSHelper::cleanUp()
{
	if (factories_init){
		TheTransportFactory->release();
		TheServiceParticipant->shutdown();
	}
}
