package alma.demo.dyncomp;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/** The class used to show the button inside the table
*
*  @author Alessandro Caproni, 2003, Nov 7 
*/
class  MyCellRendererr extends JButton implements TableCellRenderer {

	/** The constructor
	*/
	public  MyCellRendererr() {
	}

	/** Return the button to show into the cell when the user is not editing the cell
	*
	* @param table The JTable that own the cell
	* @param value The value of the cell
	* @param True if the cell is selected
	* @param hasFocus True if the cell has the focus
	* @param row The row of the cell
	* @param column The column of the cell
	*
	* @return The button to show into the cell
	*/
	public Component getTableCellRendererComponent(
			JTable table, 
			Object value, 
			boolean isSelected, 
			boolean hasFocus, 
			int row, 
			int column) {
		if (table.getValueAt(row,column)!=null) {
			JButton btn = (JButton)value;
			btn.setVisible(true);
			return btn;
		} else return null;
	}
	
}



