/*
 * ALMA - Atacama Large Millimeter Array
 * (c) European Southern Observatory, 2002
 * (c) Associated Universities Inc., 2002
 * Copyright by ESO (in the framework of the ALMA collaboration),
 * Copyright by AUI (in the framework of the ALMA collaboration),
 * All rights reserved.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307  USA
 *
 * File Publisher.java
 */
 
//package alma.scheduling.define.nc;
package alma.acs.nc;

import org.omg.CORBA.portable.IDLEntity;

import alma.acs.exceptions.AcsJException;

/**
 * The Publisher interface alllows one to publish events to a
 * notification channel that already exists.
 * 
 * @version 1.00 Apr 10, 2003
 * @author Allen Farris
 * @deprecated since ACS 7.0.2, see COMP-1786. Class {@link CorbaNotificationChannel} will be used directly.
*/
public interface Publisher {

	/**
	 * Publish an event on this notification channel.
	 * <p>
	 * With ACS 7.0.2 we had to add the "throws AcsJException" declaration even though this is an incompatible change.
	 * Before, the implementation of publish just suppressed any exceptions.
	 * @param event Object to publish.
	 */
	public void publish(IDLEntity event) throws AcsJException; 

}
