/******************************************************************************
 *
 * $Id: translator_hu.h,v 1.24 2000/08/23 12:39:04 root Exp $
 *
 * Copyright (C) 1997-2001 by Dimitri van Heesch.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation under the terms of the GNU General Public License is hereby 
 * granted. No representations are made about the suitability of this software 
 * for any purpose. It is provided "as is" without express or implied warranty.
 * See the GNU General Public License for more details.
 *
 * Documents produced by Doxygen are derivative works derived from the
 * input used in their production; they are not affected by this license.
 *
 */

#ifndef TRANSLATOR_HU_H
#define TRANSLATOR_HU_H

#include "translator.h"

class TranslatorHungarian : public TranslatorAdapter_1_2_1
{
  public:

    // --- Language control methods -------------------
    QCString idLanguage()
    { return "hungarian"; }
    /*! Used to get the command(s) for the language support. This method
     *  was designed for languages which do not prefer babel package.
     *  If this methods returns empty string, then the latexBabelPackage()
     *  method is used to generate the command for using the babel package.
     */
    QCString latexLanguageSupportCommand()
    {
      return "";
    }
    /*! returns the name of the package that is included by LaTeX */
    QCString latexBabelPackage() 
    { return ""; }

    /*! return the language charset. This will be used for the HTML output */
    QCString idLanguageCharset()
    {
      return "iso-8859-2";
    }

    // --- Language translation methods -------------------

    /*! used in the compound documentation before a list of related functions. */
    QCString trRelatedFunctions()
    { return "Kapcsold fggvnyek"; }

    /*! subscript for the related functions. */
    QCString trRelatedSubscript()
    { return "(Figyelem! Ezek a fggvnyek nem tagjai az osztlynak!)"; }

    /*! header that is put before the detailed description of files, classes and namespaces. */
    QCString trDetailedDescription()
    { return "Rszletes lers"; }

    /*! header that is put before the list of typedefs. */
    QCString trMemberTypedefDocumentation()
    { return "Osztlytag tpusdefincik dokumentcija"; }
    
    /*! header that is put before the list of enumerations. */
    QCString trMemberEnumerationDocumentation()
    { return "Osztlytag enumercik dokumentcija"; }
    
    /*! header that is put before the list of member functions. */
    QCString trMemberFunctionDocumentation()
    { return "Osztlytag fggvnyek (metdusok) dokumentcija"; }
    
    /*! header that is put before the list of member attributes. */
    QCString trMemberDataDocumentation()
    { return "Osztlytag adatok dokumentcija"; }

    /*! this is the text of a link put after brief descriptions. */
    QCString trMore() 
    { return "Rszletek..."; }

    /*! put in the class documentation */
    QCString trListOfAllMembers()
    { return "Osztlytagok listja."; }

    /*! used as the title of the "list of all members" page of a class */
    QCString trMemberList()
    { return "Osztlytagok listja"; }

    /*! this is the first part of a sentence that is followed by a class name */
    QCString trThisIsTheListOfAllMembers()
    { return "A(z) "; }

    /*! this is the remainder of the sentence after the class name */
    QCString trIncludingInheritedMembers()
    { return " osztly tagjainak teljes listja, az rklt tagokkal egytt."; }
    
    /*! this is put at the author sections at the bottom of man pages.
     *  parameter s is name of the project name.
     */
    QCString trGeneratedAutomatically(const char *s)
    { QCString result="Ezt a dokumentcit a Doxygen ksztette";
      if (s) result+=(QCString)" a(z) "+s+(QCString)" projekthez";
      result+=" a forrskdbl."; 
      return result;
    }

    /*! put after an enum name in the list of all members */
    QCString trEnumName()
    { return "enumerci neve"; }
    
    /*! put after an enum value in the list of all members */
    QCString trEnumValue()
    { return "enumerci rtke"; }
    
    /*! put after an undocumented member in the list of all members */
    QCString trDefinedIn()
    { return "definilva itt:"; }

    /*! put as in introduction in the verbatim header file of a class.
     *  parameter f is the name of the include file.
     */
    QCString trVerbatimText(const char *f)
    { return (QCString)"Ez a(z) "+f+" defincis fjl pontos tartalma."; }
    
    // quick reference sections

    /*! This is put above each page as a link to the list of all groups of 
     *  compounds or files (see the \group command).
     */
    QCString trModules()
    { return "Modulok"; }
    
    /*! This is put above each page as a link to the class hierarchy */
    QCString trClassHierarchy()
    { return "Osztlyhierarchia"; }
    
    /*! This is put above each page as a link to the list of annotated classes */
    QCString trCompoundList()
    { return "sszetevk listja"; }
    
    /*! This is put above each page as a link to the list of documented files */
    QCString trFileList()
    { return "Fjlok listja"; }

    /*! This is put above each page as a link to the list of all verbatim headers */
    QCString trHeaderFiles()
    { return "Defincis fjlok"; }

    /*! This is put above each page as a link to all members of compounds. */
    QCString trCompoundMembers()
    { return "Osztlyok sszetevi"; }

    /*! This is put above each page as a link to all members of files. */
    QCString trFileMembers()
    { return "Fjlok elemei"; }

    /*! This is put above each page as a link to all related pages. */
    QCString trRelatedPages()
    { return "Kapcsold lapok"; }

    /*! This is put above each page as a link to all examples. */
    QCString trExamples()
    { return "Pldk"; }

    /*! This is put above each page as a link to the search engine. */
    QCString trSearch()
    { return "Keress"; }

    /*! This is an introduction to the class hierarchy. */
    QCString trClassHierarchyDescription()
    { return "Ez a leszrmaztatsi lista hozzvetleg, "
             "de nem szigoran vve, bc sorrendbe rendezett:";
    }

    /*! This is an introduction to the list with all files. */
    QCString trFileListDescription(bool extractAll)
    {
      QCString result="Ez az sszes ";
      if (!extractAll) result+="doumentlt ";
      result+="fjl listja rvid lersokkal:";
      return result;
    }

    /*! This is an introduction to the annotated compound list. */
    QCString trCompoundListDescription()
    { return "Ez az osztlyok, struktrk, unik s interfszek "
             "listja rvid lersokkal:"; 
    }

    /*! This is an introduction to the page with all class members. */
    QCString trCompoundMembersDescription(bool extractAll)
    {
      QCString result="Ez az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="osztly sszetev listja ";
      if (extractAll) 
        result+="hivatkozssal a hozzjuk tartz osztly dokumentcira:";
      else 
        result+="az ket tartalmaz osztly megjellsvel:";
      return result;
    }

    /*! This is an introduction to the page with all file members. */
    QCString trFileMembersDescription(bool extractAll)
    {
      QCString result="Ez az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="fjl elem listja ";
      if (extractAll) 
        result+="hivatkozssal a hozzjuk tartz fjl dokumentcira:";
      else 
        result+="az ket tartalmaz fjl megjellsvel:";
      return result;
    }

    /*! This is an introduction to the page with the list of all header files. */
    QCString trHeaderFilesDescription()
    { return "Ezek a Programozi Interfszt (API) alkot defincis fjlok:"; }

    /*! This is an introduction to the page with the list of all examples */
    QCString trExamplesDescription()
    { return "Ez a pldk listja:"; }

    /*! This is an introduction to the page with the list of related pages */
    QCString trRelatedPagesDescription()
    { return "Ez a kapcsold dokumentcik listja:"; }

    /*! This is an introduction to the page with the list of class/file groups */
    QCString trModulesDescription()
    { return "Ez a modulok listja:"; }

    /*! This sentences is used in the annotated class/file lists if no brief
     * description is given. 
     */
    QCString trNoDescriptionAvailable()
    { return "Nincs hozz lers"; }
    
    // index titles (the project name is prepended for these) 


    /*! This is used in HTML as the title of index.html. */
    QCString trDocumentation()
    { return "Dokumentci"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * index of all groups.
     */
    QCString trModuleIndex()
    { return "Modul index"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * class hierarchy.
     */
    QCString trHierarchicalIndex()
    { return "Hierarchikus index"; }

    /*! This is used in LaTeX as the title of the chapter with the 
     * annotated compound index.
     */
    QCString trCompoundIndex()
    { return "sszetevk indexe"; }

    /*! This is used in LaTeX as the title of the chapter with the
     * list of all files.
     */
    QCString trFileIndex() 
    { return "Fjl index"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all groups.
     */
    QCString trModuleDocumentation()
    { return "Modul documentci"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all classes, structs and unions.
     */
    QCString trClassDocumentation()
    { return "Osztly documentatci"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all files.
     */
    QCString trFileDocumentation()
    { return "Fjl documentatci"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all examples.
     */
    QCString trExampleDocumentation()
    { return "Pldk documentatcija"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all related pages.
     */
    QCString trPageDocumentation()
    { return "Kapcsold lapok documentcija"; }

    /*! This is used in LaTeX as the title of the document */
    QCString trReferenceManual()
    { return "Referencia kziknyv"; }
    
    /*! This is used in the documentation of a file as a header before the 
     *  list of defines
     */
    QCString trDefines()
    { return "Defincik"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of function prototypes
     */
    QCString trFuncProtos()
    { return "Fggvny prototpusok"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of typedefs
     */
    QCString trTypedefs()
    { return "Tpusdefincik"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of enumerations
     */
    QCString trEnumerations()
    { return "Enumercik"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) functions
     */
    QCString trFunctions()
    { return "Fggvnyek"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    QCString trVariables()
    { return "Vltozk"; }

    /*! This is used in the documentation of a file as a header before the 
     *  list of (global) variables
     */
    QCString trEnumerationValues()
    { return "Enumerci rtkek"; }
    
    /*! This is used in man pages as the author section. */
    QCString trAuthor()
    { return "Szerz"; }

    /*! This is used in the documentation of a file before the list of
     *  documentation blocks for defines
     */
    QCString trDefineDocumentation()
    { return "Defincik dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for function prototypes
     */
    QCString trFunctionPrototypeDocumentation()
    { return "Fggvny prototpusok documentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for typedefs
     */
    QCString trTypedefDocumentation()
    { return "Tpusdefincik documentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration types
     */
    QCString trEnumerationTypeDocumentation()
    { return "Enumercik documentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for enumeration values
     */
    QCString trEnumerationValueDocumentation()
    { return "Enumerci rtkek documentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for functions
     */
    QCString trFunctionDocumentation()
    { return "Fggvnyek dokumentcija"; }

    /*! This is used in the documentation of a file/namespace before the list 
     *  of documentation blocks for variables
     */
    QCString trVariableDocumentation()
    { return "Vltozk documentcija"; }

    /*! This is used in the documentation of a file/namespace/group before 
     *  the list of links to documented compounds
     */
    QCString trCompounds()
    { return "sszetevk"; }

    /*! This is used in the documentation of a group before the list of 
     *  links to documented files
     */
    QCString trFiles()
    { return "Fjlok"; }

    /*! This is used in the standard footer of each page and indicates when 
     *  the page was generated 
     */
    QCString trGeneratedAt(const char *date,const char *projName)
    { 
      QCString result=(QCString)"";
      if (projName) result+=(QCString)"Projekt: "+projName;
      result+=(QCString)" Kszlt: "+date+" Ksztette: ";
      return result;
    }
    /*! This is part of the sentence used in the standard footer of each page.
     */
    QCString trWrittenBy()
    {
      return " melyet rt ";
    }

    /*! this text is put before a class diagram */
    QCString trClassDiagram(const char *clName)
    {
      return clName+(QCString)" osztly szrmaztatsi diagramja";
    }
    
    /*! this text is generated when the \\internal command is used. */
    QCString trForInternalUseOnly()
    { return "CSAK BELS HASZNLATRA!"; }

    /*! this text is generated when the \\reimp command is used. */
    QCString trReimplementedForInternalReasons()
    { return "Bels okok miatt jraimplementlva, az API-t nem rinti."; }

    /*! this text is generated when the \\warning command is used. */
    QCString trWarning()
    { return "Figyelmeztets"; }

    /*! this text is generated when the \\bug command is used. */
    QCString trBugsAndLimitations()
    { return "Hibk s korltozsok"; }

    /*! this text is generated when the \\version command is used. */
    QCString trVersion()
    { return "Verzi"; }

    /*! this text is generated when the \\date command is used. */
    QCString trDate()
    { return "Dtum"; }

    /*! this text is generated when the \\author command is used. */
    QCString trAuthors()
    { return "Szerz(k)"; }

    /*! this text is generated when the \\return command is used. */
    QCString trReturns()
    { return "Visszaadott rtk"; }

    /*! this text is generated when the \\sa command is used. */
    QCString trSeeAlso()
    { return "Lsd mg"; }

    /*! this text is generated when the \\param command is used. */
    QCString trParameters()
    { return "Paramterek"; }

    /*! this text is generated when the \\exception command is used. */
    QCString trExceptions()
    { return "Kivtelek"; }
    
    /*! this text is used in the title page of a LaTeX document. */
    QCString trGeneratedBy()
    { return "Ksztette"; }

    // new since 0.49-990307
    
    /*! used as the title of page containing all the index of all namespaces. */
    QCString trNamespaceList()
    { return "Nvtr lista"; }

    /*! used as an introduction to the namespace list */
    QCString trNamespaceListDescription(bool extractAll)
    {
      QCString result="Ez az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="nvtr listja rvid lersokkal:";
      return result;
    }

    /*! used in the class documentation as a header before the list of all
     *  friends of a class
     */
    QCString trFriends()
    { return "Bartok"; }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990405
//////////////////////////////////////////////////////////////////////////
    
    /*! used in the class documentation as a header before the list of all
     * related classes 
     */
    QCString trRelatedFunctionDocumentation()
    { return "Bart s kapcsold fggvnyek dokumentcija"; }
    
//////////////////////////////////////////////////////////////////////////
// new since 0.49-990425
//////////////////////////////////////////////////////////////////////////

    /*! used as the title of the HTML page of a class/struct/union */
    QCString trCompoundReference(const char *clName,
                                    ClassDef::CompoundType compType,
                                    bool isTemplate)
    {
      QCString result=(QCString)clName;
      switch(compType)
      {
        case ClassDef::Class:      result+=" osztly"; break;
        case ClassDef::Struct:     result+=" struktra"; break;
        case ClassDef::Union:      result+=" uni"; break;
        case ClassDef::Interface:  result+=" interfsz"; break;
        case ClassDef::Exception:  result+=" kivtel"; break;
      }
      if (isTemplate) result+=" sablon";
      result+=" referencia";
      return result;
    }

    /*! used as the title of the HTML page of a file */
    QCString trFileReference(const char *fileName)
    {
      QCString result=fileName;
      result+=" fjl referencia"; 
      return result;
    }

    /*! used as the title of the HTML page of a namespace */
    QCString trNamespaceReference(const char *namespaceName)
    {
      QCString result=namespaceName;
      result+=" nvtr reference";
      return result;
    }
    
    /* these are for the member sections of a class, struct or union */
    QCString trPublicMembers()
    { return "Publikus metdusok"; }
    QCString trPublicSlots()
    { return "Publikus adatok"; }
    QCString trSignals()
    { return "Szignlok"; }
    QCString trStaticPublicMembers()
    { return "Statikus publikus metdusok"; }
    QCString trProtectedMembers()
    { return "Vdett metdusok"; }
    QCString trProtectedSlots()
    { return "Vdett adatok"; }
    QCString trStaticProtectedMembers()
    { return "Statikus vdett metdusok"; }
    QCString trPrivateMembers()
    { return "Privt metdusok"; }
    QCString trPrivateSlots()
    { return "Privt adatok"; }
    QCString trStaticPrivateMembers()
    { return "Statikus privt metdusok"; }
    
    /*! this function is used to produce a comma-separated list of items.
     *  use generateMarker(i) to indicate where item i should be put.
     */
    QCString trWriteList(int numEntries)
    {
      QCString result;
      int i;
      // the inherits list contain `numEntries' classes
      for (i=0;i<numEntries;i++) 
      {
        // use generateMarker to generate placeholders for the class links!
        result+=generateMarker(i); // generate marker for entry i in the list 
                                   // (order is left to right)
        
        if (i!=numEntries-1)  // not the last entry, so we need a separator
        {
          if (i<numEntries-2) // not the fore last entry 
            result+=", ";
          else                // the fore last entry
            result+=" s ";
        }
      }
      return result; 
    }
    
    /*! used in class documentation to produce a list of base classes,
     *  if class diagrams are disabled.
     */
    QCString trInheritsList(int numEntries)
    {
      return "Szlk osztlyok: "+trWriteList(numEntries)+".";
    }

    /*! used in class documentation to produce a list of super classes,
     *  if class diagrams are disabled.
     */
    QCString trInheritedByList(int numEntries)
    {
      return "Szrmaztatott osztlyok: "+trWriteList(numEntries)+".";
    }

    /*! used in member documentation blocks to produce a list of 
     *  members that are hidden by this one.
     */
    QCString trReimplementedFromList(int numEntries)
    {
      return "jra implementlva ebbl az osztlybl: "+trWriteList(numEntries)+".";
    }

    /*! used in member documentation blocks to produce a list of
     *  all member that overwrite the implementation of this member.
     */
    QCString trReimplementedInList(int numEntries)
    {
      return "jra implementlva ebben az osztlyban: "+trWriteList(numEntries)+".";
    }

    /*! This is put above each page as a link to all members of namespaces. */
    QCString trNamespaceMembers()
    { return "Nvtr tagjai"; }

    /*! This is an introduction to the page with all namespace members */
    QCString trNamespaceMemberDescription(bool extractAll)
    { 
      QCString result="Ez az sszes ";
      if (!extractAll) result+="dokumentlt ";
      result+="nvtr tagjainak listja ";
      if (extractAll) 
        result+="a hozzjuk tartoz dokumentcira val hivatkozssal:";
      else 
        result+="az ket tartalmaz nvtrrel:";
      return result;
    }
    /*! This is used in LaTeX as the title of the chapter with the 
     *  index of all namespaces.
     */
    QCString trNamespaceIndex()
    { return "Nvtr index"; }

    /*! This is used in LaTeX as the title of the chapter containing
     *  the documentation of all namespaces.
     */
    QCString trNamespaceDocumentation()
    { return "Nvtr documentci"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990522
//////////////////////////////////////////////////////////////////////////

    /*! This is used in the documentation before the list of all
     *  namespaces in a file.
     */
    QCString trNamespaces()
    { return "Nvterek"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990728
//////////////////////////////////////////////////////////////////////////

    /*! This is put at the bottom of a class documentation page and is
     *  followed by a list of files that were used to generate the page.
     */
    QCString trGeneratedFromFiles(ClassDef::CompoundType compType,
        bool single)
    { // here s is one of " Class", " Struct" or " Union"
      // single is true implies a single file
      QCString result=(QCString)"Ez a dokumentci ";
      switch(compType)
      {
        case ClassDef::Class:      result+="az osztlyrl"; break;
        case ClassDef::Struct:     result+="a struktrrl"; break;
        case ClassDef::Union:      result+="az unirl"; break;
        case ClassDef::Interface:  result+="az interfszrl"; break;
        case ClassDef::Exception:  result+="a kivtelrl"; break;
      }
      result+=" a kvetkez fjl";
      if (!single) result+="ok";
      result+=" alapjn kszlt:";
      return result;
    }

    /*! This is in the (quick) index as a link to the alphabetical compound
     * list.
     */
    QCString trAlphabeticalList()
    { return "bc rendes lista"; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-990901
//////////////////////////////////////////////////////////////////////////

    /*! This is used as the heading text for the retval command. */
    QCString trReturnValues()
    { return "Visszaadott rtkek"; }

    /*! This is in the (quick) index as a link to the main page (index.html)
     */
    QCString trMainPage()
    { return "Kezd lap"; }

    /*! This is used in references to page that are put in the LaTeX 
     *  documentation. It should be an abbreviation of the word page.
     */
    QCString trPageAbbreviation()
    { return "o."; }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991003
//////////////////////////////////////////////////////////////////////////

    QCString trSources()
    {
      return "Forrsok";
    }
    QCString trDefinedAtLineInSourceFile()
    {
      return "Definci a(z) @1 fjl @0. sorban.";
    }
    QCString trDefinedInSourceFile()
    {
      return "Definci a(z) @0 fjlban.";
    }

//////////////////////////////////////////////////////////////////////////
// new since 0.49-991205
//////////////////////////////////////////////////////////////////////////

    QCString trDeprecated()
    {
      return "Ellenjavallt";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.0.0
//////////////////////////////////////////////////////////////////////////

    /*! this text is put before a collaboration diagram */
    QCString trCollaborationDiagram(const char *clName)
    {
      return (QCString)"Egyttmkdsi diagram "+clName+" osztlyhoz:";
    }
    /*! this text is put before an include dependency graph */
    QCString trInclDepGraph(const char *fName)
    {
      return (QCString)"Defincis fjl fggsi bra "+fName+" fjlhoz:";
    }
    /*! header that is put before the list of constructor/destructors. */
    QCString trConstructorDocumentation()
    {
      return "Konstruktor s destruktor dokumentci"; 
    }
    /*! Used in the file documentation to point to the corresponding sources. */
    QCString trGotoSourceCode()
    {
      return "Ugrs a fjl forrshoz.";
    }
    /*! Used in the file sources to point to the corresponding documentation. */
    QCString trGotoDocumentation()
    {
      return "Ugrs a fjl dokumentcijhoz.";
    }
    /*! Text for the \\pre command */
    QCString trPrecondition()
    {
      return "Elfelttel";
    }
    /*! Text for the \\post command */
    QCString trPostcondition()
    {
      return "Utfelttel";
    }
    /*! Text for the \\invariant command */
    QCString trInvariant()
    {
      return "Invarins";
    }
    /*! Text shown before a multi-line variable/enum initialization */
    QCString trInitialValue()
    {
      return "Kezd rtk:";
    }
    /*! Text used the source code in the file index */
    QCString trCode()
    {
      return "forrskd";
    }
    QCString trGraphicalHierarchy()
    {
      return "Osztly-hierarchia grafikon";
    }
    QCString trGotoGraphicalHierarchy()
    {
      return "Ugrs az osztly-hierarchia grafikonhoz";
    }
    QCString trGotoTextualHierarchy()
    {
      return "Ugrs az osztly-hierarchia lershoz";
    }
    QCString trPageIndex()
    {
      return "Oldal index";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.0
//////////////////////////////////////////////////////////////////////////
    
    QCString trNote()
    {
      return "Megjegyzs";
    }
    QCString trPublicTypes()
    {
      return "Publikus tpusok";
    }
    QCString trPublicAttribs()
    {
      return "Publikus attribtumok";
    }
    QCString trStaticPublicAttribs()
    {
      return "Statikus publikus attribtumok";
    }
    QCString trProtectedTypes()
    {
      return "Vdett tpusok";
    }
    QCString trProtectedAttribs()
    {
      return "Vdett attribtumok";
    }
    QCString trStaticProtectedAttribs()
    {
      return "Statikus vdett attribtumok";
    }
    QCString trPrivateTypes()
    {
      return "Privt tpusok";
    }
    QCString trPrivateAttribs()
    {
      return "Privt attribtumok";
    }
    QCString trStaticPrivateAttribs()
    {
      return "Statikus privt attribtumok";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.3
//////////////////////////////////////////////////////////////////////////

    /*! Used as a marker that is put before a todo item */
    QCString trTodo()
    {
      return "Tennival";
    }
    /*! Used as the header of the todo list */
    QCString trTodoList()
    {
      return "Tennivalk listja";
    }

//////////////////////////////////////////////////////////////////////////
// new since 1.1.4
//////////////////////////////////////////////////////////////////////////

    QCString trReferencedBy()
    {
      return "hivatkozs innen:";
    }
    QCString trRemarks()
    {
      return "Megjegyzsek";
    }
    QCString trAttention()
    {
      return "Figyelem";
    }
    QCString trInclByDepGraph()
    {
      return "Ez az bra azt mutatja, hogy mely fjlok gyazzk be "
             "kzvetve vagy kzvetlenl ezt a fjlt:";
    }
    QCString trSince()
    {
      return "Elszr bevezetve";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.1.5
//////////////////////////////////////////////////////////////////////////

    /*! title of the graph legend page */
    QCString trLegendTitle()
    {
      return "Jelmagyarzat";
    }
    /*! page explaining how the dot graph's should be interpreted */
    QCString trLegendDocs()
    {
      return 
        "Hogyan rtelmezzk a DopxyGen ltal ksztett brkat?<p>\n"
        "Vegyk a kvetkez pldt:\n"
        "\\code\n"
        "/*! Nem lthat osztly, nem fr ki, vgsra kerl */\n"
        "class Invisible { };\n\n"
        "/*! Szrmaztats rejtett */\n"
        "class Truncated : public Invisible { };\n\n"
        "/* Nem dokumentlt osztly */\n"
        "class Undocumented { };\n\n"
        "/*! Publikus szrmaztatsal levezetett osztly */\n"
        "class PublicBase : public Truncated { };\n\n"
        "/*! Vdett szrmaztatsal levezetett osztly */\n"
        "class ProtectedBase { };\n\n"
        "/*! Privt szrmaztatsal levezetett osztly */\n"
        "class PrivateBase { };\n\n"
        "/*! Osztly, melyet a szrmaztatott osztly hasznl */\n"
        "class Used { };\n\n"
        "/*! Osztly, mely tbb msiknak leszrmazottja */\n"
        "class Inherited : public PublicBase,\n"
        "                  protected ProtectedBase,\n"
        "                  private PrivateBase,\n"
        "                  public Undocumented\n"
        "{\n"
        "  private:\n"
        "    Used *m_usedClass;\n"
        "};\n"
        "\\endcode\n"
        "Ha a konfigurcis fjl \\c MAX_DOT_GRAPH_HEIGHT elemnek rtkt "
        "200-ra lltjuk, az eredmny a kvetkez bra lesz:"
        "<p><center><img src=\"graph_legend.gif\"></center>\n"
        "<p>\n"
        "Az brn lev dobozok jelentse:\n"
        "<ul>\n"
        "<li>Kitlttt fekete doboz jelzi azt az osztlyt vagy struktrt,"
        "amelyrl az bra szl.\n"
        "<li>Fekete keret jelszi a dokumentlt osztlyokat vagy struktrkat.\n"
        "<li>Szrke keret jelzi a nem dokumentlt osztlyokat vagy struktrkat.\n"
        "<li>Piros keret jelzi azokat az osztlyokat vagy struktrkat, amelyeknl vgs miatt nem lthat "
        "az sszes leszrmaztatsi kapcsolat. Egy bra vgsra kerl, ha nem fr bele "
        "a megadott tartomnyba."
        "</ul>\n"
        "A nyilak jelentse:\n"
        "<ul>\n"
        "<li>Sttkk nyl jelzi a publikus szrmaztatst.\n"
        "<li>Sttzld nyl jelzi a vdett szrmaztatst.\n"
        "<li>Sttvrs nyl jelzi a privt szrmaztatst.\n"
        "<li>Lila szaggatott nyl jelzi, ha az osztly egy msikat hasznl vagy tartalmaz. "
        "A nyl felirata jelzi a vltozk nevt, amelyeken keresztl a msik osztly kapcsoldik.\n"
        "</ul>\n";

    }
    /*! text for the link to the legend page */
    QCString trLegend()
    {
      return "Jelmagyarzat";
    }
    
//////////////////////////////////////////////////////////////////////////
// new since 1.2.0
//////////////////////////////////////////////////////////////////////////
    
    /*! Used as a marker that is put before a test item */
    QCString trTest()
    {
      return "Teszt";
    }
    /*! Used as the header of the test list */
    QCString trTestList()
    {
      return "Teszt lista";
    }

};

#endif
